/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.verbose.event;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.Locale;
import me.lucko.luckperms.common.cacheddata.result.TristateResult;
import me.lucko.luckperms.common.node.utils.NodeJsonSerializer;
import me.lucko.luckperms.common.util.gson.JObject;
import me.lucko.luckperms.common.verbose.VerboseCheckTarget;
import me.lucko.luckperms.common.verbose.event.CheckOrigin;
import me.lucko.luckperms.common.verbose.event.VerboseEvent;
import me.lucko.luckperms.common.verbose.event.VerboseEventType;
import net.luckperms.api.query.QueryOptions;

public class PermissionCheckEvent
extends VerboseEvent {
    private final String permission;
    private final TristateResult result;

    public PermissionCheckEvent(CheckOrigin origin, VerboseCheckTarget checkTarget, QueryOptions checkQueryOptions, long checkTime, Throwable checkTrace, String checkThread, String permission, TristateResult result) {
        super(origin, checkTarget, checkQueryOptions, checkTime, checkTrace, checkThread);
        this.permission = permission;
        this.result = result;
    }

    public String getPermission() {
        return this.permission;
    }

    public TristateResult getResult() {
        return this.result;
    }

    @Override
    public VerboseEventType getType() {
        return VerboseEventType.PERMISSION;
    }

    @Override
    protected void serializeTo(JObject object) {
        object.add("permission", this.permission);
        object.add("result", this.result.result().name().toLowerCase(Locale.ROOT));
        if (this.result != TristateResult.UNDEFINED) {
            object.add("resultInfo", PermissionCheckEvent.serializeResult(this.result));
        }
    }

    private static JObject serializeResult(TristateResult result) {
        JObject object = new JObject();
        object.add("result", result.result().name().toLowerCase(Locale.ROOT));
        if (result.processorClass() != null) {
            object.add("processorClass", result.processorClass().getName());
        }
        if (result.node() != null) {
            object.add("node", (JsonElement)NodeJsonSerializer.serializeNode(result.node(), true));
        }
        if (result.overriddenResult() != null) {
            JsonArray overridden = new JsonArray();
            for (TristateResult next = result.overriddenResult(); next != null; next = next.overriddenResult()) {
                overridden.add((JsonElement)PermissionCheckEvent.serializeResult(next).toJson());
            }
            object.add("overridden", (JsonElement)overridden);
        }
        return object;
    }

    @Override
    public boolean eval(String variable) {
        return variable.equals("permission") || this.getCheckTarget().describe().equalsIgnoreCase(variable) || this.getPermission().toLowerCase(Locale.ROOT).startsWith(variable.toLowerCase(Locale.ROOT)) || this.getResult().result().name().equalsIgnoreCase(variable);
    }
}

