/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.webeditor.socket;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Base64;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import me.lucko.luckperms.common.http.BytesocksClient;
import me.lucko.luckperms.common.http.UnsuccessfulRequestException;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.plugin.scheduler.SchedulerTask;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.gson.GsonProvider;
import me.lucko.luckperms.common.util.gson.JObject;
import me.lucko.luckperms.common.webeditor.WebEditorRequest;
import me.lucko.luckperms.common.webeditor.WebEditorSession;
import me.lucko.luckperms.common.webeditor.socket.CryptographyUtils;
import me.lucko.luckperms.common.webeditor.socket.SocketMessageType;
import me.lucko.luckperms.common.webeditor.socket.listener.WebEditorSocketListener;

public class WebEditorSocket {
    private static final int PROTOCOL_VERSION = 1;
    private final LuckPermsPlugin plugin;
    private final Sender sender;
    private final WebEditorSession session;
    private final WebEditorSocketListener listener;
    private final KeyPair pluginKeyPair;
    private BytesocksClient.Socket socket;
    private SchedulerTask keepaliveTask;
    private PublicKey remotePublicKey;
    private boolean closed = false;

    public WebEditorSocket(LuckPermsPlugin plugin, Sender sender, WebEditorSession session) {
        this.plugin = plugin;
        this.sender = sender;
        this.session = session;
        this.listener = new WebEditorSocketListener(this);
        this.pluginKeyPair = plugin.getWebEditorStore().keyPair();
    }

    public void initialize(BytesocksClient client) throws UnsuccessfulRequestException, IOException {
        this.socket = client.createSocket(this.listener);
    }

    public void waitForConnect(long timeout, TimeUnit unit) {
        try {
            this.listener.connectFuture().get(timeout, unit);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new RuntimeException("Timed out waiting to socket to connect", e);
        }
    }

    public void appendDetailToRequest(WebEditorRequest request) {
        String channelId = this.socket.channelId();
        String publicKey = Base64.getEncoder().encodeToString(this.pluginKeyPair.getPublic().getEncoded());
        JsonObject socket = new JsonObject();
        socket.addProperty("protocolVersion", (Number)1);
        socket.addProperty("channelId", channelId);
        socket.addProperty("publicKey", publicKey);
        JsonObject payload = request.getPayload();
        payload.add("socket", (JsonElement)socket);
    }

    public void send(JsonObject msg) {
        String encoded = GsonProvider.normal().toJson((JsonElement)msg);
        String signature = CryptographyUtils.sign(this.pluginKeyPair.getPrivate(), encoded);
        JsonObject frame = new JObject().add("msg", encoded).add("signature", signature).toJson();
        this.socket.socket().send(GsonProvider.normal().toJson((JsonElement)frame));
    }

    public boolean trustConnection(String nonce) {
        if (this.listener.shouldIgnoreMessages()) {
            return false;
        }
        if (this.remotePublicKey != null) {
            return false;
        }
        PublicKey publicKey = this.listener.helloHandler().getAttemptedConnection(nonce);
        if (publicKey == null) {
            return false;
        }
        this.remotePublicKey = publicKey;
        this.plugin.getWebEditorStore().keystore().trust(this.sender, this.remotePublicKey.getEncoded());
        this.send(SocketMessageType.HELLO_REPLY.builder().add("nonce", nonce).add("state", "trusted").toJson());
        return true;
    }

    public void scheduleCleanupIfUnused() {
        this.plugin.getBootstrap().getScheduler().asyncLater(this::afterOpenFor1Minute, 1L, TimeUnit.MINUTES);
    }

    private void afterOpenFor1Minute() {
        if (this.closed) {
            return;
        }
        if (this.remotePublicKey == null && !this.listener.helloHandler().hasAttemptedConnection()) {
            this.closeSocket();
        } else {
            this.keepaliveTask = this.plugin.getBootstrap().getScheduler().asyncRepeating(this::keepalive, 10L, TimeUnit.SECONDS);
        }
    }

    private void keepalive() {
        if (System.currentTimeMillis() - this.listener.pingHandler().getLastPing() > TimeUnit.MINUTES.toMillis(1L)) {
            this.cancelKeepalive();
            this.closeSocket();
        }
    }

    public void close() {
        try {
            this.send(SocketMessageType.PONG.builder().add("ok", false).toJson());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cancelKeepalive();
        this.closeSocket();
    }

    private void closeSocket() {
        this.socket.socket().close(1000, "Normal");
        this.plugin.getWebEditorStore().sockets().removeSocket(this);
        this.closed = true;
    }

    private void cancelKeepalive() {
        if (this.keepaliveTask != null) {
            this.keepaliveTask.cancel();
            this.keepaliveTask = null;
        }
    }

    public LuckPermsPlugin getPlugin() {
        return this.plugin;
    }

    public Sender getSender() {
        return this.sender;
    }

    public WebEditorSession getSession() {
        return this.session;
    }

    public BytesocksClient.Socket getSocket() {
        return this.socket;
    }

    public PublicKey getRemotePublicKey() {
        return this.remotePublicKey;
    }

    public void setRemotePublicKey(PublicKey remotePublicKey) {
        this.remotePublicKey = remotePublicKey;
    }

    public boolean isClosed() {
        return this.closed;
    }
}

