/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.fabric.context;

import java.util.Optional;
import java.util.Set;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.context.ImmutableContextSetImpl;
import me.lucko.luckperms.common.util.EnumNamer;
import me.lucko.luckperms.fabric.LPFabricPlugin;
import me.lucko.luckperms.fabric.event.PlayerChangeWorldCallback;
import net.luckperms.api.context.Context;
import net.luckperms.api.context.ContextCalculator;
import net.luckperms.api.context.ContextConsumer;
import net.luckperms.api.context.ContextSet;
import net.minecraft.class_1934;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.NotNull;

public class FabricPlayerCalculator
implements ContextCalculator<class_3222> {
    private static final EnumNamer<class_1934> GAMEMODE_NAMER = new EnumNamer(class_1934.class, EnumNamer.LOWER_CASE_NAME);
    private final LPFabricPlugin plugin;
    private final boolean gamemode;
    private final boolean world;

    public FabricPlayerCalculator(LPFabricPlugin plugin, Set<String> disabled) {
        this.plugin = plugin;
        this.gamemode = !disabled.contains("gamemode");
        this.world = !disabled.contains("world");
    }

    public void registerListeners() {
        PlayerChangeWorldCallback.EVENT.register(this::onWorldChange);
    }

    @Override
    public void calculate(@NonNull class_3222 target, @NonNull ContextConsumer consumer) {
        class_1934 mode = target.field_13974.method_14257();
        int GAME_MODE_NOT_SET = -1;
        if (this.gamemode && mode != null && mode.method_8379() != -1) {
            consumer.accept("gamemode", GAMEMODE_NAMER.name(mode));
        }
        class_3218 world = target.method_51469();
        if (this.world) {
            this.plugin.getConfiguration().get(ConfigKeys.WORLD_REWRITES).rewriteAndSubmit(FabricPlayerCalculator.getContextKey(world.method_27983().method_29177()), consumer);
        }
    }

    @Override
    public @NonNull @NotNull ContextSet estimatePotentialContexts() {
        ImmutableContextSetImpl.BuilderImpl builder = new ImmutableContextSetImpl.BuilderImpl();
        if (this.gamemode) {
            for (class_1934 mode : class_1934.values()) {
                builder.add("gamemode", GAMEMODE_NAMER.name(mode));
            }
        }
        Optional<MinecraftServer> server = this.plugin.getBootstrap().getServer();
        if (this.world && server.isPresent()) {
            Iterable worlds = server.get().method_3738();
            for (class_3218 world : worlds) {
                String worldName = FabricPlayerCalculator.getContextKey(world.method_27983().method_29177());
                if (!Context.isValidValue(worldName)) continue;
                builder.add("world", worldName);
            }
        }
        return builder.build();
    }

    private static String getContextKey(class_2960 key) {
        if (key.method_12836().equals("minecraft")) {
            return key.method_12832();
        }
        return key.toString();
    }

    private void onWorldChange(class_3218 origin, class_3218 destination, class_3222 player) {
        if (this.world) {
            this.plugin.getContextManager().invalidateCache(player);
            this.plugin.getContextManager().signalContextUpdate(player);
        }
    }
}

