/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.showmeyourskin.net;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.Unpooled;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import nl.enjarai.showmeyourskin.ShowMeYourSkin;
import org.slf4j.Logger;

public class HandshakeServer<T> {
    private final Codec<T> transferCodec;
    private final Supplier<T> configSupplier;
    private final Map<class_3222, HandshakeState> syncStates = new WeakHashMap<class_3222, HandshakeState>();

    public HandshakeServer(Codec<T> transferCodec, Supplier<T> configSupplier) {
        this.transferCodec = transferCodec;
        this.configSupplier = configSupplier;
    }

    public HandshakeState getHandshakeState(class_3222 player) {
        return this.syncStates.getOrDefault(player, HandshakeState.NOT_SENT);
    }

    public class_2540 getConfigSyncBuf(class_3222 player) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        T config = this.configSupplier.get();
        DataResult data = this.transferCodec.encodeStart((DynamicOps)class_2509.field_11560, config);
        try {
            buf.method_10794((class_2487)data.getOrThrow(false, arg_0 -> ((Logger)ShowMeYourSkin.LOGGER).error(arg_0)));
        }
        catch (RuntimeException e) {
            ShowMeYourSkin.LOGGER.error("Failed to encode config", (Throwable)e);
            buf.method_10794(new class_2487());
        }
        return buf;
    }

    public void configSentToClient(class_3222 player) {
        this.syncStates.put(player, HandshakeState.SENT);
    }

    public HandshakeState clientReplied(class_3222 player, class_2540 buf) {
        HandshakeState state = this.getHandshakeState(player);
        if (state == HandshakeState.SENT) {
            if (buf.readBoolean()) {
                this.syncStates.put(player, HandshakeState.ACCEPTED);
                ShowMeYourSkin.LOGGER.info("Client of {} accepted server config.", (Object)player.method_5477().getString());
                return HandshakeState.ACCEPTED;
            }
            this.syncStates.put(player, HandshakeState.FAILED);
            ShowMeYourSkin.LOGGER.warn("Client of {} failed to process server config, check client logs find what went wrong.", (Object)player.method_5477().getString());
            return HandshakeState.FAILED;
        }
        return state;
    }

    public void playerDisconnected(class_3222 player) {
        this.syncStates.remove(player);
    }

    public static enum HandshakeState {
        NOT_SENT,
        SENT,
        ACCEPTED,
        FAILED;

    }
}

