/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.client;

import com.yyon.grapplinghook.GrappleMod;
import com.yyon.grapplinghook.blockentity.GrappleModifierBlockEntity;
import com.yyon.grapplinghook.client.ClientControllerManager;
import com.yyon.grapplinghook.client.GrappleModClientCheck;
import com.yyon.grapplinghook.client.keybind.GrappleKeys;
import com.yyon.grapplinghook.client.keybind.GrappleModKeyBindings;
import com.yyon.grapplinghook.client.keybind.MCKeys;
import com.yyon.grapplinghook.config.GrappleConfig;
import com.yyon.grapplinghook.controller.AirfrictionController;
import com.yyon.grapplinghook.controller.ForcefieldController;
import com.yyon.grapplinghook.controller.GrappleController;
import com.yyon.grapplinghook.entity.grapplehook.GrapplehookEntity;
import com.yyon.grapplinghook.entity.grapplehook.GrapplehookEntityRenderer;
import com.yyon.grapplinghook.gui.GrappleModiferBlockGUI;
import com.yyon.grapplinghook.item.GrapplehookItem;
import com.yyon.grapplinghook.network.NetworkContext;
import com.yyon.grapplinghook.network.NetworkManager;
import com.yyon.grapplinghook.network.clientbound.BaseMessageClient;
import com.yyon.grapplinghook.registry.GrappleModEntities;
import com.yyon.grapplinghook.registry.GrappleModEntityRenderLayers;
import com.yyon.grapplinghook.registry.GrappleModItems;
import com.yyon.grapplinghook.util.GrappleCustomization;
import com.yyon.grapplinghook.util.GrappleModUtils;
import com.yyon.grapplinghook.util.Vec;
import java.util.Optional;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3419;
import net.minecraft.class_437;
import net.minecraft.class_5272;
import net.minecraft.class_5617;
import net.minecraft.class_5819;
import net.minecraft.class_746;
import net.minecraft.class_897;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class GrappleModClient
implements ClientModInitializer {
    private static GrappleModClient clientInstance;
    private static final class_2960 SOUND_DOUBLE_JUMP;
    private static final class_2960 SOUND_SLIDE;
    private ClientControllerManager clientControllerManager;

    public void onInitializeClient() {
        clientInstance = this;
        GrappleModClientCheck.clientLoaded = true;
        EntityRendererRegistry.register((class_1299)((class_1299)GrappleModEntities.GRAPPLE_HOOK.get()), (class_5617)new GrapplehookEntityRenderFactory());
        GrappleModKeyBindings.registerAll();
        GrappleModEntityRenderLayers.registerAll();
        NetworkManager.registerClientPacketListeners();
        this.clientControllerManager = new ClientControllerManager();
        this.registerPropertyOverride();
        this.registerResourcePacks();
    }

    public static GrappleModClient get() {
        return clientInstance;
    }

    public void registerPropertyOverride() {
        class_5272.method_27879((class_1792)((class_1792)GrappleModItems.GRAPPLING_HOOK.get()), (class_2960)new class_2960("rocket"), (stack, world, entity, seed) -> ((GrapplehookItem)GrappleModItems.GRAPPLING_HOOK.get()).getPropertyRocket(stack, (class_1937)world, entity) ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)((class_1792)GrappleModItems.GRAPPLING_HOOK.get()), (class_2960)new class_2960("double"), (stack, world, entity, seed) -> ((GrapplehookItem)GrappleModItems.GRAPPLING_HOOK.get()).getPropertyDouble(stack, (class_1937)world, entity) ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)((class_1792)GrappleModItems.GRAPPLING_HOOK.get()), (class_2960)new class_2960("motor"), (stack, world, entity, seed) -> ((GrapplehookItem)GrappleModItems.GRAPPLING_HOOK.get()).getPropertyMotor(stack, (class_1937)world, entity) ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)((class_1792)GrappleModItems.GRAPPLING_HOOK.get()), (class_2960)new class_2960("smart"), (stack, world, entity, seed) -> ((GrapplehookItem)GrappleModItems.GRAPPLING_HOOK.get()).getPropertySmart(stack, (class_1937)world, entity) ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)((class_1792)GrappleModItems.GRAPPLING_HOOK.get()), (class_2960)new class_2960("enderstaff"), (stack, world, entity, seed) -> ((GrapplehookItem)GrappleModItems.GRAPPLING_HOOK.get()).getPropertyEnderstaff(stack, (class_1937)world, entity) ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)((class_1792)GrappleModItems.GRAPPLING_HOOK.get()), (class_2960)new class_2960("magnet"), (stack, world, entity, seed) -> ((GrapplehookItem)GrappleModItems.GRAPPLING_HOOK.get()).getPropertyMagnet(stack, (class_1937)world, entity) ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)((class_1792)GrappleModItems.GRAPPLING_HOOK.get()), (class_2960)new class_2960("attached"), (stack, world, entity, seed) -> {
            if (entity == null) {
                return 0.0f;
            }
            return ClientControllerManager.controllers.containsKey(entity.method_5628()) && !(ClientControllerManager.controllers.get(entity.method_5628()) instanceof AirfrictionController) ? 1.0f : 0.0f;
        });
        class_5272.method_27879((class_1792)((class_1792)GrappleModItems.FORCE_FIELD.get()), (class_2960)new class_2960("attached"), (stack, world, entity, seed) -> {
            if (entity == null) {
                return 0.0f;
            }
            return ClientControllerManager.controllers.containsKey(entity.method_5628()) && ClientControllerManager.controllers.get(entity.method_5628()) instanceof ForcefieldController ? 1.0f : 0.0f;
        });
        class_5272.method_27879((class_1792)((class_1792)GrappleModItems.GRAPPLING_HOOK.get()), (class_2960)new class_2960("hook"), (stack, world, entity, seed) -> ((GrapplehookItem)GrappleModItems.GRAPPLING_HOOK.get()).getPropertyHook(stack, (class_1937)world, entity) ? 1.0f : 0.0f);
    }

    public void registerResourcePacks() {
        Optional cont = FabricLoader.getInstance().getModContainer("grapplemod");
        if (cont.isEmpty()) {
            GrappleMod.LOGGER.error("Unable to register resource packs! This mod technically doesn't exist!!");
            return;
        }
        ModContainer container = (ModContainer)cont.get();
        GrappleModUtils.registerPack("original_textures", (class_2561)class_2561.method_43471((String)"pack.grapplemod.original"), container, ResourcePackActivationType.NORMAL);
    }

    public void startRocket(class_1657 player, GrappleCustomization custom) {
        ClientControllerManager.instance.startRocket(player, custom);
    }

    public String getKeyname(MCKeys keyEnum) {
        String displayName;
        class_315 gs = class_310.method_1551().field_1690;
        class_304 binding = switch (keyEnum) {
            default -> throw new IncompatibleClassChangeError();
            case MCKeys.keyBindUseItem -> gs.field_1904;
            case MCKeys.keyBindForward -> gs.field_1894;
            case MCKeys.keyBindLeft -> gs.field_1913;
            case MCKeys.keyBindBack -> gs.field_1881;
            case MCKeys.keyBindRight -> gs.field_1849;
            case MCKeys.keyBindJump -> gs.field_1903;
            case MCKeys.keyBindSneak -> gs.field_1832;
            case MCKeys.keyBindAttack -> gs.field_1886;
        };
        return switch (displayName = binding.method_16007().getString()) {
            case "Button 1" -> "Left Click";
            case "Button 2" -> "Right Click";
            default -> displayName;
        };
    }

    public void openModifierScreen(GrappleModifierBlockEntity tile) {
        class_310.method_1551().method_1507((class_437)new GrappleModiferBlockGUI(tile));
    }

    public void onMessageReceivedClient(BaseMessageClient msg, NetworkContext ctx) {
        msg.processMessage(ctx);
    }

    public void playSlideSound() {
        this.playSound(SOUND_SLIDE, GrappleConfig.getClientConf().sounds.slide_sound_volume);
    }

    public void playDoubleJumpSound() {
        this.playSound(SOUND_DOUBLE_JUMP, GrappleConfig.getClientConf().sounds.doublejump_sound_volume * 0.7f);
    }

    public void playWallrunJumpSound() {
        this.playSound(SOUND_DOUBLE_JUMP, GrappleConfig.getClientConf().sounds.wallrunjump_sound_volume * 0.7f);
    }

    public void resetLauncherTime(int playerId) {
        ClientControllerManager.instance.resetLauncherTime(playerId);
    }

    public void launchPlayer(class_1657 player) {
        ClientControllerManager.instance.launchPlayer(player);
    }

    public void updateRocketRegen(double rocketActiveTime, double rocketRefuelRatio) {
        ClientControllerManager.instance.updateRocketRegen(rocketActiveTime, rocketRefuelRatio);
    }

    public double getRocketFunctioning() {
        return ClientControllerManager.instance.getRocketFunctioning();
    }

    public boolean isWallRunning(class_1297 entity, Vec motion) {
        return ClientControllerManager.instance.isWallRunning(entity, motion);
    }

    public boolean isSliding(class_1297 entity, Vec motion) {
        return ClientControllerManager.instance.isSliding(entity, motion);
    }

    public GrappleController createControl(int id, int hookEntityId, int entityId, class_1937 world, Vec pos, class_2338 blockpos, GrappleCustomization custom) {
        return ClientControllerManager.instance.createControl(id, hookEntityId, entityId, world, blockpos, custom);
    }

    public boolean isKeyDown(GrappleKeys key) {
        return switch (key) {
            default -> throw new IncompatibleClassChangeError();
            case GrappleKeys.key_boththrow -> GrappleModKeyBindings.key_boththrow.method_1434();
            case GrappleKeys.key_leftthrow -> GrappleModKeyBindings.key_leftthrow.method_1434();
            case GrappleKeys.key_rightthrow -> GrappleModKeyBindings.key_rightthrow.method_1434();
            case GrappleKeys.key_motoronoff -> GrappleModKeyBindings.key_motoronoff.method_1434();
            case GrappleKeys.key_jumpanddetach -> GrappleModKeyBindings.key_jumpanddetach.method_1434();
            case GrappleKeys.key_slow -> GrappleModKeyBindings.key_slow.method_1434();
            case GrappleKeys.key_climb -> GrappleModKeyBindings.key_climb.method_1434();
            case GrappleKeys.key_climbup -> GrappleModKeyBindings.key_climbup.method_1434();
            case GrappleKeys.key_climbdown -> GrappleModKeyBindings.key_climbdown.method_1434();
            case GrappleKeys.key_enderlaunch -> GrappleModKeyBindings.key_enderlaunch.method_1434();
            case GrappleKeys.key_rocket -> GrappleModKeyBindings.key_rocket.method_1434();
            case GrappleKeys.key_slide -> GrappleModKeyBindings.key_slide.method_1434();
        };
    }

    public GrappleController unregisterController(int entityId) {
        return ClientControllerManager.unregisterController(entityId);
    }

    public double getTimeSinceLastRopeJump(class_1937 world) {
        return GrappleModUtils.getTime(world) - ClientControllerManager.prevRopeJumpTime;
    }

    public void resetRopeJumpTime(class_1937 world) {
        ClientControllerManager.prevRopeJumpTime = GrappleModUtils.getTime(world);
    }

    public boolean isKeyDown(MCKeys keyEnum) {
        class_315 options = class_310.method_1551().field_1690;
        return switch (keyEnum) {
            default -> throw new IncompatibleClassChangeError();
            case MCKeys.keyBindUseItem -> options.field_1904.method_1434();
            case MCKeys.keyBindForward -> options.field_1894.method_1434();
            case MCKeys.keyBindLeft -> options.field_1913.method_1434();
            case MCKeys.keyBindBack -> options.field_1881.method_1434();
            case MCKeys.keyBindRight -> options.field_1849.method_1434();
            case MCKeys.keyBindJump -> options.field_1903.method_1434();
            case MCKeys.keyBindSneak -> options.field_1832.method_1434();
            case MCKeys.keyBindAttack -> options.field_1886.method_1434();
        };
    }

    public boolean isMovingSlowly(class_1297 entity) {
        if (entity instanceof class_746) {
            class_746 player = (class_746)entity;
            return player.method_20303();
        }
        return false;
    }

    public void playSound(class_2960 loc, float volume) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        class_310.method_1551().method_1483().method_4873((class_1113)new class_1109(loc, class_3419.field_15248, volume, 1.0f, class_5819.method_43047(), false, 0, class_1113.class_1114.field_5478, player.method_23317(), player.method_23318(), player.method_23321(), false));
    }

    public int getWallrunTicks() {
        return ClientControllerManager.instance.ticksWallRunning;
    }

    public void setWallrunTicks(int newWallrunTicks) {
        ClientControllerManager.instance.ticksWallRunning = newWallrunTicks;
    }

    public ClientControllerManager getClientControllerManager() {
        return this.clientControllerManager;
    }

    static {
        SOUND_DOUBLE_JUMP = new class_2960("grapplemod", "doublejump");
        SOUND_SLIDE = new class_2960("grapplemod", "slide");
    }

    private static class GrapplehookEntityRenderFactory
    implements class_5617<GrapplehookEntity> {
        private GrapplehookEntityRenderFactory() {
        }

        @NotNull
        public class_897<GrapplehookEntity> create(class_5617.class_5618 manager) {
            return new GrapplehookEntityRenderer<GrapplehookEntity>(manager, (class_1792)GrappleModItems.GRAPPLING_HOOK.get());
        }
    }
}

