/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.controller;

import com.yyon.grapplinghook.client.GrappleModClient;
import com.yyon.grapplinghook.config.GrappleConfig;
import com.yyon.grapplinghook.controller.GrappleController;
import com.yyon.grapplinghook.util.GrappleCustomization;
import com.yyon.grapplinghook.util.Vec;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;

public class AirfrictionController
extends GrappleController {
    public int ignoreGroundCounter = 0;
    public boolean wasSliding = false;
    public boolean wasWallrunning = false;
    public boolean wasRocket = false;
    public boolean firstTickSinceCreated = true;

    public AirfrictionController(int grapplehookEntityId, int entityId, class_1937 world, int id, GrappleCustomization custom) {
        super(grapplehookEntityId, entityId, world, id, custom);
    }

    @Override
    public void updatePlayerPos() {
        class_1309 e;
        class_1297 entity = this.entity;
        if (entity == null) {
            return;
        }
        if (entity.method_5854() != null) {
            this.unattach();
            this.updateServerPos();
            return;
        }
        if (entity instanceof class_1309 && (e = (class_1309)entity).method_6101()) {
            this.unattach();
        }
        Vec additionalmotion = new Vec(0.0, 0.0, 0.0);
        if (!(!GrappleConfig.getConf().other.dont_override_movement_in_air || entity.method_24828() || this.wasSliding || this.wasWallrunning || this.wasRocket || this.firstTickSinceCreated)) {
            this.motion = Vec.motionVec(entity);
            this.unattach();
            return;
        }
        if (this.attached) {
            class_1309 entityLiving;
            boolean issliding = GrappleModClient.get().isSliding(entity, this.motion);
            if (issliding && !this.wasSliding) {
                this.playSlideSound();
            }
            if (this.ignoreGroundCounter <= 0) {
                this.normalGround(issliding);
                this.normalCollisions(issliding);
            }
            this.applyAirFriction();
            if (this.entity.method_5799() || this.entity.method_5771()) {
                this.unattach();
                return;
            }
            boolean doesrocket = false;
            if (this.custom != null && this.custom.rocket) {
                Vec rocket = this.rocket(entity);
                this.motion.add_ip(rocket);
                if (rocket.length() > 0.0) {
                    doesrocket = true;
                }
            }
            if (issliding) {
                this.applySlidingFriction();
            }
            boolean wallrun = this.applyWallrun();
            if (!issliding && !this.wasSliding) {
                if (wallrun) {
                    this.motion = this.motion.removeAlong(new Vec(0.0, 1.0, 0.0));
                    if (this.wallDirection != null) {
                        this.motion = this.motion.removeAlong(this.wallDirection);
                    }
                    Vec new_movement = this.playerMovement.changeLen(GrappleConfig.getConf().enchantments.wallrun.wallrun_speed * 1.5);
                    if (this.wallDirection != null) {
                        new_movement = new_movement.removeAlong(this.wallDirection);
                    }
                    if (new_movement.length() > GrappleConfig.getConf().enchantments.wallrun.wallrun_speed) {
                        new_movement.changeLen_ip(GrappleConfig.getConf().enchantments.wallrun.wallrun_speed);
                    }
                    Vec current_motion_along = this.motion.removeAlong(new Vec(0.0, 1.0, 0.0));
                    Vec new_motion_along = this.motion.add(new_movement).removeAlong(new Vec(0.0, 1.0, 0.0));
                    if (this.wallDirection != null) {
                        current_motion_along = current_motion_along.removeAlong(this.wallDirection);
                        new_motion_along = new_motion_along.removeAlong(this.wallDirection);
                    }
                    if (current_motion_along.length() <= GrappleConfig.getConf().enchantments.wallrun.wallrun_max_speed || current_motion_along.dot(new_movement) < 0.0) {
                        this.motion.add_ip(new_movement);
                        if (new_motion_along.length() > GrappleConfig.getConf().enchantments.wallrun.wallrun_max_speed) {
                            this.motion.changeLen_ip(GrappleConfig.getConf().enchantments.wallrun.wallrun_max_speed);
                        }
                    }
                    additionalmotion.add_ip(this.wallrunPressAgainstWall());
                } else {
                    double max_motion = GrappleConfig.getConf().other.airstrafe_max_speed;
                    double accel = GrappleConfig.getConf().other.airstrafe_acceleration;
                    Vec motion_horizontal = this.motion.removeAlong(new Vec(0.0, 1.0, 0.0));
                    double prev_motion = motion_horizontal.length();
                    Vec new_motion_horizontal = motion_horizontal.add(this.playerMovement.changeLen(accel));
                    double angle = motion_horizontal.angle(new_motion_horizontal);
                    if (new_motion_horizontal.length() > max_motion && new_motion_horizontal.length() > prev_motion) {
                        double ninety_deg = 1.5707963267948966;
                        double new_max_motion = max_motion;
                        if (angle < ninety_deg && prev_motion > max_motion) {
                            new_max_motion = prev_motion + (max_motion - prev_motion) * (angle / 1.5707963267948966);
                        }
                        new_motion_horizontal.changeLen_ip(new_max_motion);
                    }
                    this.motion.x = new_motion_horizontal.x;
                    this.motion.z = new_motion_horizontal.z;
                }
            }
            if (entity instanceof class_1309 && (entityLiving = (class_1309)entity).method_6128()) {
                this.unattach();
            }
            Vec gravity = new Vec(0.0, -0.1, 0.0);
            if (!wallrun) {
                this.motion.add_ip(gravity);
            }
            Vec newmotion = this.motion.add(additionalmotion);
            newmotion.setMotion(entity);
            this.updateServerPos();
            if (entity.method_24828() && !issliding && !wallrun) {
                if (!doesrocket) {
                    if (this.ignoreGroundCounter <= 0) {
                        this.unattach();
                    }
                } else {
                    this.motion = Vec.motionVec(entity);
                }
            }
            if (this.ignoreGroundCounter > 0) {
                --this.ignoreGroundCounter;
            }
            this.wasSliding = issliding;
            this.wasWallrunning = wallrun;
            this.wasRocket = doesrocket;
            this.firstTickSinceCreated = false;
        }
    }

    @Override
    public void receiveEnderLaunch(double x, double y, double z) {
        super.receiveEnderLaunch(x, y, z);
        this.ignoreGroundCounter = 2;
    }

    @Override
    public void slidingJump() {
        super.slidingJump();
        this.ignoreGroundCounter = 2;
    }

    public void playSlideSound() {
        GrappleModClient.get().playSlideSound();
    }
}

