/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.network;

import com.yyon.grapplinghook.GrappleMod;
import com.yyon.grapplinghook.network.LogicalSide;
import com.yyon.grapplinghook.network.NetworkContext;
import com.yyon.grapplinghook.network.clientbound.AddExtraDataMessage;
import com.yyon.grapplinghook.network.clientbound.BaseMessageClient;
import com.yyon.grapplinghook.network.clientbound.DetachSingleHookMessage;
import com.yyon.grapplinghook.network.clientbound.GrappleAttachMessage;
import com.yyon.grapplinghook.network.clientbound.GrappleAttachPosMessage;
import com.yyon.grapplinghook.network.clientbound.GrappleDetachMessage;
import com.yyon.grapplinghook.network.clientbound.LoggedInMessage;
import com.yyon.grapplinghook.network.clientbound.SegmentMessage;
import com.yyon.grapplinghook.network.serverbound.BaseMessageServer;
import com.yyon.grapplinghook.network.serverbound.GrappleEndMessage;
import com.yyon.grapplinghook.network.serverbound.GrappleModifierMessage;
import com.yyon.grapplinghook.network.serverbound.KeypressMessage;
import com.yyon.grapplinghook.network.serverbound.PlayerMovementMessage;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class NetworkManager {
    protected static ClientPlayNetworking.PlayChannelHandler generateClientPacketHandler(Function<class_2540, BaseMessageClient> packetFactory) {
        return (client, handler, buf, responseSender) -> {
            BaseMessageClient packet = (BaseMessageClient)packetFactory.apply(buf);
            NetworkContext context = new NetworkContext().setDestination(LogicalSide.FOR_CLIENT).setClient(client).setClientHandle(handler).setRespond(responseSender);
            packet.processMessage(context);
        };
    }

    protected static ServerPlayNetworking.PlayChannelHandler generateServerPacketHandler(Function<class_2540, BaseMessageServer> packetFactory) {
        return (server, player, handler, buf, responseSender) -> {
            BaseMessageServer packet = (BaseMessageServer)packetFactory.apply(buf);
            NetworkContext context = new NetworkContext().setDestination(LogicalSide.FOR_SERVER).setServer(server).setServerHandle(handler).setSender(player).setRespond(responseSender);
            packet.processMessage(context);
        };
    }

    public static void registerClient(String channelId, Function<class_2540, BaseMessageClient> etc) {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)GrappleMod.id(channelId), (ClientPlayNetworking.PlayChannelHandler)NetworkManager.generateClientPacketHandler(etc));
    }

    public static void registerServer(String channelId, Function<class_2540, BaseMessageServer> etc) {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)GrappleMod.id(channelId), (ServerPlayNetworking.PlayChannelHandler)NetworkManager.generateServerPacketHandler(etc));
    }

    public static void packetToServer(BaseMessageServer server) {
        class_2540 buf = PacketByteBufs.create();
        server.encode(buf);
        ClientPlayNetworking.send((class_2960)server.getChannel(), (class_2540)buf);
    }

    public static void packetToClient(BaseMessageClient client, class_3222 ... players) {
        if (players.length == 0) {
            GrappleMod.LOGGER.warn("Missing any players to send a packet to!");
            return;
        }
        class_2540 buf = PacketByteBufs.create();
        client.encode(buf);
        for (class_3222 player : players) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)client.getChannel(), (class_2540)buf);
        }
    }

    public static void registerClientPacketListeners() {
        NetworkManager.registerClient("data", AddExtraDataMessage::new);
        NetworkManager.registerClient("detach_single_hook", DetachSingleHookMessage::new);
        NetworkManager.registerClient("grapple_attach", GrappleAttachMessage::new);
        NetworkManager.registerClient("grapple_attach_pos", GrappleAttachPosMessage::new);
        NetworkManager.registerClient("grapple_detach", GrappleDetachMessage::new);
        NetworkManager.registerClient("logged_in", LoggedInMessage::new);
        NetworkManager.registerClient("segment", SegmentMessage::new);
    }

    public static void registerPacketListeners() {
        NetworkManager.registerServer("grapple_end", GrappleEndMessage::new);
        NetworkManager.registerServer("grapple_modifier", GrappleModifierMessage::new);
        NetworkManager.registerServer("keypress", KeypressMessage::new);
        NetworkManager.registerServer("player_movement", PlayerMovementMessage::new);
    }
}

