/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.registry;

import com.yyon.grapplinghook.GrappleMod;
import com.yyon.grapplinghook.config.GrappleHookTemplate;
import com.yyon.grapplinghook.item.EnderStaffItem;
import com.yyon.grapplinghook.item.ForcefieldItem;
import com.yyon.grapplinghook.item.GrapplehookItem;
import com.yyon.grapplinghook.item.LongFallBoots;
import com.yyon.grapplinghook.item.upgrade.BaseUpgradeItem;
import com.yyon.grapplinghook.item.upgrade.DoubleUpgradeItem;
import com.yyon.grapplinghook.item.upgrade.ForcefieldUpgradeItem;
import com.yyon.grapplinghook.item.upgrade.LimitsUpgradeItem;
import com.yyon.grapplinghook.item.upgrade.MagnetUpgradeItem;
import com.yyon.grapplinghook.item.upgrade.MotorUpgradeItem;
import com.yyon.grapplinghook.item.upgrade.RocketUpgradeItem;
import com.yyon.grapplinghook.item.upgrade.RopeUpgradeItem;
import com.yyon.grapplinghook.item.upgrade.StaffUpgradeItem;
import com.yyon.grapplinghook.item.upgrade.SwingUpgradeItem;
import com.yyon.grapplinghook.item.upgrade.ThrowUpgradeItem;
import com.yyon.grapplinghook.registry.AbstractRegistryReference;
import com.yyon.grapplinghook.registry.GrappleModBlocks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.minecraft.class_1740;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public final class GrappleModItems {
    private static ArrayList<class_2960> itemsInRegistryOrder;
    private static HashMap<class_2960, ItemEntry<?>> items;
    private static List<class_1799> creativeMenuCache;
    private static boolean creativeCacheInvalid;
    public static final ItemEntry<GrapplehookItem> GRAPPLING_HOOK;
    public static final ItemEntry<EnderStaffItem> ENDER_STAFF;
    public static final ItemEntry<ForcefieldItem> FORCE_FIELD;
    public static final ItemEntry<BaseUpgradeItem> BASE_UPGRADE;
    public static final ItemEntry<DoubleUpgradeItem> DOUBLE_UPGRADE;
    public static final ItemEntry<ForcefieldUpgradeItem> FORCE_FIELD_UPGRADE;
    public static final ItemEntry<MagnetUpgradeItem> MAGNET_UPGRADE;
    public static final ItemEntry<MotorUpgradeItem> MOTOR_UPGRADE;
    public static final ItemEntry<RopeUpgradeItem> ROPE_UPGRADE;
    public static final ItemEntry<StaffUpgradeItem> ENDER_STAFF_UPGRADE;
    public static final ItemEntry<SwingUpgradeItem> SWING_UPGRADE;
    public static final ItemEntry<ThrowUpgradeItem> THROW_UPGRADE;
    public static final ItemEntry<LimitsUpgradeItem> LIMITS_UPGRADE;
    public static final ItemEntry<RocketUpgradeItem> ROCKET_UPGRADE;
    public static final ItemEntry<LongFallBoots> LONG_FALL_BOOTS;
    public static final GrappleModBlocks.BlockItemEntry<class_1747> GRAPPLE_MODIFIER_BLOCK;
    private static final class_1761.class_7914 MOD_TAB_GENERATOR;
    private static final class_5321<class_1761> ITEM_GROUP_KEY;
    private static final class_1761 ITEM_GROUP;

    public static <I extends class_1792> ItemEntry<I> item(String id, Supplier<I> item) {
        return GrappleModItems.item(id, item, null);
    }

    public static <I extends class_1792> ItemEntry<I> item(String id, Supplier<I> item, Supplier<List<class_1799>> tabProvider) {
        class_2960 qualId = GrappleMod.id(id);
        ItemEntry<I> entry = new ItemEntry<I>(qualId, item, tabProvider);
        if (items.containsKey(qualId)) {
            throw new IllegalStateException("Duplicate item registered");
        }
        items.put(qualId, entry);
        itemsInRegistryOrder.add(qualId);
        return entry;
    }

    public static <B extends class_1747> GrappleModBlocks.BlockItemEntry<B> reserve() {
        return new GrappleModBlocks.BlockItemEntry();
    }

    public static void invalidateCreativeTabCache() {
        creativeCacheInvalid = true;
    }

    public static boolean isCreativeCacheInvalid() {
        return creativeCacheInvalid;
    }

    public static void registerAllItems() {
        for (Map.Entry<class_2960, ItemEntry<?>> def : items.entrySet()) {
            class_2960 id = def.getKey();
            ItemEntry<?> data = def.getValue();
            class_1792 it = (class_1792)data.getFactory().get();
            data.finalize(class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)id, (Object)it));
        }
        class_2378.method_39197((class_2378)class_7923.field_44687, ITEM_GROUP_KEY, (Object)ITEM_GROUP);
    }

    static {
        items = new HashMap();
        itemsInRegistryOrder = new ArrayList();
        creativeMenuCache = null;
        GRAPPLING_HOOK = GrappleModItems.item("grapplinghook", GrapplehookItem::new, ItemEntry.populateHookVariantsInTab());
        ENDER_STAFF = GrappleModItems.item("launcheritem", EnderStaffItem::new);
        FORCE_FIELD = GrappleModItems.item("repeller", ForcefieldItem::new);
        BASE_UPGRADE = GrappleModItems.item("baseupgradeitem", BaseUpgradeItem::new);
        DOUBLE_UPGRADE = GrappleModItems.item("doubleupgradeitem", DoubleUpgradeItem::new);
        FORCE_FIELD_UPGRADE = GrappleModItems.item("forcefieldupgradeitem", ForcefieldUpgradeItem::new);
        MAGNET_UPGRADE = GrappleModItems.item("magnetupgradeitem", MagnetUpgradeItem::new);
        MOTOR_UPGRADE = GrappleModItems.item("motorupgradeitem", MotorUpgradeItem::new);
        ROPE_UPGRADE = GrappleModItems.item("ropeupgradeitem", RopeUpgradeItem::new);
        ENDER_STAFF_UPGRADE = GrappleModItems.item("staffupgradeitem", StaffUpgradeItem::new);
        SWING_UPGRADE = GrappleModItems.item("swingupgradeitem", SwingUpgradeItem::new);
        THROW_UPGRADE = GrappleModItems.item("throwupgradeitem", ThrowUpgradeItem::new);
        LIMITS_UPGRADE = GrappleModItems.item("limitsupgradeitem", LimitsUpgradeItem::new);
        ROCKET_UPGRADE = GrappleModItems.item("rocketupgradeitem", RocketUpgradeItem::new);
        LONG_FALL_BOOTS = GrappleModItems.item("longfallboots", () -> new LongFallBoots(class_1740.field_7889));
        GRAPPLE_MODIFIER_BLOCK = GrappleModItems.reserve();
        MOD_TAB_GENERATOR = (displayParameters, output) -> {
            if (creativeMenuCache == null || creativeCacheInvalid) {
                creativeCacheInvalid = false;
                creativeMenuCache = itemsInRegistryOrder.stream().map(id -> items.get(id)).map(ItemEntry::getTabProvider).map(Supplier::get).flatMap(Collection::stream).collect(Collectors.toList());
            }
            creativeMenuCache.forEach(arg_0 -> ((class_1761.class_7704)output).method_45420(arg_0));
        };
        ITEM_GROUP_KEY = class_5321.method_29179((class_5321)class_7924.field_44688, (class_2960)GrappleMod.id("main"));
        ITEM_GROUP = FabricItemGroup.builder().method_47321((class_2561)class_2561.method_43471((String)"itemGroup.grapplemod.main")).method_47320(() -> new class_1799((class_1935)GRAPPLING_HOOK.get())).method_47317(MOD_TAB_GENERATOR).method_47324();
    }

    public static class ItemEntry<I extends class_1792>
    extends AbstractRegistryReference<I> {
        protected Supplier<List<class_1799>> tabProvider;

        protected ItemEntry(class_2960 id, Supplier<I> factory, Supplier<List<class_1799>> creativeTabProvider) {
            super(id, factory);
            this.tabProvider = creativeTabProvider == null ? this.defaultInTab() : creativeTabProvider;
        }

        public Supplier<List<class_1799>> getTabProvider() {
            return this.tabProvider;
        }

        private Supplier<List<class_1799>> defaultInTab() {
            return () -> List.of(((class_1792)this.get()).method_7854());
        }

        private static Supplier<List<class_1799>> hiddenInTab() {
            return ArrayList::new;
        }

        private static Supplier<List<class_1799>> populateHookVariantsInTab() {
            return () -> {
                ArrayList<class_1799> grappleHookVariants = new ArrayList<class_1799>();
                grappleHookVariants.add(((GrapplehookItem)GRAPPLING_HOOK.get()).method_7854());
                GrappleHookTemplate.getTemplates().stream().filter(GrappleHookTemplate::isEnabled).map(GrappleHookTemplate::getAsStack).forEachOrdered(grappleHookVariants::add);
                return grappleHookVariants;
            };
        }
    }
}

