/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import io.github.kosmx.emotes.api.events.server.ServerEmoteAPI;
import io.github.kosmx.emotes.executor.EmoteInstance;
import io.github.kosmx.emotes.server.serializer.UniversalEmoteSerializer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_7157;

public final class ServerCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"emotes").then(class_2170.method_9247((String)"play").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"emote", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new EmoteArgumentProvider()).executes(context -> {
            UUID player = ((class_2168)context.getSource()).method_9207().method_5667();
            boolean admin = ((class_2168)context.getSource()).method_9259(2);
            KeyframeAnimation emote = EmoteArgumentProvider.getEmote((CommandContext<class_2168>)context, "emote");
            if (!admin && ServerEmoteAPI.isForcedEmote(player)) {
                throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Can't stop forced emote without admin rights")).create();
            }
            ServerEmoteAPI.playEmote(player, emote, false);
            return 0;
        })).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).requires(ctx -> ctx.method_9259(2))).executes(context -> {
            ServerEmoteAPI.playEmote(class_2186.method_9315((CommandContext)context, (String)"player").method_5667(), EmoteArgumentProvider.getEmote((CommandContext<class_2168>)context, "emote"), false);
            return 0;
        })).then(class_2170.method_9244((String)"forced", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            ServerEmoteAPI.playEmote(class_2186.method_9315((CommandContext)context, (String)"player").method_5667(), EmoteArgumentProvider.getEmote((CommandContext<class_2168>)context, "emote"), BoolArgumentType.getBool((CommandContext)context, (String)"forced"));
            return 0;
        })))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"stop").executes(context -> {
            boolean canStop;
            boolean admin = ((class_2168)context.getSource()).method_9259(2);
            UUID player = ((class_2168)context.getSource()).method_9207().method_5667();
            boolean bl = canStop = admin || !ServerEmoteAPI.isForcedEmote(player);
            if (canStop) {
                ServerEmoteAPI.playEmote(player, null, false);
                return 0;
            }
            throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Can't stop forced emote without admin rights")).create();
        })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).requires(ctx -> ctx.method_9259(2))).executes(context -> {
            ServerEmoteAPI.playEmote(class_2186.method_9315((CommandContext)context, (String)"player").method_5667(), null, false);
            return 0;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(ctx -> ctx.method_9259(4) && environment == class_2170.class_5364.field_25420)).executes(context -> {
            UniversalEmoteSerializer.loadEmotes();
            return 0;
        })));
    }

    private static class EmoteArgumentProvider
    implements SuggestionProvider<class_2168> {
        private EmoteArgumentProvider() {
        }

        public CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) {
            HashMap<UUID, KeyframeAnimation> emotes = EmoteArgumentProvider.getEmotes(((class_2168)context.getSource()).method_9259(1));
            LinkedList<String> suggestions = new LinkedList<String>();
            for (KeyframeAnimation emote : emotes.values()) {
                if (emote.extraData.containsKey("name")) {
                    Object name = EmoteInstance.instance.getDefaults().fromJson(emote.extraData.get("name")).getString();
                    if (((String)name).contains(" ")) {
                        name = "\"" + (String)name + "\"";
                    }
                    suggestions.add((String)name);
                    continue;
                }
                suggestions.add(emote.getUuid().toString());
            }
            return class_2172.method_9253((String[])((String[])suggestions.toArray(String[]::new)), (SuggestionsBuilder)builder);
        }

        private static HashMap<UUID, KeyframeAnimation> getEmotes(boolean allowHidden) {
            return allowHidden ? ServerEmoteAPI.getLoadedEmotes() : ServerEmoteAPI.getPublicEmotes();
        }

        public static KeyframeAnimation getEmote(CommandContext<class_2168> context, String argumentName) throws CommandSyntaxException {
            String id = StringArgumentType.getString(context, (String)argumentName);
            HashMap<UUID, KeyframeAnimation> emotes = EmoteArgumentProvider.getEmotes(((class_2168)context.getSource()).method_9259(1));
            try {
                UUID emoteID = UUID.fromString(id);
                KeyframeAnimation emote = emotes.get(emoteID);
                if (emote == null) {
                    throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)("No emote with ID: " + emoteID))).create();
                }
                return emote;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                for (KeyframeAnimation emote : emotes.values()) {
                    String name;
                    if (!emote.extraData.containsKey("name") || !(name = EmoteInstance.instance.getDefaults().fromJson(emote.extraData.get("name")).getString()).equals(id)) continue;
                    return emote;
                }
                throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)("Not emote with name: " + id))).create();
            }
        }
    }
}

