/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.fabric.network;

import io.github.kosmx.emotes.api.proxy.INetworkInstance;
import io.github.kosmx.emotes.common.network.EmotePacket;
import io.github.kosmx.emotes.common.network.GeyserEmotePacket;
import io.github.kosmx.emotes.common.network.objects.NetData;
import io.github.kosmx.emotes.fabric.FabricWrapper;
import io.github.kosmx.emotes.server.network.AbstractServerEmotePlay;
import io.github.kosmx.emotes.server.network.IServerNetworkInstance;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

public class ServerNetwork
extends AbstractServerEmotePlay<class_1657> {
    public static final class_2960 channelID = new class_2960("emotecraft", "emote");
    public static final class_2960 geyserChannelID = new class_2960("geyser", "emote");
    public static ServerNetwork instance = new ServerNetwork();

    public void init() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            ServerPlayNetworking.registerReceiver((class_3244)handler, (class_2960)channelID, this::receiveMessage);
            ServerPlayNetworking.registerReceiver((class_3244)handler, (class_2960)geyserChannelID, this::receiveGeyserMessage);
        });
    }

    void receiveMessage(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        try {
            if (buf.isDirect()) {
                byte[] bytes = new byte[buf.readableBytes()];
                buf.getBytes(buf.readerIndex(), bytes);
                this.receiveMessage(bytes, player, (INetworkInstance)handler);
            } else {
                this.receiveMessage(buf.array(), player, (INetworkInstance)handler);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void receiveGeyserMessage(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        if (buf.isDirect()) {
            byte[] bytes = new byte[buf.readableBytes()];
            buf.getBytes(buf.readerIndex(), bytes);
            this.receiveGeyserMessage(player, bytes);
        } else {
            this.receiveGeyserMessage(player, buf.array());
        }
    }

    @Override
    protected UUID getUUIDFromPlayer(class_1657 player) {
        return player.method_5667();
    }

    @Override
    protected class_1657 getPlayerFromUUID(UUID player) {
        return FabricWrapper.SERVER_INSTANCE.method_3760().method_14602(player);
    }

    @Override
    protected long getRuntimePlayerID(class_1657 player) {
        return player.method_5628();
    }

    @Override
    protected IServerNetworkInstance getPlayerNetworkInstance(class_1657 player) {
        return (IServerNetworkInstance)((class_3222)player).field_13987;
    }

    @Override
    protected void sendForEveryoneElse(GeyserEmotePacket packet, class_1657 player) {
        PlayerLookup.tracking((class_1297)player).forEach(serverPlayer -> {
            try {
                if (serverPlayer != player && ServerPlayNetworking.canSend((class_3222)serverPlayer, (class_2960)geyserChannelID)) {
                    ServerPlayNetworking.send((class_3222)serverPlayer, (class_2960)geyserChannelID, (class_2540)new class_2540(Unpooled.wrappedBuffer((byte[])packet.write())));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    protected void sendForEveryoneElse(NetData data, GeyserEmotePacket emotePacket, class_1657 player) {
        data.player = player.method_5667();
        PlayerLookup.tracking((class_1297)player).forEach(serverPlayerEntity -> {
            try {
                if (serverPlayerEntity != player) {
                    if (ServerPlayNetworking.canSend((class_3222)serverPlayerEntity, (class_2960)channelID)) {
                        EmotePacket.Builder packetBuilder = new EmotePacket.Builder(data);
                        packetBuilder.setVersion(((IServerNetworkInstance)serverPlayerEntity.field_13987).getRemoteVersions());
                        ServerPlayNetworking.send((class_3222)serverPlayerEntity, (class_2960)channelID, (class_2540)new class_2540(Unpooled.wrappedBuffer((byte[])packetBuilder.build().write().array())));
                    } else if (ServerPlayNetworking.canSend((class_3222)serverPlayerEntity, (class_2960)geyserChannelID) && emotePacket != null) {
                        ServerPlayNetworking.send((class_3222)serverPlayerEntity, (class_2960)geyserChannelID, (class_2540)new class_2540(Unpooled.wrappedBuffer((byte[])emotePacket.write())));
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    protected void sendForPlayerInRange(NetData data, class_1657 player, UUID target) {
        PlayerLookup.tracking((class_1297)player).forEach(serverPlayerEntity -> this.targetFinder((class_3222)serverPlayerEntity, data, target));
    }

    @Override
    protected void sendForPlayer(NetData data, class_1657 player, UUID target) {
        PlayerLookup.all((MinecraftServer)Objects.requireNonNull(player.method_5682())).forEach(serverPlayerEntity -> this.targetFinder((class_3222)serverPlayerEntity, data, target));
    }

    private void targetFinder(class_3222 serverPlayerEntity, NetData data, UUID target) {
        if (serverPlayerEntity.method_5667().equals(target)) {
            try {
                EmotePacket.Builder packetBuilder = new EmotePacket.Builder(data);
                packetBuilder.setVersion(((IServerNetworkInstance)serverPlayerEntity.field_13987).getRemoteVersions());
                ServerPlayNetworking.send((class_3222)serverPlayerEntity, (class_2960)channelID, (class_2540)new class_2540(Unpooled.wrappedBuffer((byte[])packetBuilder.build().write().array())));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

