/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.chunkgenerator.generation.math.interpolation;

import com.dfsek.terra.addons.chunkgenerator.config.noise.BiomeNoiseProperties;
import com.dfsek.terra.addons.chunkgenerator.generation.math.interpolation.Interpolator;
import com.dfsek.terra.addons.chunkgenerator.lib.jafama.FastMath;
import com.dfsek.terra.api.properties.PropertyKey;
import com.dfsek.terra.api.world.biome.generation.BiomeProvider;

public class LazilyEvaluatedInterpolator {
    private final Double[] samples;
    private final int chunkX;
    private final int chunkZ;
    private final int horizontalRes;
    private final int verticalRes;
    private final BiomeProvider biomeProvider;
    private final PropertyKey<BiomeNoiseProperties> noisePropertiesKey;
    private final long seed;
    private final int min;
    private final int max;
    private final int zMul;
    private final int yMul;

    public LazilyEvaluatedInterpolator(BiomeProvider biomeProvider, int cx, int cz, int max, PropertyKey<BiomeNoiseProperties> noisePropertiesKey, int min, int horizontalRes, int verticalRes, long seed) {
        this.noisePropertiesKey = noisePropertiesKey;
        int hSamples = FastMath.ceilToInt(16.0 / (double)horizontalRes);
        int vSamples = FastMath.ceilToInt((double)(max - min) / (double)verticalRes);
        this.zMul = hSamples + 1;
        this.yMul = this.zMul * this.zMul;
        this.samples = new Double[this.yMul * (vSamples + 1)];
        this.chunkX = cx << 4;
        this.chunkZ = cz << 4;
        this.horizontalRes = horizontalRes;
        this.verticalRes = verticalRes;
        this.biomeProvider = biomeProvider;
        this.seed = seed;
        this.min = min;
        this.max = max - 1;
    }

    private double sample(int xIndex, int yIndex, int zIndex, int ox, int oy, int oz) {
        int index = xIndex + zIndex * this.zMul + yIndex * this.yMul;
        Double sample = this.samples[index];
        if (sample == null) {
            int xi = ox + this.chunkX;
            int zi = oz + this.chunkZ;
            int y = FastMath.min(this.max, oy);
            this.samples[index] = sample = Double.valueOf(((BiomeNoiseProperties)this.biomeProvider.getBiome(xi, y, zi, this.seed).getContext().get(this.noisePropertiesKey)).carving().noise(this.seed, xi, y, zi));
        }
        return sample;
    }

    public double sample(int x, int y, int z) {
        boolean yRange;
        int xIndex = x / this.horizontalRes;
        int yIndex = (y - this.min) / this.verticalRes;
        int zIndex = z / this.horizontalRes;
        double sample_0_0_0 = this.sample(xIndex, yIndex, zIndex, x, y, z);
        boolean bl = yRange = y % this.verticalRes == 0;
        if (x % this.horizontalRes == 0 && yRange && z % this.horizontalRes == 0) {
            return sample_0_0_0;
        }
        double sample_0_0_1 = this.sample(xIndex, yIndex, zIndex + 1, x, y, z + this.horizontalRes);
        double sample_1_0_0 = this.sample(xIndex + 1, yIndex, zIndex, x + this.horizontalRes, y, z);
        double sample_1_0_1 = this.sample(xIndex + 1, yIndex, zIndex + 1, x + this.horizontalRes, y, z + this.horizontalRes);
        double xFrac = (double)(x % this.horizontalRes) / (double)this.horizontalRes;
        double zFrac = (double)(z % this.horizontalRes) / (double)this.horizontalRes;
        double lerp_bottom_0 = Interpolator.lerp(zFrac, sample_0_0_0, sample_0_0_1);
        double lerp_bottom_1 = Interpolator.lerp(zFrac, sample_1_0_0, sample_1_0_1);
        double lerp_bottom = Interpolator.lerp(xFrac, lerp_bottom_0, lerp_bottom_1);
        if (yRange) {
            return lerp_bottom;
        }
        double yFrac = (double)FastMath.floorMod(y, this.verticalRes) / (double)this.verticalRes;
        double sample_0_1_0 = this.sample(xIndex, yIndex + 1, zIndex, x, y + this.verticalRes, z);
        double sample_0_1_1 = this.sample(xIndex, yIndex + 1, zIndex + 1, x, y + this.verticalRes, z + this.horizontalRes);
        double sample_1_1_0 = this.sample(xIndex + 1, yIndex + 1, zIndex, x + this.horizontalRes, y + this.verticalRes, z);
        double sample_1_1_1 = this.sample(xIndex + 1, yIndex + 1, zIndex + 1, x + this.horizontalRes, y + this.verticalRes, z + this.horizontalRes);
        double lerp_top_0 = Interpolator.lerp(zFrac, sample_0_1_0, sample_0_1_1);
        double lerp_top_1 = Interpolator.lerp(zFrac, sample_1_1_0, sample_1_1_1);
        double lerp_top = Interpolator.lerp(xFrac, lerp_top_0, lerp_top_1);
        return Interpolator.lerp(yFrac, lerp_bottom, lerp_top);
    }
}

