/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.common.ai;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.mehvahdjukaar.snowyspirit.SnowySpirit;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1646;
import net.minecraft.class_1680;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4097;
import net.minecraft.class_4102;
import net.minecraft.class_4115;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4215;

public class ThrowSnowballsTask
extends class_4097<class_1646> {
    private int cooldownBetweenAttacks;
    private int eggs;
    private final int maxRange;
    private int duration = 400;
    private int cooldown = 0;

    public ThrowSnowballsTask(int range) {
        super((Map)ImmutableMap.of((Object)class_4140.field_18446, (Object)class_4141.field_18456));
        this.maxRange = range;
    }

    protected boolean checkExtraStartConditions(class_3218 pLevel, class_1646 pOwner) {
        if (this.cooldown-- > 0) {
            return false;
        }
        if (!SnowySpirit.isChristmasSeason((class_1937)pLevel)) {
            return false;
        }
        class_1309 livingentity = this.getLookTarget((class_1309)pOwner);
        if (livingentity == null) {
            return false;
        }
        return class_4215.method_24565((class_1309)pOwner, (class_1309)livingentity) && livingentity.method_5649(pOwner.method_23317(), pOwner.method_23318(), pOwner.method_23321()) < (double)(this.maxRange * this.maxRange);
    }

    protected boolean canStillUse(class_3218 pLevel, class_1646 pEntity, long pGameTime) {
        if (this.duration <= 0) {
            return false;
        }
        return this.eggs == 0 || this.checkExtraStartConditions(pLevel, pEntity);
    }

    protected void start(class_3218 pLevel, class_1646 pEntity, long pGameTime) {
        class_1309 livingentity = this.getLookTarget((class_1309)pEntity);
        pEntity.method_18868().method_18878(class_4140.field_18447, (Object)livingentity);
        ThrowSnowballsTask.displayAsHeldItem(pEntity, new class_1799((class_1935)class_1802.field_8543));
        if (this.eggs == 0) {
            this.duration = 400;
            this.eggs = pLevel.field_9229.method_43048(3) + 1;
            this.cooldownBetweenAttacks = 35 + pLevel.field_9229.method_43048(30);
        }
    }

    protected void tick(class_3218 pLevel, class_1646 pOwner, long pGameTime) {
        class_1309 target = pOwner.method_18868().method_18904(class_4140.field_18447).orElse(null);
        if (target == null) {
            return;
        }
        class_4215.method_19554((class_1309)pOwner, (class_1309)target);
        if (this.cooldownBetweenAttacks-- == 0) {
            this.cooldownBetweenAttacks = 20 + pLevel.field_9229.method_43048(30);
            --this.eggs;
            class_1680 egg = new class_1680((class_1937)pLevel, (class_1309)pOwner);
            double d0 = target.method_23318() - 0.5;
            double d1 = target.method_23317() - pOwner.method_23317();
            double d2 = d0 - egg.method_23318();
            double d3 = target.method_23321() - pOwner.method_23321();
            double distFactor = Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f;
            egg.method_7485(d1, (d2 + distFactor) * 0.5, d3, 1.1f, 8.0f);
            pLevel.method_43128(null, pOwner.method_23317(), pOwner.method_23318(), pOwner.method_23321(), class_3417.field_14873, class_3419.field_15254, 0.5f, 0.4f / (pLevel.method_8409().method_43057() * 0.4f + 0.8f));
            pLevel.method_8649((class_1297)egg);
        }
        if (this.eggs <= 0) {
            this.cooldown = 20 * (10 + pLevel.field_9229.method_43048(15)) + pLevel.field_9229.method_43048(20);
        }
        --this.duration;
    }

    public static void clearInteractionTarget(class_1646 pOwner) {
        pOwner.method_18868().method_18875(class_4140.field_18447);
        ThrowSnowballsTask.displayAsHeldItem(pOwner, class_1799.field_8037);
    }

    private static void displayAsHeldItem(class_1646 self, class_1799 stack) {
        self.method_5673(class_1304.field_6173, stack);
        self.method_5946(class_1304.field_6173, 0.0f);
    }

    protected void stop(class_3218 pLevel, class_1646 pEntity, long pGameTime) {
        super.method_18926(pLevel, (class_1309)pEntity, pGameTime);
        ThrowSnowballsTask.clearInteractionTarget(pEntity);
    }

    @Nullable
    private class_1309 getLookTarget(class_1309 pMob) {
        class_4102 entityTracker;
        class_1297 e;
        class_4115 v = pMob.method_18868().method_18904(class_4140.field_18446).orElse(null);
        if (v instanceof class_4102 && (e = (entityTracker = (class_4102)v).method_35066()) instanceof class_1309) {
            class_1309 entity = (class_1309)e;
            return entity;
        }
        return null;
    }
}

