/*
 * Decompiled with CFR 0.152.
 */
package com.dynview.config;

import com.dynview.DynView;
import com.dynview.Utils.TickTimeHandler;
import com.dynview.ViewDistHandler.ServerDynamicViewDistanceManager;
import com.dynview.config.CommonConfiguration;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class Configuration {
    private final CommonConfiguration commonConfig = new CommonConfiguration();

    public void load() {
        Path configPath = FabricLoader.getInstance().getConfigDir().normalize().resolve("dynview.json");
        File config = configPath.toFile();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        if (!config.exists()) {
            DynView.LOGGER.warn("Config for dynamic view not found, recreating default");
            try {
                BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);
                gson.toJson((Object)this.commonConfig.serialize(), JsonObject.class, (Appendable)writer);
                writer.close();
            }
            catch (IOException e) {
                DynView.LOGGER.error("Could not write config to:" + configPath, (Throwable)e);
            }
        } else {
            try {
                this.commonConfig.deserialize((JsonObject)gson.fromJson((Reader)Files.newBufferedReader(configPath), JsonObject.class));
            }
            catch (Exception e) {
                DynView.LOGGER.error("Could not read config from:" + configPath + " recreating default", (Throwable)e);
                try {
                    BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);
                    gson.toJson((Object)this.commonConfig.serialize(), JsonObject.class, (Appendable)writer);
                    writer.close();
                }
                catch (Exception ex) {
                    DynView.LOGGER.error("Could not write config to:" + configPath, (Throwable)ex);
                }
            }
        }
        TickTimeHandler.serverTickTimerInterval = this.commonConfig.viewDistanceUpdateRate * 20;
        ServerDynamicViewDistanceManager.minChunkViewDist = this.commonConfig.minChunkViewDist;
        ServerDynamicViewDistanceManager.maxChunkViewDist = this.commonConfig.maxChunkViewDist;
        ServerDynamicViewDistanceManager.minChunkUpdateDist = this.commonConfig.minSimulationDist;
        ServerDynamicViewDistanceManager.maxChunkUpdateDist = this.commonConfig.maxSimulationDist;
        ServerDynamicViewDistanceManager.meanTickToStayBelow = this.commonConfig.meanAvgTickTime;
    }

    public CommonConfiguration getCommonConfig() {
        return this.commonConfig;
    }
}

