/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.arguments.standard;

import cloud.commandframework.ArgumentDescription;
import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.arguments.parser.ArgumentParseResult;
import cloud.commandframework.arguments.parser.ArgumentParser;
import cloud.commandframework.arguments.standard.IntegerArgument;
import cloud.commandframework.context.CommandContext;
import cloud.commandframework.exceptions.parsing.NoInputProvidedException;
import cloud.commandframework.exceptions.parsing.NumberParseException;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.function.BiFunction;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.common.returnsreceiver.qual.This;

@API(status=API.Status.STABLE)
public final class LongArgument<C>
extends CommandArgument<C, Long> {
    private final long min;
    private final long max;

    private LongArgument(boolean required, @NonNull String name, long min2, long max, String defaultValue, @Nullable BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<@NonNull String>> suggestionsProvider, @NonNull ArgumentDescription defaultDescription) {
        super(required, name, new LongParser(min2, max), defaultValue, Long.class, suggestionsProvider, defaultDescription);
        this.min = min2;
        this.max = max;
    }

    @API(status=API.Status.STABLE, since="1.8.0")
    public static <C> @NonNull Builder<C> builder(@NonNull String name) {
        return new Builder(name);
    }

    @API(status=API.Status.DEPRECATED, since="1.8.0")
    @Deprecated
    public static <C> @NonNull Builder<C> newBuilder(@NonNull String name) {
        return LongArgument.builder(name);
    }

    public static <C> @NonNull CommandArgument<C, Long> of(@NonNull String name) {
        return LongArgument.builder(name).asRequired().build();
    }

    public static <C> @NonNull CommandArgument<C, Long> optional(@NonNull String name) {
        return LongArgument.builder(name).asOptional().build();
    }

    public static <C> @NonNull CommandArgument<C, Long> optional(@NonNull String name, long defaultNum) {
        return LongArgument.builder(name).asOptionalWithDefault(defaultNum).build();
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    @API(status=API.Status.STABLE)
    public static final class LongParser<C>
    implements ArgumentParser<C, Long> {
        @API(status=API.Status.STABLE, since="1.5.0")
        public static final long DEFAULT_MINIMUM = Long.MIN_VALUE;
        @API(status=API.Status.STABLE, since="1.5.0")
        public static final long DEFAULT_MAXIMUM = Long.MAX_VALUE;
        private final long min;
        private final long max;

        public LongParser(long min2, long max) {
            this.min = min2;
            this.max = max;
        }

        @Override
        public @NonNull ArgumentParseResult<Long> parse(@NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            String input = inputQueue.peek();
            if (input == null) {
                return ArgumentParseResult.failure(new NoInputProvidedException(LongParser.class, commandContext));
            }
            try {
                long value = Long.parseLong(input);
                if (value < this.min || value > this.max) {
                    return ArgumentParseResult.failure(new LongParseException(input, this, commandContext));
                }
                inputQueue.remove();
                return ArgumentParseResult.success(value);
            }
            catch (Exception e) {
                return ArgumentParseResult.failure(new LongParseException(input, this, commandContext));
            }
        }

        public long getMin() {
            return this.min;
        }

        public long getMax() {
            return this.max;
        }

        @API(status=API.Status.STABLE, since="1.5.0")
        public boolean hasMax() {
            return this.max != Long.MAX_VALUE;
        }

        @API(status=API.Status.STABLE, since="1.5.0")
        public boolean hasMin() {
            return this.min != Long.MIN_VALUE;
        }

        @Override
        public boolean isContextFree() {
            return true;
        }

        @Override
        public @NonNull List<@NonNull String> suggestions(@NonNull CommandContext<C> commandContext, @NonNull String input) {
            return IntegerArgument.IntegerParser.getSuggestions(this.min, this.max, input);
        }
    }

    @API(status=API.Status.STABLE)
    public static final class Builder<C>
    extends CommandArgument.Builder<C, Long> {
        private long min = Long.MIN_VALUE;
        private long max = Long.MAX_VALUE;

        private Builder(@NonNull String name) {
            super(Long.class, name);
        }

        public @NonNull @This Builder<C> withMin(long min2) {
            this.min = min2;
            return this;
        }

        public @NonNull @This Builder<C> withMax(long max) {
            this.max = max;
            return this;
        }

        @API(status=API.Status.STABLE, since="1.5.0")
        public @NonNull Builder<C> asOptionalWithDefault(long defaultValue) {
            return (Builder)this.asOptionalWithDefault(Long.toString(defaultValue));
        }

        public @NonNull LongArgument<C> build() {
            return new LongArgument(this.isRequired(), this.getName(), this.min, this.max, this.getDefaultValue(), this.getSuggestionsProvider(), this.getDefaultDescription());
        }
    }

    @API(status=API.Status.STABLE)
    public static final class LongParseException
    extends NumberParseException {
        private static final long serialVersionUID = 4366856282301198232L;
        private final LongParser<?> parser;

        @Deprecated
        @API(status=API.Status.DEPRECATED, since="1.5.0")
        public LongParseException(@NonNull String input, long min2, long max, @NonNull CommandContext<?> commandContext) {
            this(input, new LongParser(min2, max), commandContext);
        }

        @API(status=API.Status.STABLE, since="1.5.0")
        public LongParseException(@NonNull String input, @NonNull LongParser<?> parser, @NonNull CommandContext<?> commandContext) {
            super(input, ((LongParser)parser).min, ((LongParser)parser).max, LongParser.class, commandContext);
            this.parser = parser;
        }

        @Override
        public boolean hasMin() {
            return this.parser.hasMin();
        }

        @Override
        public boolean hasMax() {
            return this.parser.hasMax();
        }

        @Override
        public @NonNull String getNumberType() {
            return "long";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LongParseException that = (LongParseException)o;
            return this.parser.equals(that.parser);
        }

        public int hashCode() {
            return Objects.hash(this.parser);
        }
    }
}

