/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api;

import com.dfsek.terra.api.addon.BaseAddon;
import com.dfsek.terra.api.config.ConfigPack;
import com.dfsek.terra.api.config.PluginConfig;
import com.dfsek.terra.api.event.EventManager;
import com.dfsek.terra.api.handle.ItemHandle;
import com.dfsek.terra.api.handle.WorldHandle;
import com.dfsek.terra.api.profiler.Profiler;
import com.dfsek.terra.api.registry.CheckedRegistry;
import com.dfsek.terra.api.registry.Registry;
import com.dfsek.terra.api.tectonic.LoaderRegistrar;
import java.io.File;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface Platform
extends LoaderRegistrar {
    public boolean reload();

    @NotNull
    @Contract(pure=true)
    public String platformName();

    default public void runPossiblyUnsafeTask(@NotNull Runnable task) {
        task.run();
    }

    @NotNull
    @Contract(pure=true)
    public WorldHandle getWorldHandle();

    @NotNull
    @Contract(pure=true)
    public PluginConfig getTerraConfig();

    @NotNull
    @Contract(pure=true)
    public File getDataFolder();

    @NotNull
    @Contract(pure=true)
    public CheckedRegistry<ConfigPack> getConfigRegistry();

    @NotNull
    @Contract(pure=true)
    public Registry<BaseAddon> getAddons();

    @NotNull
    @Contract(pure=true)
    public ItemHandle getItemHandle();

    @NotNull
    @Contract(pure=true)
    public EventManager getEventManager();

    @Contract(pure=true)
    @NotNull
    default public String getVersion() {
        return "@VERSION@";
    }

    @NotNull
    @Contract(pure=true)
    public Profiler getProfiler();
}

