/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.world;

import com.dfsek.terra.api.block.state.BlockState;
import com.dfsek.terra.api.entity.Entity;
import com.dfsek.terra.api.entity.EntityType;
import com.dfsek.terra.api.util.vector.Vector3;
import com.dfsek.terra.api.util.vector.Vector3Int;
import com.dfsek.terra.api.world.BufferedWorld;
import com.dfsek.terra.api.world.ReadableWorld;
import com.dfsek.terra.api.world.chunk.generation.util.Column;

public interface WritableWorld
extends ReadableWorld {
    default public void setBlockState(Vector3 position, BlockState data, boolean physics) {
        this.setBlockState(position.getBlockX(), position.getBlockY(), position.getBlockZ(), data, physics);
    }

    default public void setBlockState(Vector3.Mutable position, BlockState data, boolean physics) {
        this.setBlockState(position.getBlockX(), position.getBlockY(), position.getBlockZ(), data, physics);
    }

    default public void setBlockState(Vector3Int position, BlockState data, boolean physics) {
        this.setBlockState(position.getX(), position.getY(), position.getZ(), data, physics);
    }

    default public void setBlockState(Vector3Int.Mutable position, BlockState data, boolean physics) {
        this.setBlockState(position.getX(), position.getY(), position.getZ(), data, physics);
    }

    default public void setBlockState(Vector3 position, BlockState data) {
        this.setBlockState(position, data, false);
    }

    default public void setBlockState(Vector3.Mutable position, BlockState data) {
        this.setBlockState(position, data, false);
    }

    default public void setBlockState(Vector3Int position, BlockState data) {
        this.setBlockState(position, data, false);
    }

    default public void setBlockState(Vector3Int.Mutable position, BlockState data) {
        this.setBlockState(position, data, false);
    }

    default public void setBlockState(int x, int y, int z, BlockState data) {
        this.setBlockState(x, y, z, data, false);
    }

    public void setBlockState(int var1, int var2, int var3, BlockState var4, boolean var5);

    default public Entity spawnEntity(Vector3 location, EntityType entityType) {
        return this.spawnEntity(location.getX(), location.getY(), location.getZ(), entityType);
    }

    public Entity spawnEntity(double var1, double var3, double var5, EntityType var7);

    default public BufferedWorld buffer(int offsetX, int offsetY, int offsetZ) {
        return BufferedWorld.builder(this).offsetX(offsetX).offsetY(offsetY).offsetZ(offsetZ).build();
    }

    default public BufferedWorld.Builder buffer() {
        return BufferedWorld.builder(this);
    }

    default public Column<WritableWorld> column(int x, int z) {
        return new Column<WritableWorld>(x, z, this);
    }
}

