/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.world.biome.generation;

import com.dfsek.terra.api.util.Column;
import com.dfsek.terra.api.util.vector.Vector3;
import com.dfsek.terra.api.util.vector.Vector3Int;
import com.dfsek.terra.api.world.biome.Biome;
import com.dfsek.terra.api.world.biome.generation.BiomeColumn;
import com.dfsek.terra.api.world.biome.generation.CachingBiomeProvider;
import com.dfsek.terra.api.world.info.WorldProperties;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.Contract;

public interface BiomeProvider {
    @Contract(pure=true)
    public Biome getBiome(int var1, int var2, int var3, long var4);

    @Contract(pure=true)
    default public Biome getBiome(Vector3 vector3, long seed) {
        return this.getBiome(vector3.getBlockX(), vector3.getBlockY(), vector3.getBlockZ(), seed);
    }

    @Contract(pure=true)
    default public Biome getBiome(Vector3Int vector3, long seed) {
        return this.getBiome(vector3.getX(), vector3.getY(), vector3.getZ(), seed);
    }

    default public Optional<Biome> getBaseBiome(int x, int z, long seed) {
        return Optional.empty();
    }

    default public Column<Biome> getColumn(int x, int z, WorldProperties properties) {
        return this.getColumn(x, z, properties.getSeed(), properties.getMinHeight(), properties.getMaxHeight());
    }

    default public Column<Biome> getColumn(int x, int z, long seed, int min2, int max) {
        return new BiomeColumn(this, min2, max, x, z, seed);
    }

    @Contract(pure=true)
    public Iterable<Biome> getBiomes();

    @Contract(pure=true)
    default public Stream<Biome> stream() {
        return StreamSupport.stream(this.getBiomes().spliterator(), false);
    }

    default public CachingBiomeProvider caching() {
        BiomeProvider biomeProvider = this;
        if (biomeProvider instanceof CachingBiomeProvider) {
            CachingBiomeProvider cachingBiomeProvider = (CachingBiomeProvider)biomeProvider;
            return cachingBiomeProvider;
        }
        return new CachingBiomeProvider(this);
    }

    default public int resolution() {
        return 1;
    }
}

