/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.world.biome.generation;

import com.dfsek.terra.api.Handle;
import com.dfsek.terra.api.world.biome.Biome;
import com.dfsek.terra.api.world.biome.generation.BiomeProvider;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.Scheduler;
import java.util.Optional;

public class CachingBiomeProvider
implements BiomeProvider,
Handle {
    protected final BiomeProvider delegate;
    private final int res;
    private final LoadingCache<SeededVector3, Biome> cache;
    private final LoadingCache<SeededVector2, Optional<Biome>> baseCache;

    protected CachingBiomeProvider(BiomeProvider delegate) {
        this.delegate = delegate;
        this.res = delegate.resolution();
        this.cache = Caffeine.newBuilder().scheduler(Scheduler.disabledScheduler()).initialCapacity(98304).maximumSize(98304L).build(vec -> delegate.getBiome(vec.x * this.res, vec.y * this.res, vec.z * this.res, vec.seed));
        this.baseCache = Caffeine.newBuilder().maximumSize(256L).build(vec -> delegate.getBaseBiome(vec.x * this.res, vec.z * this.res, vec.seed));
    }

    @Override
    public BiomeProvider getHandle() {
        return this.delegate;
    }

    @Override
    public Biome getBiome(int x, int y, int z, long seed) {
        return this.cache.get(new SeededVector3(x / this.res, y / this.res, z / this.res, seed));
    }

    @Override
    public Optional<Biome> getBaseBiome(int x, int z, long seed) {
        return this.baseCache.get(new SeededVector2(x / this.res, z / this.res, seed));
    }

    @Override
    public Iterable<Biome> getBiomes() {
        return this.delegate.getBiomes();
    }

    @Override
    public int resolution() {
        return this.delegate.resolution();
    }

    private record SeededVector3(int x, int y, int z, long seed) {
        @Override
        public boolean equals(Object obj) {
            if (obj instanceof SeededVector3) {
                SeededVector3 that = (SeededVector3)obj;
                return this.y == that.y && this.z == that.z && this.x == that.x && this.seed == that.seed;
            }
            return false;
        }

        @Override
        public int hashCode() {
            int code = this.x;
            code = 31 * code + this.y;
            code = 31 * code + this.z;
            return 31 * code + (int)(this.seed ^ this.seed >>> 32);
        }
    }

    private record SeededVector2(int x, int z, long seed) {
        @Override
        public boolean equals(Object obj) {
            if (obj instanceof SeededVector2) {
                SeededVector2 that = (SeededVector2)obj;
                return this.z == that.z && this.x == that.x && this.seed == that.seed;
            }
            return false;
        }

        @Override
        public int hashCode() {
            int code = this.x;
            code = 31 * code + this.z;
            return 31 * code + (int)(this.seed ^ this.seed >>> 32);
        }
    }
}

