/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.config.preprocessor;

import com.dfsek.tectonic.api.config.Configuration;
import com.dfsek.tectonic.api.depth.DepthTracker;
import com.dfsek.tectonic.api.depth.EntryLevel;
import com.dfsek.tectonic.api.exception.LoadException;
import com.dfsek.tectonic.api.loader.ConfigLoader;
import com.dfsek.tectonic.api.preprocessor.Result;
import com.dfsek.terra.api.config.meta.Meta;
import com.dfsek.terra.api.util.generic.pair.Pair;
import com.dfsek.terra.api.util.reflection.TypeKey;
import com.dfsek.terra.config.preprocessor.MetaPreprocessor;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class MetaMapPreprocessor
extends MetaPreprocessor<Meta> {
    private static final TypeKey<List<String>> STRING_LIST = new TypeKey<List<String>>(){};

    public MetaMapPreprocessor(Map<String, Configuration> configs) {
        super(configs);
    }

    @Override
    @NotNull
    public <T> Result<T> process(AnnotatedType t2, T c, ConfigLoader loader, Meta annotation, DepthTracker depthTracker) {
        Map map;
        Class baseClass;
        ParameterizedType parameterizedType;
        Type type;
        Type type2 = t2.getType();
        if (type2 instanceof ParameterizedType && (type = (parameterizedType = (ParameterizedType)type2).getRawType()) instanceof Class && Map.class.isAssignableFrom(baseClass = (Class)type) && c instanceof Map && (map = (Map)c).containsKey("<<")) {
            HashMap newMap = new HashMap(map);
            List keys = (List)loader.loadType(STRING_LIST.getAnnotatedType(), map.get("<<"), depthTracker);
            keys.forEach(key -> {
                Pair<Configuration, Object> pair = this.getMetaValue((String)key, depthTracker);
                Object meta = pair.getRight();
                if (!(meta instanceof Map)) {
                    throw new LoadException("MetaMap injection candidate must be list, is type " + meta.getClass().getCanonicalName(), depthTracker);
                }
                newMap.putAll((Map)meta);
                String configName = pair.getLeft().getName() == null ? "Anonymous Configuration" : pair.getLeft().getName();
                depthTracker.addIntrinsicLevel(level -> {
                    EntryLevel entryLevel;
                    if (level instanceof EntryLevel && ((Map)meta).containsKey((entryLevel = (EntryLevel)level).getName())) {
                        return Optional.of("From configuration \"" + configName + "\"");
                    }
                    return Optional.empty();
                });
            });
            newMap.putAll(map);
            newMap.remove("<<");
            return Result.overwrite(newMap, depthTracker);
        }
        return Result.noOp();
    }
}

