/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.lifecycle;

import ca.solostudios.strata.Versions;
import ca.solostudios.strata.parser.tokenizer.ParseException;
import com.dfsek.terra.addon.EphemeralAddon;
import com.dfsek.terra.api.addon.BaseAddon;
import com.dfsek.terra.api.config.ConfigPack;
import com.dfsek.terra.lifecycle.util.BiomeUtil;
import com.dfsek.terra.mod.CommonPlatform;
import com.dfsek.terra.mod.ModPlatform;
import com.dfsek.terra.mod.generation.MinecraftChunkGeneratorWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2794;
import net.minecraft.class_2874;
import net.minecraft.class_3797;
import net.minecraft.class_5284;
import net.minecraft.class_7924;
import net.minecraft.class_8197;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LifecyclePlatform
extends ModPlatform {
    private static final Logger LOGGER = LoggerFactory.getLogger(LifecyclePlatform.class);
    private static MinecraftServer server;
    private static final AtomicReference<class_2378<class_1959>> BIOMES;
    private static final AtomicReference<class_2378<class_2874>> DIMENSIONS;
    private static final AtomicReference<class_2378<class_5284>> SETTINGS;
    private static final AtomicReference<class_2378<class_8197>> NOISE;

    public LifecyclePlatform() {
        CommonPlatform.initialize(this);
        this.load();
    }

    @Override
    public MinecraftServer getServer() {
        return server;
    }

    public static void setServer(MinecraftServer server) {
        LifecyclePlatform.server = server;
    }

    @Override
    public boolean reload() {
        this.getTerraConfig().load(this);
        this.getRawConfigRegistry().clear();
        boolean succeed = this.getRawConfigRegistry().loadAll(this);
        if (server != null) {
            BiomeUtil.registerBiomes((class_2378<class_1959>)server.method_30611().method_30530(class_7924.field_41236));
            ((CompletableFuture)server.method_29439(server.method_3836().method_29206()).exceptionally(throwable -> {
                LOGGER.warn("Failed to execute reload", throwable);
                return null;
            })).join();
            server.method_3738().forEach(world -> {
                class_2794 patt2658$temp = world.method_14178().method_12129();
                if (patt2658$temp instanceof MinecraftChunkGeneratorWrapper) {
                    MinecraftChunkGeneratorWrapper chunkGeneratorWrapper = (MinecraftChunkGeneratorWrapper)patt2658$temp;
                    this.getConfigRegistry().get(chunkGeneratorWrapper.getPack().getRegistryKey()).ifPresent(pack -> {
                        chunkGeneratorWrapper.setPack((ConfigPack)pack);
                        LOGGER.info("Replaced pack in chunk generator for world {}", world);
                    });
                }
            });
        }
        return succeed;
    }

    public static void setRegistries(class_2378<class_1959> biomeRegistry, class_2378<class_2874> dimensionTypeRegistry, class_2378<class_5284> chunkGeneratorSettingsRegistry, class_2378<class_8197> multiNoiseBiomeSourceParameterListRegistry) {
        BIOMES.set(biomeRegistry);
        DIMENSIONS.set(dimensionTypeRegistry);
        SETTINGS.set(chunkGeneratorSettingsRegistry);
        NOISE.set(multiNoiseBiomeSourceParameterListRegistry);
    }

    @Override
    protected Iterable<BaseAddon> platformAddon() {
        ArrayList<BaseAddon> addons = new ArrayList<BaseAddon>();
        super.platformAddon().forEach(addons::add);
        String mcVersion = class_3797.field_25319.method_48019();
        try {
            addons.add(new EphemeralAddon(Versions.parseVersion(mcVersion), "minecraft"));
        }
        catch (ParseException e) {
            try {
                addons.add(new EphemeralAddon(Versions.parseVersion(mcVersion + ".0"), "minecraft"));
            }
            catch (ParseException ex) {
                LOGGER.warn("Failed to parse Minecraft version", (Throwable)e);
            }
        }
        addons.addAll(this.getPlatformMods());
        return addons;
    }

    @Override
    public class_2378<class_2874> dimensionTypeRegistry() {
        return DIMENSIONS.get();
    }

    @Override
    public class_2378<class_1959> biomeRegistry() {
        return BIOMES.get();
    }

    @Override
    public class_2378<class_5284> chunkGeneratorSettingsRegistry() {
        return SETTINGS.get();
    }

    @Override
    public class_2378<class_8197> multiNoiseBiomeSourceParameterListRegistry() {
        return NOISE.get();
    }

    protected abstract Collection<BaseAddon> getPlatformMods();

    static {
        BIOMES = new AtomicReference();
        DIMENSIONS = new AtomicReference();
        SETTINGS = new AtomicReference();
        NOISE = new AtomicReference();
    }
}

