/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.mod.util;

import com.dfsek.terra.mod.util.MinecraftUtil;
import com.dfsek.terra.mod.util.PresetUtil;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7089;
import net.minecraft.class_7145;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TagUtil {
    private static final Logger logger = LoggerFactory.getLogger(TagUtil.class);

    private TagUtil() {
    }

    private static <T> Map<class_6862<T>, List<class_6880<T>>> tagsToMutableMap(class_2378<T> registry) {
        return registry.method_40272().collect(HashMap::new, (map, pair) -> map.put((class_6862)pair.getFirst(), new ArrayList(((class_6885.class_6888)pair.getSecond()).method_40239().toList())), HashMap::putAll);
    }

    public static void registerWorldPresetTags(class_2378<class_7145> registry) {
        logger.info("Doing preset tag garbage....");
        Map<class_6862<class_7145>, List<class_6880<class_7145>>> collect = TagUtil.tagsToMutableMap(registry);
        PresetUtil.getPresets().forEach(id -> MinecraftUtil.getEntry(registry, id).ifPresentOrElse(preset -> collect.computeIfAbsent(class_7089.field_37406, tag -> new ArrayList()).add(preset), () -> logger.error("Preset {} does not exist!", id)));
        registry.method_40278();
        registry.method_40257((Map)ImmutableMap.copyOf(collect));
    }

    public static void registerBiomeTags(class_2378<class_1959> registry) {
        logger.info("Doing biome tag garbage....");
        Map<class_6862<class_1959>, List<class_6880<class_1959>>> collect = TagUtil.tagsToMutableMap(registry);
        MinecraftUtil.getTerraBiomeMap().forEach((vb, terraBiomes) -> MinecraftUtil.getEntry(registry, vb).ifPresentOrElse(vanilla -> terraBiomes.forEach(tb -> MinecraftUtil.getEntry(registry, tb).ifPresentOrElse(terra -> {
            logger.debug(((class_5321)vanilla.method_40230().orElseThrow()).method_29177() + " (vanilla for " + ((class_5321)terra.method_40230().orElseThrow()).method_29177() + ": " + vanilla.method_40228().toList());
            vanilla.method_40228().forEach(tag -> collect.computeIfAbsent((class_6862<class_1959>)tag, t2 -> new ArrayList()).add(terra));
        }, () -> logger.error("No such biome: {}", tb))), () -> logger.error("No vanilla biome: {}", vb)));
        registry.method_40278();
        registry.method_40257((Map)ImmutableMap.copyOf(collect));
        if (logger.isDebugEnabled()) {
            registry.method_40270().map(e -> e.method_40237().method_29177() + ": " + e.method_40228().reduce("", (s2, t2) -> t2.comp_327() + ", " + s2, String::concat)).forEach(arg_0 -> ((Logger)logger).debug(arg_0));
        }
    }
}

