/*
 * Decompiled with CFR 0.152.
 */
package xyz.nikitacartes.easyauth.event;

import com.mojang.authlib.GameProfile;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerLoginNetworking;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2626;
import net.minecraft.class_3222;
import net.minecraft.class_3248;
import net.minecraft.class_3324;
import net.minecraft.server.MinecraftServer;
import xyz.nikitacartes.easyauth.EasyAuth;
import xyz.nikitacartes.easyauth.storage.AuthConfig;
import xyz.nikitacartes.easyauth.storage.PlayerCache;
import xyz.nikitacartes.easyauth.utils.EasyLogger;
import xyz.nikitacartes.easyauth.utils.FloodgateApiHelper;
import xyz.nikitacartes.easyauth.utils.PlayerAuth;

public class AuthEventHandler {
    public static long lastAcceptedPacket = 0L;
    public static Pattern usernamePattern;

    public static class_2561 checkCanPlayerJoinServer(GameProfile profile, class_3324 manager) {
        String incomingPlayerUsername = profile.getName();
        class_3222 onlinePlayer = manager.method_14566(incomingPlayerUsername);
        if (usernamePattern == null) {
            if (EasyAuth.config == null) {
                EasyAuth.config = AuthConfig.load(new File("./mods/EasyAuth/config.json"));
            }
            usernamePattern = Pattern.compile(EasyAuth.config.main.usernameRegex);
        }
        Matcher matcher = usernamePattern.matcher(incomingPlayerUsername);
        if (onlinePlayer != null && !((PlayerAuth)onlinePlayer).canSkipAuth() && EasyAuth.config.experimental.preventAnotherLocationKick) {
            return class_2561.method_30163((String)String.format(EasyAuth.config.lang.playerAlreadyOnline, onlinePlayer.method_5477().method_10851()));
        }
        if (!(matcher.matches() || EasyAuth.config.experimental.floodgateLoaded && EasyAuth.config.experimental.floodgateBypassUsernameRegex && FloodgateApiHelper.isFloodgatePlayer(profile.getId()))) {
            return class_2561.method_30163((String)String.format(EasyAuth.config.lang.disallowedUsername, EasyAuth.config.main.usernameRegex));
        }
        if (EasyAuth.config.main.maxLoginTries != -1) {
            PlayerCache playerCache;
            if (profile.getId() == null) {
                EasyLogger.LogDebug("Player UUID is null, skipping kicking attempt check.");
                return null;
            }
            String incomingPlayerUuid = profile.getId().toString();
            PlayerCache playerCache2 = playerCache = EasyAuth.playerCacheMap.containsKey(incomingPlayerUuid) ? EasyAuth.playerCacheMap.get(incomingPlayerUuid) : PlayerCache.fromJson(null, incomingPlayerUuid);
            if (playerCache.lastKicked >= System.currentTimeMillis() - 1000L * EasyAuth.config.experimental.resetLoginAttemptsTime) {
                return class_2561.method_30163((String)EasyAuth.config.lang.loginTriesExceeded);
            }
        }
        return null;
    }

    public static void onPlayerJoin(class_3222 player) {
        PlayerCache playerCache;
        if (((PlayerAuth)player).canSkipAuth()) {
            player.method_5684(false);
            player.method_5648(false);
            return;
        }
        String uuid = ((PlayerAuth)player).getFakeUuid();
        if (!EasyAuth.playerCacheMap.containsKey(uuid)) {
            playerCache = PlayerCache.fromJson(player, uuid);
            EasyAuth.playerCacheMap.put(uuid, playerCache);
        } else {
            playerCache = EasyAuth.playerCacheMap.get(uuid);
        }
        if (playerCache.isAuthenticated && playerCache.validUntil >= System.currentTimeMillis() && player.method_14209().equals(playerCache.lastIp)) {
            player.method_5684(false);
            player.method_5648(false);
            return;
        }
        if (EasyAuth.config.experimental.skipAllAuthChecks) {
            ((PlayerAuth)player).setAuthenticated(true);
            return;
        }
        ((PlayerAuth)player).setAuthenticated(false);
        if (EasyAuth.config.main.tryPortalRescue) {
            class_2338 pos = player.method_24515();
            player.method_20620((double)pos.method_10263() + 0.5, player.method_23318(), (double)pos.method_10260() + 0.5);
            if (player.method_36601().method_26204().equals(class_2246.field_10316) || player.method_37908().method_8320(player.method_24515().method_10084()).method_26204().equals(class_2246.field_10316)) {
                class_2626 feetPacket = new class_2626(pos, class_2246.field_10124.method_9564());
                player.field_13987.method_14364((class_2596)feetPacket);
                class_2626 headPacket = new class_2626(pos.method_10084(), class_2246.field_10124.method_9564());
                player.field_13987.method_14364((class_2596)headPacket);
                playerCache.wasInPortal = true;
            }
        }
    }

    public static void onPlayerLeave(class_3222 player) {
        if (((PlayerAuth)player).canSkipAuth()) {
            return;
        }
        String uuid = ((PlayerAuth)player).getFakeUuid();
        PlayerCache playerCache = EasyAuth.playerCacheMap.get(uuid);
        if (playerCache != null && playerCache.isAuthenticated) {
            playerCache.lastIp = player.method_14209();
            playerCache.validUntil = System.currentTimeMillis() + (long)EasyAuth.config.main.sessionTimeoutTime * 1000L;
        } else if (EasyAuth.config.main.spawnOnJoin) {
            ((PlayerAuth)player).hidePosition(false);
            player.method_5684(false);
            player.method_5648(false);
        }
    }

    public static class_1269 onPlayerCommand(class_3222 player, String command) {
        if (EasyAuth.config.experimental.allowCommands) {
            return class_1269.field_5811;
        }
        if (player == null) {
            return class_1269.field_5811;
        }
        if (command.startsWith("login ") || command.startsWith("register ") || EasyAuth.config.experimental.enableAliases && command.startsWith("l ")) {
            return class_1269.field_5811;
        }
        if (!((PlayerAuth)player).isAuthenticated()) {
            for (String allowedCommand : EasyAuth.config.experimental.allowedCommands) {
                if (!command.startsWith(allowedCommand)) continue;
                EasyLogger.LogDebug("Player " + player.method_5477() + " executed command " + command + " without being authenticated.");
                return class_1269.field_5811;
            }
            EasyLogger.LogDebug("Player " + player.method_5477() + " tried to execute command " + command + " without being authenticated.");
            player.method_7353(((PlayerAuth)player).getAuthMessage(), false);
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    public static class_1269 onPlayerChat(class_3222 player) {
        if (!((PlayerAuth)player).isAuthenticated() && !EasyAuth.config.experimental.allowChat) {
            player.method_7353(((PlayerAuth)player).getAuthMessage(), false);
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    public static class_1269 onPlayerMove(class_3222 player) {
        boolean auth = ((PlayerAuth)player).isAuthenticated();
        if (!auth && !EasyAuth.config.experimental.allowMovement) {
            if (System.nanoTime() >= lastAcceptedPacket + EasyAuth.config.experimental.teleportationTimeoutInMs * 1000000L) {
                player.field_13987.method_14363(player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455());
                lastAcceptedPacket = System.nanoTime();
            }
            if (!player.method_5655()) {
                player.method_5684(true);
            }
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    public static class_1269 onUseBlock(class_1657 player) {
        if (!((PlayerAuth)player).isAuthenticated() && !EasyAuth.config.experimental.allowBlockUse) {
            player.method_7353(((PlayerAuth)player).getAuthMessage(), false);
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    public static boolean onBreakBlock(class_1657 player) {
        if (!((PlayerAuth)player).isAuthenticated() && !EasyAuth.config.experimental.allowBlockPunch) {
            player.method_7353(((PlayerAuth)player).getAuthMessage(), false);
            return false;
        }
        return true;
    }

    public static class_1271<class_1799> onUseItem(class_1657 player) {
        if (!((PlayerAuth)player).isAuthenticated() && !EasyAuth.config.experimental.allowItemUse) {
            player.method_7353(((PlayerAuth)player).getAuthMessage(), false);
            return class_1271.method_22431((Object)class_1799.field_8037);
        }
        return class_1271.method_22430((Object)class_1799.field_8037);
    }

    public static class_1269 onDropItem(class_1657 player) {
        if (!((PlayerAuth)player).isAuthenticated() && !EasyAuth.config.experimental.allowItemDrop) {
            player.method_7353(((PlayerAuth)player).getAuthMessage(), false);
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    public static class_1269 onTakeItem(class_3222 player) {
        if (!((PlayerAuth)player).isAuthenticated() && !EasyAuth.config.experimental.allowItemMoving) {
            player.method_7353(((PlayerAuth)player).getAuthMessage(), false);
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    public static class_1269 onAttackEntity(class_1657 player) {
        if (!((PlayerAuth)player).isAuthenticated() && !EasyAuth.config.experimental.allowEntityPunch) {
            player.method_7353(((PlayerAuth)player).getAuthMessage(), false);
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    public static class_1269 onUseEntity(class_1657 player) {
        if (!((PlayerAuth)player).isAuthenticated() && !EasyAuth.config.main.allowEntityInteract) {
            player.method_7353(((PlayerAuth)player).getAuthMessage(), false);
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    public static void onPreLogin(class_3248 netHandler, MinecraftServer server, PacketSender packetSender, ServerLoginNetworking.LoginSynchronizer sync) {
        if (EasyAuth.config.experimental.forcedOfflineUuids) {
            netHandler.field_14160 = netHandler.method_14375(netHandler.field_14160);
        }
    }
}

