/*
 * Decompiled with CFR 0.152.
 */
package xyz.nikitacartes.easyauth.storage.database;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBException;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.WriteBatch;
import org.iq80.leveldb.impl.Iq80DBFactory;
import xyz.nikitacartes.easyauth.EasyAuth;
import xyz.nikitacartes.easyauth.storage.AuthConfig;
import xyz.nikitacartes.easyauth.storage.PlayerCache;
import xyz.nikitacartes.easyauth.storage.database.DBApiException;
import xyz.nikitacartes.easyauth.storage.database.DbApi;
import xyz.nikitacartes.easyauth.utils.EasyLogger;

public class LevelDB
implements DbApi {
    private DB levelDBStore;
    private final AuthConfig config;

    public LevelDB(AuthConfig config) {
        this.config = config;
    }

    @Override
    public void connect() throws DBApiException {
        try {
            File file = new File(EasyAuth.gameDirectory + "/mods/EasyAuth/levelDBStore");
            if (!file.exists() && !file.mkdirs()) {
                throw new DBApiException("Error creating LevelDB directory", null);
            }
            EasyLogger.LogDebug("You are using LevelDB");
            Options options = new Options();
            this.levelDBStore = Iq80DBFactory.factory.open(new File(EasyAuth.gameDirectory + "/mods/" + (this.config.experimental.useSimpleAuthDatabase ? "SimpleAuth" : "EasyAuth") + "/levelDBStore"), options);
        }
        catch (IOException e) {
            throw new DBApiException("Failed setting up LevelDB", e);
        }
    }

    @Override
    public void close() {
        if (this.levelDBStore != null) {
            try {
                this.levelDBStore.close();
                this.levelDBStore = null;
                EasyLogger.LogInfo("Database connection closed successfully");
            }
            catch (IOException | Error e) {
                EasyLogger.LogError("Database connection not closed", e);
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.levelDBStore == null;
    }

    @Override
    @Deprecated
    public boolean registerUser(String uuid, String data) {
        try {
            if (!this.isUserRegistered(uuid)) {
                this.levelDBStore.put(Iq80DBFactory.bytes((String)("UUID:" + uuid)), Iq80DBFactory.bytes((String)("data:" + data)));
                return true;
            }
            return false;
        }
        catch (Error e) {
            EasyLogger.LogError("Register error", e);
            return false;
        }
    }

    @Override
    public boolean isUserRegistered(String uuid) {
        try {
            return this.levelDBStore.get(Iq80DBFactory.bytes((String)("UUID:" + uuid))) != null;
        }
        catch (DBException e) {
            EasyLogger.LogError("isUserRegistered error", e);
            return false;
        }
    }

    @Override
    public void deleteUserData(String uuid) {
        try {
            this.levelDBStore.delete(Iq80DBFactory.bytes((String)("UUID:" + uuid)));
        }
        catch (Error e) {
            EasyLogger.LogError("deleteUserData error", e);
        }
    }

    @Override
    @Deprecated
    public void updateUserData(String uuid, String data) {
        try {
            this.levelDBStore.put(Iq80DBFactory.bytes((String)("UUID:" + uuid)), Iq80DBFactory.bytes((String)("data:" + data)));
        }
        catch (Error e) {
            EasyLogger.LogError("updateUserData error", e);
        }
    }

    @Override
    public String getUserData(String uuid) {
        try {
            if (this.isUserRegistered(uuid)) {
                return new String(this.levelDBStore.get(Iq80DBFactory.bytes((String)("UUID:" + uuid)))).substring(5);
            }
        }
        catch (Error e) {
            EasyLogger.LogError("getUserData error", e);
        }
        return "";
    }

    @Override
    public void saveAll(HashMap<String, PlayerCache> playerCacheMap) {
        WriteBatch batch = this.levelDBStore.createWriteBatch();
        playerCacheMap.forEach((uuid, playerCache) -> {
            String data = playerCache.toJson();
            batch.put(Iq80DBFactory.bytes((String)("UUID:" + uuid)), Iq80DBFactory.bytes((String)("data:" + data)));
        });
        try {
            this.levelDBStore.write(batch);
            batch.close();
        }
        catch (IOException e) {
            EasyLogger.LogError("Error saving player data", e);
        }
    }
}

