/*
 * Decompiled with CFR 0.152.
 */
package xyz.nikitacartes.easyauth.storage.database;

import com.mysql.cj.jdbc.exceptions.CommunicationsException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import xyz.nikitacartes.easyauth.storage.AuthConfig;
import xyz.nikitacartes.easyauth.storage.PlayerCache;
import xyz.nikitacartes.easyauth.storage.database.DBApiException;
import xyz.nikitacartes.easyauth.storage.database.DbApi;
import xyz.nikitacartes.easyauth.utils.EasyLogger;

public class MySQL
implements DbApi {
    private final AuthConfig config;
    private Connection MySQLConnection;

    public MySQL(AuthConfig config) {
        this.config = config;
    }

    @Override
    public void connect() throws DBApiException {
        try {
            EasyLogger.LogDebug("You are using MySQL DB");
            Class.forName("com.mysql.cj.jdbc.Driver");
            String uri = "jdbc:mysql://" + this.config.main.MySQLHost + "/" + this.config.main.MySQLDatabase + "?autoReconnect=true";
            EasyLogger.LogDebug(String.format("connecting to %s", uri));
            this.MySQLConnection = DriverManager.getConnection(uri, this.config.main.MySQLUser, this.config.main.MySQLPassword);
            PreparedStatement preparedStatement = this.MySQLConnection.prepareStatement("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME = ?;");
            preparedStatement.setString(1, this.config.main.MySQLTableName);
            if (!preparedStatement.executeQuery().next()) {
                this.MySQLConnection.createStatement().executeUpdate(String.format("CREATE TABLE `%s`.`%s` (\n    `id` INT NOT NULL AUTO_INCREMENT,\n    `uuid` VARCHAR(36) NOT NULL,\n    `data` JSON NOT NULL,\n    PRIMARY KEY (`id`), UNIQUE (`uuid`)\n) ENGINE = InnoDB;", this.config.main.MySQLDatabase, this.config.main.MySQLTableName));
            }
        }
        catch (ClassNotFoundException | SQLException e) {
            this.MySQLConnection = null;
            throw new DBApiException("Failed setting up mysql DB", e);
        }
    }

    private void reConnect() {
        try {
            if (this.MySQLConnection == null || !this.MySQLConnection.isValid(5)) {
                EasyLogger.LogDebug("Reconnecting to MySQL");
                if (this.MySQLConnection != null) {
                    this.MySQLConnection.close();
                }
                this.connect();
            }
        }
        catch (SQLException | DBApiException e) {
            EasyLogger.LogError("Mysql reconnect failed", e);
        }
    }

    @Override
    public void close() {
        try {
            if (this.MySQLConnection != null) {
                this.MySQLConnection.close();
                this.MySQLConnection = null;
                EasyLogger.LogInfo("Database connection closed successfully.");
            }
        }
        catch (CommunicationsException e) {
            EasyLogger.LogError("Can't connect to database while closing", e);
        }
        catch (SQLException e) {
            EasyLogger.LogError("Database connection not closed", e);
        }
    }

    @Override
    public boolean isClosed() {
        return this.MySQLConnection == null;
    }

    @Override
    @Deprecated
    public boolean registerUser(String uuid, String data) {
        try {
            this.reConnect();
            if (!this.isUserRegistered(uuid)) {
                PreparedStatement preparedStatement = this.MySQLConnection.prepareStatement("INSERT INTO " + this.config.main.MySQLTableName + " (uuid, data) VALUES (?, ?);");
                preparedStatement.setString(1, uuid);
                preparedStatement.setString(2, data);
                preparedStatement.executeUpdate();
                return true;
            }
        }
        catch (SQLException e) {
            EasyLogger.LogError("Register error ", e);
        }
        return false;
    }

    @Override
    public boolean isUserRegistered(String uuid) {
        try {
            this.reConnect();
            PreparedStatement preparedStatement = this.MySQLConnection.prepareStatement("SELECT * FROM " + this.config.main.MySQLTableName + " WHERE uuid = ?;");
            preparedStatement.setString(1, uuid);
            return preparedStatement.executeQuery().next();
        }
        catch (SQLException e) {
            EasyLogger.LogError("isUserRegistered error", e);
            return false;
        }
    }

    @Override
    public void deleteUserData(String uuid) {
        try {
            this.reConnect();
            PreparedStatement preparedStatement = this.MySQLConnection.prepareStatement("DELETE FROM " + this.config.main.MySQLTableName + " WHERE uuid = ?;");
            preparedStatement.setString(1, uuid);
            preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            EasyLogger.LogError("deleteUserData error", e);
        }
    }

    @Override
    @Deprecated
    public void updateUserData(String uuid, String data) {
        try {
            this.reConnect();
            PreparedStatement preparedStatement = this.MySQLConnection.prepareStatement("UPDATE " + this.config.main.MySQLTableName + " SET data = ? WHERE uuid = ?;");
            preparedStatement.setString(1, data);
            preparedStatement.setString(1, uuid);
            preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            EasyLogger.LogError("updateUserData error", e);
        }
    }

    @Override
    public String getUserData(String uuid) {
        try {
            this.reConnect();
            if (this.isUserRegistered(uuid)) {
                PreparedStatement preparedStatement = this.MySQLConnection.prepareStatement("SELECT data FROM " + this.config.main.MySQLTableName + " WHERE uuid = ?;");
                preparedStatement.setString(1, uuid);
                ResultSet query = preparedStatement.executeQuery();
                query.next();
                return query.getString(1);
            }
        }
        catch (SQLException e) {
            EasyLogger.LogError("getUserData error", e);
        }
        return "";
    }

    @Override
    public void saveAll(HashMap<String, PlayerCache> playerCacheMap) {
        try {
            this.reConnect();
            PreparedStatement preparedStatement = this.MySQLConnection.prepareStatement("INSERT INTO " + this.config.main.MySQLTableName + " (uuid, data) VALUES (?, ?) ON DUPLICATE KEY UPDATE data = ?;");
            playerCacheMap.forEach((uuid, playerCache) -> {
                String data = playerCache.toJson();
                try {
                    preparedStatement.setString(1, (String)uuid);
                    preparedStatement.setString(2, data);
                    preparedStatement.setString(3, data);
                    preparedStatement.addBatch();
                }
                catch (SQLException e) {
                    EasyLogger.LogError(String.format("Error saving player data! %s ", uuid));
                }
            });
            preparedStatement.executeBatch();
        }
        catch (NullPointerException | SQLException e) {
            EasyLogger.LogError("Error saving players data", e);
        }
    }
}

