/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.signed_paintings.mixin;

import com.nettakrim.signed_paintings.SignedPaintingsClient;
import com.nettakrim.signed_paintings.access.AbstractSignEditScreenAccessor;
import com.nettakrim.signed_paintings.access.SignBlockEntityAccessor;
import com.nettakrim.signed_paintings.gui.BackgroundClick;
import com.nettakrim.signed_paintings.gui.InputSlider;
import com.nettakrim.signed_paintings.gui.SignEditingInfo;
import com.nettakrim.signed_paintings.rendering.BackType;
import com.nettakrim.signed_paintings.rendering.Centering;
import com.nettakrim.signed_paintings.rendering.PaintingInfo;
import com.nettakrim.signed_paintings.rendering.SignSideInfo;
import com.nettakrim.signed_paintings.util.ImageManager;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.class_2561;
import net.minecraft.class_2625;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_3728;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7743;
import net.minecraft.class_8242;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_7743.class})
public abstract class AbstractSignEditScreenMixin
extends class_437
implements AbstractSignEditScreenAccessor {
    @Shadow
    private class_8242 field_43362;
    @Final
    @Shadow
    private String[] field_40425;
    @Final
    @Shadow
    private class_2625 field_40424;
    @Final
    @Shadow
    private boolean field_43363;
    @Shadow
    private int field_40428;
    @Shadow
    private class_3728 field_40429;
    @Unique
    private final InputSlider[] inputSliders = new InputSlider[4];
    @Unique
    private final ArrayList<class_339> buttons = new ArrayList();
    @Unique
    private class_339 uploadButton;
    @Unique
    private boolean aspectLocked = true;
    @Unique
    private float aspectRatio;
    @Unique
    private String uploadURL = null;

    protected AbstractSignEditScreenMixin(class_2561 title) {
        super(title);
    }

    @Shadow
    protected abstract void method_49913(String var1);

    @Inject(at={@At(value="TAIL")}, method={"init"})
    private void init(CallbackInfo ci) {
        float pixelsPerBlock;
        float yOffset;
        BackType.Type backType;
        float height;
        float width;
        PaintingInfo info;
        this.buttons.clear();
        Centering.Type[] centering = Centering.Type.values();
        Centering.Type[] reversedCentering = new Centering.Type[]{Centering.Type.MAX, Centering.Type.CENTER, Centering.Type.MIN};
        for (Centering.Type yCentering : centering) {
            for (Centering.Type xCentering : reversedCentering) {
                this.createCenteringButton(51, 20, xCentering, yCentering);
            }
        }
        SignBlockEntityAccessor sign = (SignBlockEntityAccessor)this.field_40424;
        PaintingInfo paintingInfo = info = this.field_43363 ? sign.signedPaintings$getFrontPaintingInfo() : sign.signedPaintings$getBackPaintingInfo();
        if (info == null) {
            width = 1.0f;
            height = 1.0f;
            backType = BackType.Type.SIGN;
            yOffset = 0.0f;
            pixelsPerBlock = 0.0f;
        } else {
            width = info.getWidth();
            height = info.getHeight();
            backType = info.getBackType();
            yOffset = info.getYOffset();
            pixelsPerBlock = info.getPixelsPerBlock();
            info.working = true;
        }
        this.inputSliders[2] = this.createYOffsetSlider(76, 50, 50, 20, 5, "signed_paintings.offset_y", yOffset);
        this.inputSliders[2].setOnValueChanged(this::onYOffsetSliderChanged);
        this.inputSliders[0] = this.createSizingSlider(Centering.Type.MAX, 51, 50, 50, 20, 5, "signed_paintings.size.x", width);
        this.createLockingButton(Centering.Type.CENTER, 51, 20, AbstractSignEditScreenMixin.getAspectLockIcon(this.aspectLocked));
        this.createResetButton(Centering.Type.CENTER, 51, 80, 20, (class_2561)class_2561.method_43471((String)"signed_paintings.size.reset"));
        this.inputSliders[1] = this.createSizingSlider(Centering.Type.MIN, 51, 50, 50, 20, 5, "signed_paintings.size.y", height);
        this.inputSliders[0].setOnValueChanged(value -> this.onSizeSliderChanged(value.floatValue(), true));
        this.inputSliders[1].setOnValueChanged(value -> this.onSizeSliderChanged(value.floatValue(), false));
        this.aspectRatio = width / height;
        this.inputSliders[3] = this.createPixelSlider(101, 50, 50, 20, 5, "signed_paintings.pixels_per_block", pixelsPerBlock);
        this.inputSliders[3].setOnValueChanged(this::onPixelSliderChanged);
        this.createBackModeButton(76, 105, 20, backType);
        this.uploadButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"signed_paintings.upload_prompt"), this::upload).method_46434(this.field_22789 / 2 - 100, this.field_22790 / 4 + 144 - 25, 200, 20).method_46431();
        this.method_37063((class_364)this.uploadButton);
        this.method_25429((class_364)this.uploadButton);
        if (this.uploadURL == null) {
            this.uploadButton.field_22764 = false;
        }
        BackgroundClick backgroundClick = new BackgroundClick(this.inputSliders);
        this.method_25429((class_364)backgroundClick);
        this.buttons.add(backgroundClick);
        SignedPaintingsClient.currentSignEdit.setSelectionManager(this.field_40429);
        if (info == null || !info.isReady()) {
            this.signedPaintings$setVisibility(false);
        }
    }

    @Unique
    private void createCenteringButton(int areaSize, int buttonSize, Centering.Type xCentering, Centering.Type yCentering) {
        String id = (Centering.getName(true, xCentering) + Centering.getName(false, yCentering)).toLowerCase(Locale.ROOT);
        class_4185 widget = class_4185.method_46430((class_2561)class_2561.method_43471((String)("signed_paintings.align." + id)), button -> SignedPaintingsClient.currentSignEdit.getSideInfo(this.field_43363).updatePaintingCentering(xCentering, yCentering)).method_46433(this.getCenteringButtonPosition(areaSize, xCentering, buttonSize, this.field_22789) - areaSize / 2 - buttonSize / 2 - 60, this.getCenteringButtonPosition(-areaSize, yCentering, buttonSize, 0) + areaSize / 2 + buttonSize / 2 + 67).method_46437(buttonSize, buttonSize).method_46431();
        this.method_37063((class_364)widget);
        this.method_25429((class_364)widget);
        this.buttons.add((class_339)widget);
    }

    @Unique
    private void createBackModeButton(int yOffset, int buttonWidth, int buttonHeight, BackType.Type backType) {
        class_4185 widget = class_4185.method_46430((class_2561)AbstractSignEditScreenMixin.getBackTypeText(backType), this::cyclePaintingBack).method_46433(this.field_22789 / 2 + 60, yOffset + 68).method_46437(buttonWidth, buttonHeight).method_46431();
        this.method_37063((class_364)widget);
        this.method_25429((class_364)widget);
        this.buttons.add((class_339)widget);
    }

    @Unique
    private int getCenteringButtonPosition(int size, Centering.Type centering, int buttonSize, int screenSize) {
        return class_3532.method_15375((float)Centering.getOffset(size, centering)) + screenSize / 2 - buttonSize / 2;
    }

    @Unique
    private InputSlider createSizingSlider(Centering.Type centering, int areaSize, int textWidth, int sliderWidth, int widgetHeight, int elementSpacing, String key, float startingValue) {
        int x = this.field_22789 / 2 + 60;
        int y = this.getCenteringButtonPosition(areaSize, centering, widgetHeight, 0) + areaSize / 2 + widgetHeight / 2 + 67;
        InputSlider inputSlider = new InputSlider(x, y, textWidth, sliderWidth, widgetHeight, elementSpacing, 0.5f, 10.0f, 0.5f, startingValue, 0.03125f, 64.0f, (class_2561)class_2561.method_43471((String)key));
        this.method_37063((class_364)inputSlider.sliderWidget);
        this.method_25429((class_364)inputSlider.sliderWidget);
        this.buttons.add((class_339)inputSlider.sliderWidget);
        this.method_37063((class_364)inputSlider.textFieldWidget);
        this.method_25429((class_364)inputSlider.textFieldWidget);
        this.buttons.add((class_339)inputSlider.textFieldWidget);
        return inputSlider;
    }

    @Unique
    private void createLockingButton(Centering.Type centering, int areaSize, int buttonSize, class_2561 text) {
        class_4185 widget = class_4185.method_46430((class_2561)text, this::toggleAspectLock).method_46433(this.field_22789 / 2 + 60, this.getCenteringButtonPosition(areaSize, centering, buttonSize, 0) + areaSize / 2 + buttonSize / 2 + 67).method_46437(buttonSize, buttonSize).method_46431();
        this.method_37063((class_364)widget);
        this.method_25429((class_364)widget);
        this.buttons.add((class_339)widget);
    }

    @Unique
    private void createResetButton(Centering.Type centering, int areaSize, int buttonWidth, int buttonHeight, class_2561 text) {
        class_4185 widget = class_4185.method_46430((class_2561)text, this::resetSize).method_46433(this.field_22789 / 2 + 60 + 25, this.getCenteringButtonPosition(areaSize, centering, buttonHeight, 0) + areaSize / 2 + buttonHeight / 2 + 67).method_46437(buttonWidth, buttonHeight).method_46431();
        this.method_37063((class_364)widget);
        this.method_25429((class_364)widget);
        this.buttons.add((class_339)widget);
    }

    @Unique
    private InputSlider createYOffsetSlider(int yOffset, int textWidth, int sliderWidth, int widgetHeight, int elementSpacing, String key, float startingValue) {
        int x = this.field_22789 / 2 - 60 - (textWidth + sliderWidth + elementSpacing);
        int y = yOffset + 68;
        InputSlider inputSlider = new InputSlider(x, y, textWidth, sliderWidth, widgetHeight, elementSpacing, -8.0f, 8.0f, 1.0f, startingValue, -64.0f, 64.0f, (class_2561)class_2561.method_43471((String)key));
        this.method_37063((class_364)inputSlider.sliderWidget);
        this.method_25429((class_364)inputSlider.sliderWidget);
        this.buttons.add((class_339)inputSlider.sliderWidget);
        this.method_37063((class_364)inputSlider.textFieldWidget);
        this.method_25429((class_364)inputSlider.textFieldWidget);
        this.buttons.add((class_339)inputSlider.textFieldWidget);
        return inputSlider;
    }

    @Unique
    private InputSlider createPixelSlider(int yOffset, int textWidth, int sliderWidth, int widgetHeight, int elementSpacing, String key, float startingValue) {
        int x = this.field_22789 / 2 + 60;
        int y = yOffset + 68;
        InputSlider inputSlider = new InputSlider(x, y, textWidth, sliderWidth, widgetHeight, elementSpacing, 0.0f, 64.0f, 16.0f, startingValue, 0.0f, 1024.0f, (class_2561)class_2561.method_43471((String)key));
        this.method_37063((class_364)inputSlider.sliderWidget);
        this.method_25429((class_364)inputSlider.sliderWidget);
        this.buttons.add((class_339)inputSlider.sliderWidget);
        this.method_37063((class_364)inputSlider.textFieldWidget);
        this.method_25429((class_364)inputSlider.textFieldWidget);
        this.buttons.add((class_339)inputSlider.textFieldWidget);
        return inputSlider;
    }

    @Unique
    private void toggleAspectLock(class_4185 button) {
        this.setAspectLock(!this.aspectLocked);
        button.method_25355(AbstractSignEditScreenMixin.getAspectLockIcon(this.aspectLocked));
    }

    @Unique
    private void setAspectLock(boolean to) {
        this.aspectLocked = to;
        if (this.aspectLocked) {
            this.aspectRatio = this.inputSliders[0].getValue() / this.inputSliders[1].getValue();
        }
    }

    @Unique
    private void resetSize(class_4185 button) {
        SignSideInfo info = SignedPaintingsClient.currentSignEdit.getSideInfo(this.field_43363);
        info.resetSize();
        this.inputSliders[0].setValue(info.paintingInfo.getWidth());
        this.inputSliders[1].setValue(info.paintingInfo.getHeight());
        this.aspectRatio = this.inputSliders[0].getValue() / this.inputSliders[1].getValue();
    }

    @Unique
    private static class_2561 getAspectLockIcon(boolean aspectLocked) {
        return class_2561.method_43471((String)("signed_paintings.aspect." + (aspectLocked ? "locked" : "unlocked")));
    }

    @Unique
    private static class_2561 getBackTypeText(BackType.Type backType) {
        return class_2561.method_43471((String)("signed_paintings.back_mode." + backType.toString().toLowerCase(Locale.ROOT)));
    }

    @Unique
    private void cyclePaintingBack(class_4185 button) {
        BackType.Type newType = SignedPaintingsClient.currentSignEdit.getSideInfo(this.field_43363).cyclePaintingBack();
        button.method_25355(AbstractSignEditScreenMixin.getBackTypeText(newType));
    }

    @Unique
    private void onSizeSliderChanged(float value, boolean isWidth) {
        if (this.aspectLocked) {
            value = isWidth ? (value /= this.aspectRatio) : (value *= this.aspectRatio);
            value = SignedPaintingsClient.roundFloatTo3DP(value);
            this.inputSliders[isWidth ? 1 : 0].setValue(value);
        }
        SignedPaintingsClient.currentSignEdit.getSideInfo(this.field_43363).updatePaintingSize(this.inputSliders[0].getValue(), this.inputSliders[1].getValue());
    }

    @Unique
    private void onYOffsetSliderChanged(float value) {
        SignedPaintingsClient.currentSignEdit.getSideInfo(this.field_43363).updatePaintingYOffset(value);
    }

    @Unique
    private void onPixelSliderChanged(float value) {
        SignedPaintingsClient.currentSignEdit.getSideInfo(this.field_43363).updatePaintingPixelsPerBlock(value);
    }

    @Inject(at={@At(value="TAIL")}, method={"<init>(Lnet/minecraft/block/entity/SignBlockEntity;ZZLnet/minecraft/text/Text;)V"})
    private void onScreenOpen(class_2625 blockEntity, boolean front, boolean filtered, class_2561 title, CallbackInfo ci) {
        SignedPaintingsClient.currentSignEdit = new SignEditingInfo(blockEntity, this);
    }

    @Inject(at={@At(value="TAIL")}, method={"finishEditing"})
    private void onScreenClose(CallbackInfo ci) {
        SignedPaintingsClient.currentSignEdit = null;
    }

    @Inject(at={@At(value="HEAD")}, method={"keyPressed"}, cancellable=true)
    private void onKeyPress(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        for (InputSlider slider : this.inputSliders) {
            if (slider == null || !slider.isFocused() || !slider.keyPressed(keyCode, scanCode, modifiers)) continue;
            cir.setReturnValue((Object)true);
            cir.cancel();
            return;
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"charTyped"}, cancellable=true)
    private void onCharType(char chr, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        for (InputSlider slider : this.inputSliders) {
            if (slider == null || !slider.isFocused() || !slider.charTyped(chr, modifiers)) continue;
            cir.setReturnValue((Object)true);
            cir.cancel();
            return;
        }
    }

    @ModifyVariable(at=@At(value="STORE"), method={"renderSignText"}, ordinal=0)
    private boolean stopTextCaret(boolean bl) {
        for (InputSlider slider : this.inputSliders) {
            if (slider == null || !slider.isFocused()) continue;
            this.field_40429.method_35731(this.field_40429.method_16201());
            return false;
        }
        return bl;
    }

    @Override
    public void signedPaintings$clear() {
        for (int i = 0; i < this.field_40425.length; ++i) {
            this.field_40425[i] = "";
            this.field_43362 = this.field_43362.method_49857(i, (class_2561)class_2561.method_43470((String)"message"));
        }
        this.field_40424.method_49840(this.field_43362, this.field_43363);
        this.field_40428 = 0;
    }

    @Override
    public int signedPaintings$paste(String pasteString, int selectionStart, int selectionEnd) {
        String url;
        String[] newMessages = new String[this.field_40425.length];
        System.arraycopy(this.field_40425, 0, newMessages, 0, this.field_40425.length);
        int maxWidthPerLine = this.field_40424.method_45470();
        class_327 textRenderer = SignedPaintingsClient.client.field_1772;
        selectionStart = class_3532.method_15340((int)selectionStart, (int)0, (int)newMessages[this.field_40428].length());
        selectionEnd = class_3532.method_15340((int)selectionEnd, (int)0, (int)newMessages[this.field_40428].length());
        newMessages[this.field_40428] = newMessages[this.field_40428].substring(0, selectionStart) + pasteString + newMessages[this.field_40428].substring(selectionEnd);
        int currentWidth = textRenderer.method_1727(newMessages[this.field_40428]);
        int cursor = selectionStart + pasteString.length();
        if (ImageManager.isValid(pasteString) && (SignedPaintingsClient.imageManager.DomainBlocked(url = SignedPaintingsClient.imageManager.applyURLInferences(pasteString)) || (double)textRenderer.method_1727(SignedPaintingsClient.imageManager.getShortestURLInference(url)) > (double)maxWidthPerLine * 2.5)) {
            this.uploadURL = url;
            this.uploadButton.field_22764 = true;
        }
        if (currentWidth < maxWidthPerLine) {
            this.method_49913(newMessages[this.field_40428]);
            return cursor;
        }
        int cursorRow = this.field_40428;
        while (true) {
            String line = newMessages[this.field_40428];
            int index = SignedPaintingsClient.getMaxFittingIndex(line, maxWidthPerLine, textRenderer);
            newMessages[this.field_40428] = line.substring(0, index);
            if (this.field_40428 == this.field_40425.length - 1 || line.length() <= index) break;
            if (this.field_40428 == cursorRow && cursor > index) {
                ++cursorRow;
                cursor -= index;
            }
            ++this.field_40428;
            newMessages[this.field_40428] = line.substring(index) + newMessages[this.field_40428];
        }
        cursor = class_3532.method_15340((int)cursor, (int)0, (int)newMessages[cursorRow].length());
        for (int i = 0; i < this.field_40425.length; ++i) {
            this.field_40425[i] = newMessages[i];
            this.field_43362 = this.field_43362.method_49857(i, (class_2561)class_2561.method_43470((String)this.field_40425[i]));
        }
        this.field_40424.method_49840(this.field_43362, this.field_43363);
        this.field_40428 = cursorRow;
        return cursor;
    }

    @Unique
    private void upload(class_4185 button) {
        if (this.uploadURL == null) {
            return;
        }
        SignedPaintingsClient.uploadManager.uploadUrlToImgur(this.uploadURL, this::uploadFinished);
    }

    @Unique
    private void uploadFinished(String link) {
        if (!SignedPaintingsClient.currentSignEdit.sign.equals(this.field_40424)) {
            return;
        }
        if (link == null) {
            this.uploadButton.method_25355((class_2561)class_2561.method_43471((String)"signed_paintings.upload_fail"));
            this.uploadURL = null;
            return;
        }
        this.uploadButton.field_22764 = false;
        this.signedPaintings$clear();
        this.signedPaintings$paste(link, 0, 0);
    }

    @Override
    public void signedPaintings$setVisibility(boolean to) {
        for (class_339 clickableWidget : this.buttons) {
            clickableWidget.field_22764 = to;
        }
    }

    @Override
    public void signedPaintings$initSliders(float width, float height) {
        this.inputSliders[0].setValue(width);
        this.inputSliders[1].setValue(height);
        this.aspectRatio = width / height;
    }
}

