/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.signed_paintings.rendering;

import com.nettakrim.signed_paintings.rendering.Centering;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import org.joml.AxisAngle4f;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Cuboid {
    private final Vector3fc size;
    private final Vector3fc offset;
    private Matrix4f positionCache;
    private Matrix3f normalCache;

    public Cuboid(float xSize, float ySize, float zSize, float xOffset, float yOffset, float zOffset) {
        this.size = new Vector3f(xSize, ySize, zSize);
        this.offset = new Vector3f(xOffset, yOffset, zOffset);
    }

    public static Cuboid CreateWallCuboid(float xSize, Centering.Type xCentering, float ySize, Centering.Type yCentering, float zSize, float xOffset, float yOffset, float zOffset) {
        return new Cuboid(xSize, ySize, zSize, Centering.getOffset(xSize, xCentering) + xOffset, Centering.getOffset(ySize, yCentering) + yOffset, -0.5025f + zSize / 2.0f + zOffset);
    }

    public static Cuboid CreateFlushCuboid(float xSize, Centering.Type xCentering, float ySize, Centering.Type yCentering, float zSize, float xOffset, float yOffset, float zOffset) {
        return new Cuboid(xSize, ySize, zSize, Centering.getOffset(xSize, xCentering) + xOffset, Centering.getOffset(ySize, yCentering) + yOffset, 0.5f - zSize / 2.0f + zOffset);
    }

    public static Cuboid CreateCentralCuboid(float xSize, Centering.Type xCentering, float ySize, Centering.Type yCentering, float zSize, float xOffset, float yOffset, float zOffset) {
        return new Cuboid(xSize, ySize, zSize, Centering.getOffset(xSize, xCentering) + xOffset, Centering.getOffset(ySize, yCentering) + yOffset, zSize / 2.0f + zOffset - 0.0025f);
    }

    public static Cuboid CreateOverlayCuboid(float aspectRatio) {
        float width = 0.8333333f;
        float height = 1.6666666f;
        if (aspectRatio > 0.5f) {
            height /= aspectRatio * 2.0f;
        } else {
            width *= aspectRatio * 2.0f;
        }
        return new Cuboid(width, height, 0.125f, 0.0f, -0.8333333f, 0.0f);
    }

    public void setupRendering(class_4587 matrices) {
        class_4587.class_4665 entry = matrices.method_23760();
        this.positionCache = entry.method_23761();
        this.normalCache = entry.method_23762();
    }

    public void renderFace(class_4588 vertexConsumer, Vector3f face, boolean split, float minU, float maxU, float minV, float maxV, int light) {
        AxisAngle4f rotation;
        if (face.y == 0.0f) {
            float angle = 0.0f;
            if (face.z == 0.0f) {
                angle = face.x < 0.0f ? 1.5707964f : -1.5707964f;
            } else if (face.z < 0.0f) {
                angle = (float)Math.PI;
            }
            rotation = new AxisAngle4f(angle, 0.0f, 1.0f, 0.0f);
        } else {
            float angle = face.y < 0.0f ? 1.5707964f : -1.5707964f;
            rotation = new AxisAngle4f(angle, 1.0f, 0.0f, 0.0f);
        }
        this.renderFaceRotated(vertexConsumer, rotation, split, minU, maxU, minV, maxV, light);
    }

    private Vector3f adjustVertex(Vector3f v, AxisAngle4f rotation) {
        Vector3f vertex = rotation.transform(v);
        vertex.mul(this.size);
        vertex.add(this.offset);
        return vertex;
    }

    private void renderFaceRotated(class_4588 vertexConsumer, AxisAngle4f rotation, boolean split, float minU, float maxU, float minV, float maxV, int light) {
        Vector3f normal = rotation.transform(new Vector3f(0.0f, 0.0f, 1.0f));
        if (!split) {
            this.renderQuad(vertexConsumer, -0.5f, 0.5f, -0.5f, 0.5f, 0.5f, rotation, minU, maxU, minV, maxV, normal, light);
            return;
        }
        Vector3f relevantSize = new Vector3f(this.size);
        rotation.transform(relevantSize);
        relevantSize.absolute();
        for (float minX = 0.0f; minX < relevantSize.x; minX += 1.0f) {
            for (float minY = 0.0f; minY < relevantSize.y; minY += 1.0f) {
                float maxX = Math.min(minX + 1.0f, relevantSize.x);
                float maxY = Math.min(minY + 1.0f, relevantSize.y);
                float scaledMinX = minX / relevantSize.x - 0.5f;
                float scaledMaxX = maxX / relevantSize.x - 0.5f;
                float scaledMinY = minY / relevantSize.y - 0.5f;
                float scaledMaxY = maxY / relevantSize.y - 0.5f;
                float newMaxU = minU + (maxU - minU) * (maxX - minX);
                float newMinV = maxV - (maxV - minV) * (maxY - minY);
                this.renderQuad(vertexConsumer, scaledMinX, scaledMaxX, scaledMinY, scaledMaxY, 0.5f, rotation, minU, newMaxU, newMinV, maxV, normal, light);
            }
        }
    }

    private void renderQuad(class_4588 vertexConsumer, float minX, float maxX, float minY, float maxY, float z, AxisAngle4f rotation, float minU, float maxU, float minV, float maxV, Vector3f normal, int light) {
        this.vertexFromVector(vertexConsumer, this.adjustVertex(new Vector3f(minX, minY, z), rotation), minU, maxV, normal, light);
        this.vertexFromVector(vertexConsumer, this.adjustVertex(new Vector3f(maxX, minY, z), rotation), maxU, maxV, normal, light);
        this.vertexFromVector(vertexConsumer, this.adjustVertex(new Vector3f(maxX, maxY, z), rotation), maxU, minV, normal, light);
        this.vertexFromVector(vertexConsumer, this.adjustVertex(new Vector3f(minX, maxY, z), rotation), minU, minV, normal, light);
    }

    private void vertexFromVector(class_4588 vertexConsumer, Vector3f vertexPos, float u, float v, Vector3f normal, int light) {
        this.vertex(vertexConsumer, vertexPos.x, vertexPos.y, vertexPos.z, u, v, normal.x, normal.y, normal.z, light);
    }

    private void vertex(class_4588 vertexConsumer, float x, float y, float z, float u, float v, float normalX, float normalY, float normalZ, int light) {
        vertexConsumer.method_22918(this.positionCache, x, y, z).method_1336(255, 255, 255, 255).method_22913(u, v).method_22922(class_4608.field_21444).method_22916(light).method_23763(this.normalCache, normalX, normalY, normalZ).method_1344();
    }
}

