/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.signed_paintings.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.nettakrim.signed_paintings.SignedPaintingsClient;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;

public class UploadManager {
    private final String clientId;
    private final HashMap<String, String> imgurCache;

    public UploadManager(String clientId) {
        this.clientId = clientId;
        this.imgurCache = new HashMap();
    }

    public void uploadUrlToImgur(String url, Consumer<String> onLoadCallback) {
        if (this.imgurCache.containsKey(url)) {
            if (onLoadCallback != null) {
                onLoadCallback.accept(this.imgurCache.get(url));
            }
            return;
        }
        this.upload(() -> this.uploadUrl(url)).orTimeout(60L, TimeUnit.SECONDS).handleAsync((link, ex) -> {
            if (link == null || ex != null) {
                SignedPaintingsClient.info("Failed to upload " + url, true);
                if (ex != null) {
                    SignedPaintingsClient.info(ex.toString(), true);
                }
            } else {
                SignedPaintingsClient.info("Uploaded " + url + " to " + link, false);
                this.imgurCache.put(url, (String)link);
            }
            if (onLoadCallback != null) {
                onLoadCallback.accept((String)link);
            }
            return null;
        });
    }

    public void uploadFileToImgur(File file, Consumer<String> onLoadCallback) {
        if (this.imgurCache.containsKey(file.getPath())) {
            if (onLoadCallback != null) {
                onLoadCallback.accept(this.imgurCache.get(file.getPath()));
            }
            return;
        }
        this.upload(() -> this.uploadFile(file)).orTimeout(60L, TimeUnit.SECONDS).handleAsync((link, ex) -> {
            if (link == null || ex != null) {
                SignedPaintingsClient.info("Failed to upload " + file.toPath(), true);
                if (ex != null) {
                    SignedPaintingsClient.info(ex.toString(), true);
                }
            } else {
                SignedPaintingsClient.info("Uploaded " + file.toPath() + " to " + link, false);
                this.imgurCache.put(file.getPath(), (String)link);
            }
            if (onLoadCallback != null) {
                onLoadCallback.accept((String)link);
            }
            return null;
        });
    }

    private HttpEntity uploadUrl(String url) {
        try {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>(1);
            params.add(new BasicNameValuePair("image", url));
            return new UrlEncodedFormEntity(params, "UTF-8");
        }
        catch (Exception e) {
            return null;
        }
    }

    private HttpEntity uploadFile(File file) {
        if (file.length() > 10000000L) {
            SignedPaintingsClient.info("uploaded file is too large to upload to imgur: " + file.length(), true);
            return null;
        }
        return EntityBuilder.create().setFile(file).build();
    }

    private CompletableFuture<String> upload(Supplier<HttpEntity> createEntity) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                HttpEntity httpEntity = (HttpEntity)createEntity.get();
                if (httpEntity == null) {
                    return null;
                }
                CloseableHttpClient httpclient = HttpClients.createDefault();
                HttpPost httppost = new HttpPost("https://api.imgur.com/3/image");
                httppost.setEntity(httpEntity);
                httppost.setHeader("Authorization", "Client-ID " + this.clientId);
                HttpResponse response = httpclient.execute((HttpUriRequest)httppost);
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    return this.getLinkFromImgurResponse(entity.getContent());
                }
                return null;
            }
            catch (IOException e) {
                return null;
            }
        });
    }

    public String getLinkFromImgurResponse(InputStream inputStream) throws IOException {
        JsonObject data;
        int length;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        String text = result.toString(StandardCharsets.UTF_8);
        JsonObject jsonResponse = JsonParser.parseString((String)(text = text.replace("\\", ""))).getAsJsonObject();
        if (jsonResponse.has("data") && (data = jsonResponse.getAsJsonObject("data")).has("link")) {
            return data.get("link").getAsString();
        }
        SignedPaintingsClient.info("Failed to read json: " + text, true);
        return null;
    }
}

