/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.actors.seat.SeatBlock;
import com.simibubi.create.content.decoration.palettes.AllPaletteBlocks;
import com.simibubi.create.content.equipment.armor.BacktankItem;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.content.equipment.toolbox.ToolboxBlock;
import com.simibubi.create.content.kinetics.crank.ValveHandleBlock;
import com.simibubi.create.content.kinetics.gearbox.GearboxBlock;
import com.simibubi.create.content.kinetics.gearbox.VerticalGearboxItem;
import com.simibubi.create.content.trains.schedule.ScheduleItem;
import com.simibubi.create.content.trains.station.StationBlock;
import com.simibubi.create.foundation.item.TagDependentIngredientItem;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import io.github.fabricators_of_create.porting_lib.util.EnvExecutor;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceCollection;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class AllCreativeModeTabs {
    public static final TabInfo MAIN_TAB = AllCreativeModeTabs.register("base", () -> FabricItemGroup.builder().method_47321((class_2561)class_2561.method_43471((String)"itemGroup.create.base")).method_47320(() -> AllBlocks.COGWHEEL.asStack()).method_47317((class_1761.class_7914)new RegistrateDisplayItemsGenerator(true)).method_47324());
    public static final TabInfo BUILDING_BLOCKS_TAB = AllCreativeModeTabs.register("palettes", () -> FabricItemGroup.builder().method_47321((class_2561)class_2561.method_43471((String)"itemGroup.create.palettes")).method_47320(() -> AllPaletteBlocks.ORNATE_IRON_WINDOW.asStack()).method_47317((class_1761.class_7914)new RegistrateDisplayItemsGenerator(false)).method_47324());

    private static TabInfo register(String name, Supplier<class_1761> supplier) {
        class_2960 id = Create.asResource(name);
        class_5321 key = class_5321.method_29179((class_5321)class_7924.field_44688, (class_2960)id);
        class_1761 tab = supplier.get();
        class_2378.method_39197((class_2378)class_7923.field_44687, (class_5321)key, (Object)tab);
        return new TabInfo((class_5321<class_1761>)key, tab);
    }

    public static void register() {
    }

    public static class_1761 getBaseTab() {
        return AllCreativeModeTabs.MAIN_TAB.tab;
    }

    public static class_1761 getPalettesTab() {
        return AllCreativeModeTabs.BUILDING_BLOCKS_TAB.tab;
    }

    public record TabInfo(class_5321<class_1761> key, class_1761 tab) {
    }

    public static class RegistrateDisplayItemsGenerator
    implements class_1761.class_7914 {
        private final boolean mainTab;

        public RegistrateDisplayItemsGenerator(boolean mainTab) {
            this.mainTab = mainTab;
        }

        private static Predicate<class_1792> makeExclusionPredicate() {
            ReferenceOpenHashSet exclusions = new ReferenceOpenHashSet();
            List<ItemProviderEntry> simpleExclusions = List.of(AllItems.INCOMPLETE_PRECISION_MECHANISM, AllItems.INCOMPLETE_REINFORCED_SHEET, AllItems.INCOMPLETE_TRACK, AllItems.CHROMATIC_COMPOUND, AllItems.SHADOW_STEEL, AllItems.REFINED_RADIANCE, AllItems.COPPER_BACKTANK_PLACEABLE, AllItems.NETHERITE_BACKTANK_PLACEABLE, AllItems.MINECART_CONTRAPTION, AllItems.FURNACE_MINECART_CONTRAPTION, AllItems.CHEST_MINECART_CONTRAPTION, AllItems.SCHEMATIC, AllBlocks.ANDESITE_ENCASED_SHAFT, AllBlocks.BRASS_ENCASED_SHAFT, AllBlocks.ANDESITE_ENCASED_COGWHEEL, AllBlocks.BRASS_ENCASED_COGWHEEL, AllBlocks.ANDESITE_ENCASED_LARGE_COGWHEEL, AllBlocks.BRASS_ENCASED_LARGE_COGWHEEL, AllBlocks.MYSTERIOUS_CUCKOO_CLOCK, AllBlocks.ELEVATOR_CONTACT, AllBlocks.SHADOW_STEEL_CASING, AllBlocks.REFINED_RADIANCE_CASING);
            List<ItemEntry<TagDependentIngredientItem>> tagDependentExclusions = List.of(AllItems.CRUSHED_OSMIUM, AllItems.CRUSHED_PLATINUM, AllItems.CRUSHED_SILVER, AllItems.CRUSHED_TIN, AllItems.CRUSHED_LEAD, AllItems.CRUSHED_QUICKSILVER, AllItems.CRUSHED_BAUXITE, AllItems.CRUSHED_URANIUM, AllItems.CRUSHED_NICKEL);
            for (ItemProviderEntry itemProviderEntry : simpleExclusions) {
                exclusions.add(itemProviderEntry.method_8389());
            }
            for (ItemEntry itemEntry : tagDependentExclusions) {
                TagDependentIngredientItem item = (TagDependentIngredientItem)((Object)itemEntry.get());
                if (!item.shouldHide()) continue;
                exclusions.add(itemEntry.method_8389());
            }
            return ((Set)exclusions)::contains;
        }

        private static List<ItemOrdering> makeOrderings() {
            ReferenceArrayList orderings = new ReferenceArrayList();
            Map<ItemEntry<ScheduleItem>, BlockEntry<StationBlock>> simpleBeforeOrderings = Map.of(AllItems.EMPTY_BLAZE_BURNER, AllBlocks.BLAZE_BURNER, AllItems.SCHEDULE, AllBlocks.TRACK_STATION);
            Map<ItemEntry<VerticalGearboxItem>, BlockEntry<GearboxBlock>> simpleAfterOrderings = Map.of(AllItems.VERTICAL_GEARBOX, AllBlocks.GEARBOX);
            simpleBeforeOrderings.forEach((arg_0, arg_1) -> RegistrateDisplayItemsGenerator.lambda$makeOrderings$0((List)orderings, arg_0, arg_1));
            simpleAfterOrderings.forEach((arg_0, arg_1) -> RegistrateDisplayItemsGenerator.lambda$makeOrderings$1((List)orderings, arg_0, arg_1));
            return orderings;
        }

        private static Function<class_1792, class_1799> makeStackFunc() {
            Reference2ReferenceOpenHashMap factories = new Reference2ReferenceOpenHashMap();
            Map<ItemEntry<? extends BacktankItem>, Function<class_1792, class_1799>> simpleFactories = Map.of(AllItems.COPPER_BACKTANK, item -> {
                class_1799 stack = new class_1799((class_1935)item);
                stack.method_7948().method_10569("Air", BacktankUtil.maxAirWithoutEnchants());
                return stack;
            }, AllItems.NETHERITE_BACKTANK, item -> {
                class_1799 stack = new class_1799((class_1935)item);
                stack.method_7948().method_10569("Air", BacktankUtil.maxAirWithoutEnchants());
                return stack;
            });
            simpleFactories.forEach((arg_0, arg_1) -> RegistrateDisplayItemsGenerator.lambda$makeStackFunc$4((Map)factories, arg_0, arg_1));
            return arg_0 -> RegistrateDisplayItemsGenerator.lambda$makeStackFunc$5((Map)factories, arg_0);
        }

        private static Function<class_1792, class_1761.class_7705> makeVisibilityFunc() {
            Object block;
            Reference2ObjectOpenHashMap visibilities = new Reference2ObjectOpenHashMap();
            Map<ItemEntry<class_1792>, class_1761.class_7705> simpleVisibilities = Map.of(AllItems.BLAZE_CAKE_BASE, class_1761.class_7705.field_40193);
            simpleVisibilities.forEach((arg_0, arg_1) -> RegistrateDisplayItemsGenerator.lambda$makeVisibilityFunc$6((Map)visibilities, arg_0, arg_1));
            for (BlockEntry<ValveHandleBlock> blockEntry : AllBlocks.DYED_VALVE_HANDLES) {
                visibilities.put(blockEntry.method_8389(), class_1761.class_7705.field_40193);
            }
            for (BlockEntry blockEntry : AllBlocks.SEATS) {
                block = (SeatBlock)blockEntry.get();
                if (((SeatBlock)block).getColor() == class_1767.field_7964) continue;
                visibilities.put(blockEntry.method_8389(), class_1761.class_7705.field_40193);
            }
            for (BlockEntry blockEntry : AllBlocks.TOOLBOXES) {
                block = (ToolboxBlock)blockEntry.get();
                if (((ToolboxBlock)block).getColor() == class_1767.field_7957) continue;
                visibilities.put(blockEntry.method_8389(), class_1761.class_7705.field_40193);
            }
            return arg_0 -> RegistrateDisplayItemsGenerator.lambda$makeVisibilityFunc$7((Map)visibilities, arg_0);
        }

        public void accept(class_1761.class_8128 pParameters, class_1761.class_7704 output) {
            Predicate<class_1792> exclusionPredicate = RegistrateDisplayItemsGenerator.makeExclusionPredicate();
            List<ItemOrdering> orderings = RegistrateDisplayItemsGenerator.makeOrderings();
            Function<class_1792, class_1799> stackFunc = RegistrateDisplayItemsGenerator.makeStackFunc();
            Function<class_1792, class_1761.class_7705> visibilityFunc = RegistrateDisplayItemsGenerator.makeVisibilityFunc();
            class_5321<class_1761> tab = this.mainTab ? AllCreativeModeTabs.MAIN_TAB.key : AllCreativeModeTabs.BUILDING_BLOCKS_TAB.key;
            LinkedList<class_1792> items = new LinkedList<class_1792>();
            Predicate is3d = (Predicate)EnvExecutor.unsafeRunForDist(() -> () -> item -> class_310.method_1551().method_1480().method_4019(new class_1799((class_1935)item), null, null, 0).method_4712(), () -> () -> item -> false);
            items.addAll(this.collectItems(tab, is3d, true, exclusionPredicate));
            items.addAll(this.collectBlocks(tab, exclusionPredicate));
            items.addAll(this.collectItems(tab, is3d, false, exclusionPredicate));
            RegistrateDisplayItemsGenerator.applyOrderings(items, orderings);
            RegistrateDisplayItemsGenerator.outputAll(output, items, stackFunc, visibilityFunc);
        }

        private List<class_1792> collectBlocks(class_5321<class_1761> tab, Predicate<class_1792> exclusionPredicate) {
            ReferenceArrayList items = new ReferenceArrayList();
            for (RegistryEntry entry : Create.REGISTRATE.getAll(class_7924.field_41254)) {
                class_1792 item;
                if (!Create.REGISTRATE.isInCreativeTab(entry, tab) || (item = ((class_2248)entry.get()).method_8389()) == class_1802.field_8162 || exclusionPredicate.test(item)) continue;
                items.add(item);
            }
            items = new ReferenceArrayList((ReferenceCollection)new ReferenceLinkedOpenHashSet((Collection)items));
            return items;
        }

        private List<class_1792> collectItems(class_5321<class_1761> tab, Predicate<class_1792> is3d, boolean special, Predicate<class_1792> exclusionPredicate) {
            ReferenceArrayList items = new ReferenceArrayList();
            if (!this.mainTab) {
                return items;
            }
            for (RegistryEntry entry : Create.REGISTRATE.getAll(class_7924.field_41197)) {
                class_1792 item;
                if (!Create.REGISTRATE.isInCreativeTab(entry, tab) || (item = (class_1792)entry.get()) instanceof class_1747 || is3d.test(item) != special || exclusionPredicate.test(item)) continue;
                items.add(item);
            }
            return items;
        }

        private static void applyOrderings(List<class_1792> items, List<ItemOrdering> orderings) {
            for (ItemOrdering ordering : orderings) {
                int anchorIndex = items.indexOf(ordering.anchor());
                if (anchorIndex == -1) continue;
                class_1792 item = ordering.item();
                int itemIndex = items.indexOf(item);
                if (itemIndex != -1) {
                    items.remove(itemIndex);
                    if (itemIndex < anchorIndex) {
                        --anchorIndex;
                    }
                }
                if (ordering.type() == ItemOrdering.Type.AFTER) {
                    items.add(anchorIndex + 1, item);
                    continue;
                }
                items.add(anchorIndex, item);
            }
        }

        private static void outputAll(class_1761.class_7704 output, List<class_1792> items, Function<class_1792, class_1799> stackFunc, Function<class_1792, class_1761.class_7705> visibilityFunc) {
            for (class_1792 item : items) {
                output.method_45417(stackFunc.apply(item), visibilityFunc.apply(item));
            }
        }

        private static /* synthetic */ class_1761.class_7705 lambda$makeVisibilityFunc$7(Map visibilities, class_1792 item) {
            class_1761.class_7705 visibility = (class_1761.class_7705)visibilities.get(item);
            if (visibility != null) {
                return visibility;
            }
            return class_1761.class_7705.field_40191;
        }

        private static /* synthetic */ void lambda$makeVisibilityFunc$6(Map visibilities, ItemProviderEntry entry, class_1761.class_7705 factory) {
            visibilities.put(entry.method_8389(), factory);
        }

        private static /* synthetic */ class_1799 lambda$makeStackFunc$5(Map factories, class_1792 item) {
            Function factory = (Function)factories.get(item);
            if (factory != null) {
                return (class_1799)factory.apply(item);
            }
            return new class_1799((class_1935)item);
        }

        private static /* synthetic */ void lambda$makeStackFunc$4(Map factories, ItemProviderEntry entry, Function factory) {
            factories.put(entry.method_8389(), factory);
        }

        private static /* synthetic */ void lambda$makeOrderings$1(List orderings, ItemProviderEntry entry, ItemProviderEntry otherEntry) {
            orderings.add(ItemOrdering.after(entry.method_8389(), otherEntry.method_8389()));
        }

        private static /* synthetic */ void lambda$makeOrderings$0(List orderings, ItemProviderEntry entry, ItemProviderEntry otherEntry) {
            orderings.add(ItemOrdering.before(entry.method_8389(), otherEntry.method_8389()));
        }

        private record ItemOrdering(class_1792 item, class_1792 anchor, Type type) {
            public static ItemOrdering before(class_1792 item, class_1792 anchor) {
                return new ItemOrdering(item, anchor, Type.BEFORE);
            }

            public static ItemOrdering after(class_1792 item, class_1792 anchor) {
                return new ItemOrdering(item, anchor, Type.AFTER);
            }

            public static enum Type {
                BEFORE,
                AFTER;

            }
        }
    }
}

