/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.Create;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2405;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_6880;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7923;

public class AllSoundEvents {
    public static final Map<class_2960, SoundEntry> ALL = new HashMap<class_2960, SoundEntry>();
    public static final SoundEntry SCHEMATICANNON_LAUNCH_BLOCK = AllSoundEvents.create("schematicannon_launch_block").subtitle("Schematicannon fires").playExisting(class_3417.field_15152, 0.1f, 1.1f).category(class_3419.field_15245).build();
    public static final SoundEntry SCHEMATICANNON_FINISH = AllSoundEvents.create("schematicannon_finish").subtitle("Schematicannon dings").playExisting((class_6880<class_3414>)class_3417.field_14793, 1.0f, 0.7f).category(class_3419.field_15245).build();
    public static final SoundEntry DEPOT_SLIDE = AllSoundEvents.create("depot_slide").subtitle("Item slides").playExisting(class_3417.field_15074, 0.125f, 1.5f).category(class_3419.field_15245).build();
    public static final SoundEntry DEPOT_PLOP = AllSoundEvents.create("depot_plop").subtitle("Item lands").playExisting(class_3417.field_14667, 0.25f, 1.25f).category(class_3419.field_15245).build();
    public static final SoundEntry FUNNEL_FLAP = AllSoundEvents.create("funnel_flap").subtitle("Funnel flaps").playExisting(class_3417.field_15038, 0.125f, 1.5f).playExisting(class_3417.field_14983, 0.0425f, 0.75f).category(class_3419.field_15245).build();
    public static final SoundEntry SLIME_ADDED = AllSoundEvents.create("slime_added").subtitle("Slime squishes").playExisting(class_3417.field_14788).category(class_3419.field_15245).build();
    public static final SoundEntry MECHANICAL_PRESS_ACTIVATION = AllSoundEvents.create("mechanical_press_activation").subtitle("Mechanical Press clangs").playExisting(class_3417.field_14833, 0.125f, 1.0f).playExisting(class_3417.field_15075, 0.5f, 1.0f).category(class_3419.field_15245).build();
    public static final SoundEntry MECHANICAL_PRESS_ACTIVATION_ON_BELT = AllSoundEvents.create("mechanical_press_activation_belt").subtitle("Mechanical Press bonks").playExisting(class_3417.field_14628, 0.75f, 1.0f).playExisting(class_3417.field_15075, 0.15f, 0.75f).category(class_3419.field_15245).build();
    public static final SoundEntry MIXING = AllSoundEvents.create("mixing").subtitle("Mixing noises").playExisting(class_3417.field_24066, 0.125f, 0.5f).playExisting(class_3417.field_21924, 0.125f, 0.5f).category(class_3419.field_15245).build();
    public static final SoundEntry CRANKING = AllSoundEvents.create("cranking").subtitle("Hand Crank turns").playExisting(class_3417.field_14718, 0.075f, 0.5f).playExisting(class_3417.field_15105, 0.025f, 0.5f).category(class_3419.field_15245).build();
    public static final SoundEntry WORLDSHAPER_PLACE = AllSoundEvents.create("worldshaper_place").subtitle("Worldshaper zaps").playExisting((class_6880<class_3414>)class_3417.field_15047).category(class_3419.field_15248).build();
    public static final SoundEntry SCROLL_VALUE = AllSoundEvents.create("scroll_value").subtitle("Scroll-input clicks").playExisting((class_6880<class_3414>)class_3417.field_15204, 0.124f, 1.0f).category(class_3419.field_15248).build();
    public static final SoundEntry CONFIRM = AllSoundEvents.create("confirm").subtitle("Affirmative ding").playExisting((class_6880<class_3414>)class_3417.field_14793, 0.5f, 0.8f).category(class_3419.field_15248).build();
    public static final SoundEntry DENY = AllSoundEvents.create("deny").subtitle("Declining boop").playExisting((class_6880<class_3414>)class_3417.field_14624, 1.0f, 0.5f).category(class_3419.field_15248).build();
    public static final SoundEntry COGS = AllSoundEvents.create("cogs").subtitle("Cogwheels rumble").category(class_3419.field_15245).build();
    public static final SoundEntry FWOOMP = AllSoundEvents.create("fwoomp").subtitle("Potato Launcher fwoomps").category(class_3419.field_15248).build();
    public static final SoundEntry POTATO_HIT = AllSoundEvents.create("potato_hit").subtitle("Vegetable impacts").playExisting(class_3417.field_14585, 0.75f, 0.75f).playExisting(class_3417.field_21909, 0.75f, 1.25f).category(class_3419.field_15248).build();
    public static final SoundEntry CONTRAPTION_ASSEMBLE = AllSoundEvents.create("contraption_assemble").subtitle("Contraption moves").playExisting(class_3417.field_14932, 0.5f, 0.5f).playExisting(class_3417.field_14982, 0.045f, 0.74f).category(class_3419.field_15245).build();
    public static final SoundEntry CONTRAPTION_DISASSEMBLE = AllSoundEvents.create("contraption_disassemble").subtitle("Contraption stops").playExisting(class_3417.field_15131, 0.35f, 0.75f).category(class_3419.field_15245).build();
    public static final SoundEntry WRENCH_ROTATE = AllSoundEvents.create("wrench_rotate").subtitle("Wrench used").playExisting(class_3417.field_15080, 0.25f, 1.25f).category(class_3419.field_15245).build();
    public static final SoundEntry WRENCH_REMOVE = AllSoundEvents.create("wrench_remove").subtitle("Component breaks").playExisting(class_3417.field_15197, 0.25f, 0.75f).playExisting(class_3417.field_21922, 0.25f, 0.75f).category(class_3419.field_15245).build();
    public static final SoundEntry CRAFTER_CLICK = AllSoundEvents.create("crafter_click").subtitle("Crafter clicks").playExisting(class_3417.field_21922, 0.25f, 1.0f).playExisting(class_3417.field_14932, 0.125f, 1.0f).category(class_3419.field_15245).build();
    public static final SoundEntry CRAFTER_CRAFT = AllSoundEvents.create("crafter_craft").subtitle("Crafter crafts").playExisting(class_3417.field_15075, 0.125f, 0.75f).category(class_3419.field_15245).build();
    public static final SoundEntry COPPER_ARMOR_EQUIP = AllSoundEvents.create("copper_armor_equip").subtitle("Diving equipment clinks").playExisting(class_3417.field_14761, 1.0f, 1.0f).category(class_3419.field_15248).build();
    public static final SoundEntry SANDING_SHORT = AllSoundEvents.create("sanding_short").subtitle("Sanding noises").addVariant("sanding_short_1").category(class_3419.field_15245).build();
    public static final SoundEntry SANDING_LONG = AllSoundEvents.create("sanding_long").subtitle("Sanding noises").category(class_3419.field_15245).build();
    public static final SoundEntry CONTROLLER_CLICK = AllSoundEvents.create("controller_click").subtitle("Controller clicks").playExisting(class_3417.field_14667, 0.35f, 1.0f).category(class_3419.field_15245).build();
    public static final SoundEntry CONTROLLER_PUT = AllSoundEvents.create("controller_put").subtitle("Controller thumps").playExisting(class_3417.field_17482, 1.0f, 1.0f).category(class_3419.field_15245).build();
    public static final SoundEntry CONTROLLER_TAKE = AllSoundEvents.create("controller_take").subtitle("Lectern empties").playExisting(class_3417.field_14770, 1.0f, 1.0f).category(class_3419.field_15245).build();
    public static final SoundEntry SAW_ACTIVATE_WOOD = AllSoundEvents.create("saw_activate_wood").subtitle("Mechanical Saw activates").playExisting(class_3417.field_14886, 0.75f, 1.5f).category(class_3419.field_15245).build();
    public static final SoundEntry SAW_ACTIVATE_STONE = AllSoundEvents.create("saw_activate_stone").subtitle("Mechanical Saw activates").playExisting(class_3417.field_17710, 0.125f, 1.25f).category(class_3419.field_15245).build();
    public static final SoundEntry BLAZE_MUNCH = AllSoundEvents.create("blaze_munch").subtitle("Blaze Burner munches").playExisting(class_3417.field_20614, 0.5f, 1.0f).category(class_3419.field_15245).build();
    public static final SoundEntry CRUSHING_1 = AllSoundEvents.create("crushing_1").subtitle("Crushing noises").playExisting(class_3417.field_21927).category(class_3419.field_15245).build();
    public static final SoundEntry CRUSHING_2 = AllSoundEvents.create("crushing_2").noSubtitle().playExisting(class_3417.field_14609).category(class_3419.field_15245).build();
    public static final SoundEntry CRUSHING_3 = AllSoundEvents.create("crushing_3").noSubtitle().playExisting(class_3417.field_21919).category(class_3419.field_15245).build();
    public static final SoundEntry PECULIAR_BELL_USE = AllSoundEvents.create("peculiar_bell_use").subtitle("Peculiar Bell tolls").playExisting(class_3417.field_17265).category(class_3419.field_15245).build();
    public static final SoundEntry WHISTLE_HIGH = AllSoundEvents.create("whistle_high").subtitle("High whistling").category(class_3419.field_15247).attenuationDistance(64).build();
    public static final SoundEntry WHISTLE_MEDIUM = AllSoundEvents.create("whistle").subtitle("Whistling").category(class_3419.field_15247).attenuationDistance(64).build();
    public static final SoundEntry WHISTLE_LOW = AllSoundEvents.create("whistle_low").subtitle("Low whistling").category(class_3419.field_15247).attenuationDistance(64).build();
    public static final SoundEntry STEAM = AllSoundEvents.create("steam").subtitle("Steam noises").category(class_3419.field_15254).attenuationDistance(32).build();
    public static final SoundEntry TRAIN = AllSoundEvents.create("train").subtitle("Bogey wheels rumble").category(class_3419.field_15254).attenuationDistance(128).build();
    public static final SoundEntry TRAIN2 = AllSoundEvents.create("train2").noSubtitle().category(class_3419.field_15254).attenuationDistance(128).build();
    public static final SoundEntry TRAIN3 = AllSoundEvents.create("train3").subtitle("Bogey wheels rumble muffled").category(class_3419.field_15254).attenuationDistance(16).build();
    public static final SoundEntry WHISTLE_TRAIN = AllSoundEvents.create("whistle_train").subtitle("Whistling").category(class_3419.field_15247).build();
    public static final SoundEntry WHISTLE_TRAIN_LOW = AllSoundEvents.create("whistle_train_low").subtitle("Low whistling").category(class_3419.field_15247).build();
    public static final SoundEntry WHISTLE_TRAIN_MANUAL = AllSoundEvents.create("whistle_train_manual").subtitle("Train honks").category(class_3419.field_15254).attenuationDistance(64).build();
    public static final SoundEntry WHISTLE_TRAIN_MANUAL_LOW = AllSoundEvents.create("whistle_train_manual_low").subtitle("Train honks").category(class_3419.field_15254).attenuationDistance(64).build();
    public static final SoundEntry WHISTLE_TRAIN_MANUAL_END = AllSoundEvents.create("whistle_train_manual_end").noSubtitle().category(class_3419.field_15254).attenuationDistance(64).build();
    public static final SoundEntry WHISTLE_TRAIN_MANUAL_LOW_END = AllSoundEvents.create("whistle_train_manual_low_end").noSubtitle().category(class_3419.field_15254).attenuationDistance(64).build();
    public static final SoundEntry WHISTLE_CHIFF = AllSoundEvents.create("chiff").noSubtitle().category(class_3419.field_15247).build();
    public static final SoundEntry HAUNTED_BELL_CONVERT = AllSoundEvents.create("haunted_bell_convert").subtitle("Haunted Bell awakens").category(class_3419.field_15245).build();
    public static final SoundEntry HAUNTED_BELL_USE = AllSoundEvents.create("haunted_bell_use").subtitle("Haunted Bell tolls").category(class_3419.field_15245).build();

    private static SoundEntryBuilder create(String name) {
        return AllSoundEvents.create(Create.asResource(name));
    }

    public static SoundEntryBuilder create(class_2960 id) {
        return new SoundEntryBuilder(id);
    }

    public static void prepare() {
        for (SoundEntry entry : ALL.values()) {
            entry.prepare();
        }
    }

    public static void register() {
        for (SoundEntry entry : ALL.values()) {
            entry.register();
        }
    }

    public static JsonObject provideLangEntries() {
        JsonObject object = new JsonObject();
        for (SoundEntry entry : ALL.values()) {
            if (!entry.hasSubtitle()) continue;
            object.addProperty(entry.getSubtitleKey(), entry.getSubtitle());
        }
        return object;
    }

    public static class_2405 provider(FabricDataOutput output) {
        return new SoundEntryProvider((class_7784)output);
    }

    public static void playItemPickup(class_1657 player) {
        player.method_37908().method_8396(null, player.method_24515(), class_3417.field_15197, class_3419.field_15248, 0.2f, 1.0f + Create.RANDOM.nextFloat());
    }

    public static class SoundEntryBuilder {
        protected class_2960 id;
        protected String subtitle = "unregistered";
        protected class_3419 category = class_3419.field_15245;
        protected List<ConfiguredSoundEvent> wrappedEvents = new ArrayList<ConfiguredSoundEvent>();
        protected List<class_2960> variants = new ArrayList<class_2960>();
        protected int attenuationDistance;

        public SoundEntryBuilder(class_2960 id) {
            this.id = id;
        }

        public SoundEntryBuilder subtitle(String subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public SoundEntryBuilder attenuationDistance(int distance) {
            this.attenuationDistance = distance;
            return this;
        }

        public SoundEntryBuilder noSubtitle() {
            this.subtitle = null;
            return this;
        }

        public SoundEntryBuilder category(class_3419 category) {
            this.category = category;
            return this;
        }

        public SoundEntryBuilder addVariant(String name) {
            return this.addVariant(Create.asResource(name));
        }

        public SoundEntryBuilder addVariant(class_2960 id) {
            this.variants.add(id);
            return this;
        }

        public SoundEntryBuilder playExisting(Supplier<class_3414> event, float volume, float pitch) {
            this.wrappedEvents.add(new ConfiguredSoundEvent(event, volume, pitch));
            return this;
        }

        public SoundEntryBuilder playExisting(class_6880<class_3414> event, float volume, float pitch) {
            return this.playExisting(() -> event.comp_349(), volume, pitch);
        }

        public SoundEntryBuilder playExisting(class_3414 event, float volume, float pitch) {
            return this.playExisting(() -> event, volume, pitch);
        }

        public SoundEntryBuilder playExisting(class_3414 event) {
            return this.playExisting(event, 1.0f, 1.0f);
        }

        public SoundEntryBuilder playExisting(class_6880<class_3414> event) {
            return this.playExisting(() -> event.comp_349(), 1.0f, 1.0f);
        }

        public SoundEntry build() {
            SoundEntry entry = this.wrappedEvents.isEmpty() ? new CustomSoundEntry(this.id, this.variants, this.subtitle, this.category, this.attenuationDistance) : new WrappedSoundEntry(this.id, this.subtitle, this.wrappedEvents, this.category, this.attenuationDistance);
            ALL.put(entry.getId(), entry);
            return entry;
        }
    }

    public static abstract class SoundEntry {
        protected class_2960 id;
        protected String subtitle;
        protected class_3419 category;
        protected int attenuationDistance;

        public SoundEntry(class_2960 id, String subtitle, class_3419 category, int attenuationDistance) {
            this.id = id;
            this.subtitle = subtitle;
            this.category = category;
            this.attenuationDistance = attenuationDistance;
        }

        public abstract void prepare();

        public abstract void register();

        public abstract void write(JsonObject var1);

        public abstract class_3414 getMainEvent();

        public String getSubtitleKey() {
            return this.id.method_12836() + ".subtitle." + this.id.method_12832();
        }

        public class_2960 getId() {
            return this.id;
        }

        public boolean hasSubtitle() {
            return this.subtitle != null;
        }

        public String getSubtitle() {
            return this.subtitle;
        }

        public void playOnServer(class_1937 world, class_2382 pos) {
            this.playOnServer(world, pos, 1.0f, 1.0f);
        }

        public void playOnServer(class_1937 world, class_2382 pos, float volume, float pitch) {
            this.play(world, null, pos, volume, pitch);
        }

        public void play(class_1937 world, class_1657 entity, class_2382 pos) {
            this.play(world, entity, pos, 1.0f, 1.0f);
        }

        public void playFrom(class_1297 entity) {
            this.playFrom(entity, 1.0f, 1.0f);
        }

        public void playFrom(class_1297 entity, float volume, float pitch) {
            if (!entity.method_5701()) {
                this.play(entity.method_37908(), null, (class_2382)entity.method_24515(), volume, pitch);
            }
        }

        public void play(class_1937 world, class_1657 entity, class_2382 pos, float volume, float pitch) {
            this.play(world, entity, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, volume, pitch);
        }

        public void play(class_1937 world, class_1657 entity, class_243 pos, float volume, float pitch) {
            this.play(world, entity, pos.method_10216(), pos.method_10214(), pos.method_10215(), volume, pitch);
        }

        public abstract void play(class_1937 var1, class_1657 var2, double var3, double var5, double var7, float var9, float var10);

        public void playAt(class_1937 world, class_2382 pos, float volume, float pitch, boolean fade) {
            this.playAt(world, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, volume, pitch, fade);
        }

        public void playAt(class_1937 world, class_243 pos, float volume, float pitch, boolean fade) {
            this.playAt(world, pos.method_10216(), pos.method_10214(), pos.method_10215(), volume, pitch, fade);
        }

        public abstract void playAt(class_1937 var1, double var2, double var4, double var6, float var8, float var9, boolean var10);
    }

    private static class SoundEntryProvider
    implements class_2405 {
        private class_7784 output;

        public SoundEntryProvider(class_7784 output) {
            this.output = output;
        }

        public CompletableFuture<?> method_10319(class_7403 cache) {
            return this.generate(this.output.method_45971(), cache);
        }

        public String method_10321() {
            return "Create's Custom Sounds";
        }

        public CompletableFuture<?> generate(Path path, class_7403 cache) {
            path = path.resolve("assets/create");
            JsonObject json = new JsonObject();
            ALL.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> ((SoundEntry)entry.getValue()).write(json));
            return class_2405.method_10320((class_7403)cache, (JsonElement)json, (Path)path.resolve("sounds.json"));
        }
    }

    private static class CustomSoundEntry
    extends SoundEntry {
        protected List<class_2960> variants;
        protected class_3414 event;

        public CustomSoundEntry(class_2960 id, List<class_2960> variants, String subtitle, class_3419 category, int attenuationDistance) {
            super(id, subtitle, category, attenuationDistance);
            this.variants = variants;
        }

        @Override
        public void prepare() {
            this.event = class_3414.method_47908((class_2960)this.id);
        }

        @Override
        public void register() {
            class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)this.event.method_14833(), (Object)this.event);
        }

        @Override
        public class_3414 getMainEvent() {
            return this.event;
        }

        @Override
        public void write(JsonObject json) {
            JsonObject entry = new JsonObject();
            JsonArray list = new JsonArray();
            JsonObject s = new JsonObject();
            s.addProperty("name", this.id.toString());
            s.addProperty("type", "file");
            if (this.attenuationDistance != 0) {
                s.addProperty("attenuation_distance", (Number)this.attenuationDistance);
            }
            list.add((JsonElement)s);
            for (class_2960 variant : this.variants) {
                s = new JsonObject();
                s.addProperty("name", variant.toString());
                s.addProperty("type", "file");
                if (this.attenuationDistance != 0) {
                    s.addProperty("attenuation_distance", (Number)this.attenuationDistance);
                }
                list.add((JsonElement)s);
            }
            entry.add("sounds", (JsonElement)list);
            if (this.hasSubtitle()) {
                entry.addProperty("subtitle", this.getSubtitleKey());
            }
            json.add(this.id.method_12832(), (JsonElement)entry);
        }

        @Override
        public void play(class_1937 world, class_1657 entity, double x, double y, double z, float volume, float pitch) {
            world.method_43128(entity, x, y, z, this.event, this.category, volume, pitch);
        }

        @Override
        public void playAt(class_1937 world, double x, double y, double z, float volume, float pitch, boolean fade) {
            world.method_8486(x, y, z, this.event, this.category, volume, pitch, fade);
        }
    }

    private static class WrappedSoundEntry
    extends SoundEntry {
        private List<ConfiguredSoundEvent> wrappedEvents;
        private List<CompiledSoundEvent> compiledEvents;

        public WrappedSoundEntry(class_2960 id, String subtitle, List<ConfiguredSoundEvent> wrappedEvents, class_3419 category, int attenuationDistance) {
            super(id, subtitle, category, attenuationDistance);
            this.wrappedEvents = wrappedEvents;
            this.compiledEvents = new ArrayList<CompiledSoundEvent>();
        }

        @Override
        public void prepare() {
            for (int i = 0; i < this.wrappedEvents.size(); ++i) {
                ConfiguredSoundEvent wrapped = this.wrappedEvents.get(i);
                class_2960 location = this.getIdOf(i);
                class_3414 event = class_3414.method_47908((class_2960)location);
                this.compiledEvents.add(new CompiledSoundEvent(event, wrapped.volume(), wrapped.pitch()));
            }
        }

        @Override
        public void register() {
            for (CompiledSoundEvent event : this.compiledEvents) {
                class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)event.event.method_14833(), (Object)event.event);
            }
        }

        @Override
        public class_3414 getMainEvent() {
            return this.compiledEvents.get(0).event();
        }

        protected class_2960 getIdOf(int i) {
            return new class_2960(this.id.method_12836(), (String)(i == 0 ? this.id.method_12832() : this.id.method_12832() + "_compounded_" + i));
        }

        @Override
        public void write(JsonObject json) {
            for (int i = 0; i < this.wrappedEvents.size(); ++i) {
                ConfiguredSoundEvent event = this.wrappedEvents.get(i);
                JsonObject entry = new JsonObject();
                JsonArray list = new JsonArray();
                JsonObject s = new JsonObject();
                s.addProperty("name", event.event().get().method_14833().toString());
                s.addProperty("type", "event");
                if (this.attenuationDistance != 0) {
                    s.addProperty("attenuation_distance", (Number)this.attenuationDistance);
                }
                list.add((JsonElement)s);
                entry.add("sounds", (JsonElement)list);
                if (i == 0 && this.hasSubtitle()) {
                    entry.addProperty("subtitle", this.getSubtitleKey());
                }
                json.add(this.getIdOf(i).method_12832(), (JsonElement)entry);
            }
        }

        @Override
        public void play(class_1937 world, class_1657 entity, double x, double y, double z, float volume, float pitch) {
            for (CompiledSoundEvent event : this.compiledEvents) {
                world.method_43128(entity, x, y, z, event.event(), this.category, event.volume() * volume, event.pitch() * pitch);
            }
        }

        @Override
        public void playAt(class_1937 world, double x, double y, double z, float volume, float pitch, boolean fade) {
            for (CompiledSoundEvent event : this.compiledEvents) {
                world.method_8486(x, y, z, event.event(), this.category, event.volume() * volume, event.pitch() * pitch, fade);
            }
        }

        private record CompiledSoundEvent(class_3414 event, float volume, float pitch) {
        }
    }

    public record ConfiguredSoundEvent(Supplier<class_3414> event, float volume, float pitch) {
    }
}

