/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.belt.behaviour;

import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.logistics.funnel.BeltFunnelBlock;
import com.simibubi.create.content.logistics.funnel.FunnelBlock;
import com.simibubi.create.content.logistics.funnel.FunnelBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.util.StorageProvider;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class DirectBeltInputBehaviour
extends BlockEntityBehaviour {
    public static final BehaviourType<DirectBeltInputBehaviour> TYPE = new BehaviourType();
    private InsertionCallback tryInsert = this::defaultInsertionCallback;
    private AvailabilityPredicate canInsert = d -> true;
    private Supplier<Boolean> supportsBeltFunnels = () -> false;
    private StorageProvider<ItemVariant> targetStorageProvider;

    public DirectBeltInputBehaviour(SmartBlockEntity be) {
        super(be);
    }

    public DirectBeltInputBehaviour allowingBeltFunnelsWhen(Supplier<Boolean> pred) {
        this.supportsBeltFunnels = pred;
        return this;
    }

    public DirectBeltInputBehaviour allowingBeltFunnels() {
        this.supportsBeltFunnels = () -> true;
        return this;
    }

    public DirectBeltInputBehaviour onlyInsertWhen(AvailabilityPredicate pred) {
        this.canInsert = pred;
        return this;
    }

    public DirectBeltInputBehaviour setInsertionHandler(InsertionCallback callback) {
        this.tryInsert = callback;
        return this;
    }

    private class_1799 defaultInsertionCallback(TransportedItemStack inserted, class_2350 side, boolean simulate) {
        Storage<ItemVariant> storage = this.getTargetStorage(side);
        if (storage == null) {
            return inserted.stack;
        }
        try (Transaction t = TransferUtil.getTransaction();){
            long trying = inserted.stack.method_7947();
            long successful = storage.insert((Object)ItemVariant.of((class_1799)inserted.stack), (long)inserted.stack.method_7947(), (TransactionContext)t);
            if (trying == successful) {
                if (!simulate) {
                    t.commit();
                }
                class_1799 class_17992 = class_1799.field_8037;
                return class_17992;
            }
            class_1799 stack = inserted.stack.method_7972();
            stack.method_7939((int)(trying - successful));
            if (!simulate) {
                t.commit();
            }
            class_1799 class_17993 = stack;
            return class_17993;
        }
    }

    public Storage<ItemVariant> getTargetStorage(class_2350 side) {
        if (this.getWorld() == null) {
            return null;
        }
        if (this.targetStorageProvider == null) {
            this.targetStorageProvider = StorageProvider.createForItems((class_1937)this.getWorld(), (class_2338)this.getPos());
        }
        return this.targetStorageProvider.get(side);
    }

    public boolean canInsertFromSide(class_2350 side) {
        return this.canInsert.test(side);
    }

    public class_1799 handleInsertion(class_1799 stack, class_2350 side, boolean simulate) {
        return this.handleInsertion(new TransportedItemStack(stack), side, simulate);
    }

    public class_1799 handleInsertion(TransportedItemStack stack, class_2350 side, boolean simulate) {
        return this.tryInsert.apply(stack, side, simulate);
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    @Nullable
    public class_1799 tryExportingToBeltFunnel(class_1799 stack, @Nullable class_2350 side, boolean simulate) {
        class_2338 funnelPos = this.blockEntity.method_11016().method_10084();
        class_1937 world = this.getWorld();
        class_2680 funnelState = world.method_8320(funnelPos);
        if (!(funnelState.method_26204() instanceof BeltFunnelBlock)) {
            return null;
        }
        if (funnelState.method_11654(BeltFunnelBlock.SHAPE) != BeltFunnelBlock.Shape.PULLING) {
            return null;
        }
        if (side != null && FunnelBlock.getFunnelFacing(funnelState) != side) {
            return null;
        }
        class_2586 be = world.method_8321(funnelPos);
        if (!(be instanceof FunnelBlockEntity)) {
            return null;
        }
        if (((Boolean)funnelState.method_11654((class_2769)BeltFunnelBlock.POWERED)).booleanValue()) {
            return stack;
        }
        class_1799 insert = FunnelBlock.tryInsert(world, funnelPos, stack, simulate);
        if (insert.method_7947() != stack.method_7947() && !simulate) {
            ((FunnelBlockEntity)be).flap(true);
        }
        return insert;
    }

    public boolean canSupportBeltFunnels() {
        return this.supportsBeltFunnels.get();
    }

    @FunctionalInterface
    public static interface InsertionCallback {
        public class_1799 apply(TransportedItemStack var1, class_2350 var2, boolean var3);
    }

    @FunctionalInterface
    public static interface AvailabilityPredicate {
        public boolean test(class_2350 var1);
    }
}

