/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.item;

import earth.terrarium.botarium.common.energy.util.EnergyHooks;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ItemUsableResource {
    None{

        @Override
        public boolean test(class_1799 item) {
            return false;
        }

        @Override
        public long extract(ItemStackHolder item, long amount, boolean simulate) {
            return 0L;
        }
    }
    ,
    Energy{

        @Override
        public boolean test(class_1799 item) {
            return EnergyHooks.isEnergyItem((class_1799)item);
        }

        @Override
        public long extract(ItemStackHolder item, long amount, boolean simulate) {
            return EnergyHooks.safeGetItemEnergyManager((class_1799)item.getStack()).map(e -> e.extract(item, amount, simulate)).orElse(0L);
        }
    }
    ,
    Durability{

        @Override
        public boolean test(class_1799 item) {
            return true;
        }

        @Override
        public long extract(ItemStackHolder item, long amount, boolean simulate) {
            int maxDamage;
            int damaging;
            int prevDamage;
            int nextDamage;
            class_1799 stack = item.getStack();
            if (stack.method_7963() && (nextDamage = (prevDamage = stack.method_7919()) + (damaging = Math.min((maxDamage = stack.method_7936()) - prevDamage, (int)amount))) < maxDamage) {
                if (!simulate) {
                    stack.method_7974(nextDamage);
                    item.setStack(stack);
                }
                return damaging;
            }
            return amount;
        }
    };


    @Nullable
    public static ItemUsableResource first(class_1799 item) {
        for (ItemUsableResource resource : ItemUsableResource.values()) {
            if (!resource.test(item)) continue;
            return resource;
        }
        return null;
    }

    public abstract boolean test(class_1799 var1);

    public abstract long extract(ItemStackHolder var1, long var2, boolean var4);
}

