/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.image.converter.mapping;

import com.dfsek.terra.addons.image.converter.mapping.ColorMapping;
import com.dfsek.terra.api.registry.Registry;
import com.dfsek.terra.api.world.biome.Biome;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class BiomeDefinedColorMapping<T>
implements ColorMapping<T> {
    Registry<Biome> biomeRegistry;
    Function<Biome, T> converter;

    public BiomeDefinedColorMapping(Registry<Biome> biomeRegistry, Function<Biome, T> converter) {
        this.biomeRegistry = biomeRegistry;
        this.converter = converter;
    }

    @Override
    public Map<Integer, T> get() {
        Map<Biome, Integer> colorMap = new HashSet(this.biomeRegistry.entries()).stream().collect(Collectors.toMap(b -> b, Biome::getColor));
        HashMap output = new HashMap();
        colorMap.forEach((biome, color) -> {
            if (output.containsKey(color)) {
                throw new IllegalArgumentException(String.format("Biome %s has same color as %s: %x", biome.getID(), ((Biome)output.get(color)).getID(), color));
            }
            output.put(color, biome);
        });
        return output.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.converter.apply((Biome)e.getValue())));
    }
}

