/*
 * Decompiled with CFR 0.152.
 */
package com.github.quiltservertools.ledger.database;

import com.github.quiltservertools.ledger.Ledger;
import com.github.quiltservertools.ledger.LedgerKt;
import com.github.quiltservertools.ledger.actions.ActionType;
import com.github.quiltservertools.ledger.actionutils.ActionSearchParams;
import com.github.quiltservertools.ledger.actionutils.Preview;
import com.github.quiltservertools.ledger.actionutils.SearchResults;
import com.github.quiltservertools.ledger.api.ExtensionManager;
import com.github.quiltservertools.ledger.config.DatabaseSpec;
import com.github.quiltservertools.ledger.config.LedgerConfigKt;
import com.github.quiltservertools.ledger.config.SearchSpec;
import com.github.quiltservertools.ledger.database.DatabaseManager;
import com.github.quiltservertools.ledger.database.Tables;
import com.github.quiltservertools.ledger.registry.ActionRegistry;
import com.github.quiltservertools.ledger.utility.NbtUtils;
import com.github.quiltservertools.ledger.utility.Negatable;
import com.github.quiltservertools.ledger.utility.PlayerResult;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.dao.id.EntityID;
import org.jetbrains.exposed.dao.id.IdTable;
import org.jetbrains.exposed.sql.AbstractQuery;
import org.jetbrains.exposed.sql.Alias;
import org.jetbrains.exposed.sql.AliasKt;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.OpKt;
import org.jetbrains.exposed.sql.QueriesKt;
import org.jetbrains.exposed.sql.Query;
import org.jetbrains.exposed.sql.QueryKt;
import org.jetbrains.exposed.sql.SQLExpressionBuilderKt;
import org.jetbrains.exposed.sql.SizedIterable;
import org.jetbrains.exposed.sql.SortOrder;
import org.jetbrains.exposed.sql.SqlExpressionBuilder;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.TableKt;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.InsertStatement;
import org.jetbrains.exposed.sql.statements.UpdateBuilder;
import org.jetbrains.exposed.sql.transactions.ThreadLocalTransactionManagerKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00fc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\n\b\u0002\u00a2\u0006\u0005\b\u008b\u0001\u0010\u000fJS\u0010\f\u001a\u00020\u000b\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0004\u001a\u00020\u00032\u0014\u0010\u0007\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0006\u0018\u00010\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\b2\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\bH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001b\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0010H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016J#\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\r\u0010\u001d\u001a\u00020\u000b\u00a2\u0006\u0004\b\u001d\u0010\u000fJB\u0010$\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u001e2'\u0010#\u001a#\b\u0001\u0012\u0004\u0012\u00020 \u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000!\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001f\u00a2\u0006\u0002\b\"H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0004\b$\u0010%J!\u0010(\u001a\u00020\u000b2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020&0\u0005H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0004\b(\u0010)J\u0015\u0010+\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u001a\u00a2\u0006\u0004\b+\u0010,J#\u00101\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020-2\u0006\u00100\u001a\u00020/H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0004\b1\u00102J)\u00105\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00172\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u00104\u001a\u000203H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0004\b5\u00106J\u001b\u00107\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0010H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0004\b7\u0010\u0016J\u001b\u00109\u001a\u00020\u000b2\u0006\u00108\u001a\u00020/H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0004\b9\u0010:J\u001b\u0010<\u001a\u00020\u000b2\u0006\u0010;\u001a\u00020&H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0004\b<\u0010=J!\u0010>\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00172\u0006\u0010\u0011\u001a\u00020\u0010H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0004\b>\u0010\u0016J!\u0010?\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00172\u0006\u0010\u0011\u001a\u00020\u0010H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0004\b?\u0010\u0016J#\u0010C\u001a\u00020B2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010A\u001a\u00020@H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0004\bC\u0010DJ'\u0010I\u001a\b\u0012\u0004\u0012\u00020H0\u00172\f\u0010G\u001a\b\u0012\u0004\u0012\u00020F0EH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0004\bI\u0010JJ\u001d\u0010O\u001a\u00020\u000b2\u0006\u0010L\u001a\u00020K2\u0006\u0010N\u001a\u00020M\u00a2\u0006\u0004\bO\u0010PJ\u001b\u0010\u0015\u001a\u00020\u0014*\u00020 2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0015\u0010QJ\u001b\u0010R\u001a\u00020\u000b*\u00020 2\u0006\u0010*\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\bR\u0010SJ\u001b\u0010T\u001a\u00020\u000b*\u00020 2\u0006\u00108\u001a\u00020/H\u0002\u00a2\u0006\u0004\bT\u0010UJ\u001b\u0010X\u001a\u00020W*\u00020 2\u0006\u0010V\u001a\u00020/H\u0002\u00a2\u0006\u0004\bX\u0010YJ#\u0010Z\u001a\u00020\u000b*\u00020 2\u0006\u0010.\u001a\u00020-2\u0006\u00100\u001a\u00020/H\u0002\u00a2\u0006\u0004\bZ\u0010[J!\u0010\\\u001a\u00020\u000b*\u00020 2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020&0\u0005H\u0002\u00a2\u0006\u0004\b\\\u0010]J\u001b\u0010^\u001a\u00020\u000b*\u00020 2\u0006\u0010;\u001a\u00020&H\u0002\u00a2\u0006\u0004\b^\u0010_J\u001b\u00107\u001a\u00020\u000b*\u00020 2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b7\u0010`J\u001b\u0010b\u001a\u00020a*\u00020 2\u0006\u00108\u001a\u00020/H\u0002\u00a2\u0006\u0004\bb\u0010cJ)\u0010e\u001a\b\u0012\u0004\u0012\u00020\u001a0d*\u00020 2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u00104\u001a\u000203H\u0002\u00a2\u0006\u0004\be\u0010fJ#\u0010g\u001a\u00020B*\u00020 2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010A\u001a\u00020@H\u0002\u00a2\u0006\u0004\bg\u0010hJ\u001d\u0010k\u001a\u0004\u0018\u00010j*\u00020 2\u0006\u0010i\u001a\u00020-H\u0002\u00a2\u0006\u0004\bk\u0010lJ\u001d\u0010k\u001a\u0004\u0018\u00010j*\u00020 2\u0006\u0010m\u001a\u00020/H\u0002\u00a2\u0006\u0004\bk\u0010nJ'\u0010o\u001a\b\u0012\u0004\u0012\u00020H0\u0017*\u00020 2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020F0EH\u0002\u00a2\u0006\u0004\bo\u0010pJ\u001b\u0010r\u001a\u00020q*\u00020 2\u0006\u0010;\u001a\u00020&H\u0002\u00a2\u0006\u0004\br\u0010sJ!\u0010t\u001a\b\u0012\u0004\u0012\u00020\u001a0d*\u00020 2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\bt\u0010uJ!\u0010v\u001a\b\u0012\u0004\u0012\u00020\u001a0d*\u00020 2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\bv\u0010uJ\u001b\u0010x\u001a\u00020w*\u00020 2\u0006\u0010;\u001a\u00020&H\u0002\u00a2\u0006\u0004\bx\u0010yR\u001a\u0010{\u001a\b\u0012\u0004\u0012\u00020\u001a0z8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b{\u0010|R\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0}8\u0006\u00a2\u0006\r\n\u0004\b\u0019\u0010~\u001a\u0005\b\u007f\u0010\u0080\u0001R\u001a\u0010\u0082\u0001\u001a\u00030\u0081\u00018\u0002@\u0002X\u0082.\u00a2\u0006\b\n\u0006\b\u0082\u0001\u0010\u0083\u0001R\u0019\u0010\u0084\u0001\u001a\u00020K8\u0002@\u0002X\u0082.\u00a2\u0006\b\n\u0006\b\u0084\u0001\u0010\u0085\u0001R\u001d\u0010\u0087\u0001\u001a\u00030\u0086\u00018\u0006\u00a2\u0006\u0010\n\u0006\b\u0087\u0001\u0010\u0088\u0001\u001a\u0006\b\u0089\u0001\u0010\u008a\u0001\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u008c\u0001"}, d2={"Lcom/github/quiltservertools/ledger/database/DatabaseManager;", "", "E", "Lorg/jetbrains/exposed/sql/Query;", "query", "", "Lcom/github/quiltservertools/ledger/utility/Negatable;", "paramSet", "Lorg/jetbrains/exposed/sql/Column;", "column", "orColumn", "", "addParameters", "(Lorg/jetbrains/exposed/sql/Query;Ljava/util/Collection;Lorg/jetbrains/exposed/sql/Column;Lorg/jetbrains/exposed/sql/Column;)V", "autoPurge", "()V", "Lcom/github/quiltservertools/ledger/actionutils/ActionSearchParams;", "params", "buildQuery", "(Lcom/github/quiltservertools/ledger/actionutils/ActionSearchParams;)Lorg/jetbrains/exposed/sql/Query;", "", "countActions", "(Lcom/github/quiltservertools/ledger/actionutils/ActionSearchParams;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "Lcom/github/quiltservertools/ledger/database/Tables$Action;", "actions", "Lcom/github/quiltservertools/ledger/actions/ActionType;", "daoToActionType", "(Ljava/util/List;)Ljava/util/List;", "ensureTables", "T", "Lkotlin/Function2;", "Lorg/jetbrains/exposed/sql/Transaction;", "Lkotlin/coroutines/Continuation;", "Lkotlin/ExtensionFunctionType;", "body", "execute", "(Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lnet/minecraft/class_2960;", "identifiers", "insertIdentifiers", "(Ljava/util/Collection;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "action", "logAction", "(Lcom/github/quiltservertools/ledger/actions/ActionType;)V", "Ljava/util/UUID;", "uuid", "", "name", "logPlayer", "(Ljava/util/UUID;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lcom/github/quiltservertools/ledger/actionutils/Preview$Type;", "type", "previewActions", "(Lcom/github/quiltservertools/ledger/actionutils/ActionSearchParams;Lcom/github/quiltservertools/ledger/actionutils/Preview$Type;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "purgeActions", "id", "registerActionType", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "identifier", "registerWorld", "(Lnet/minecraft/class_2960;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "restoreActions", "rollbackActions", "", "page", "Lcom/github/quiltservertools/ledger/actionutils/SearchResults;", "searchActions", "(Lcom/github/quiltservertools/ledger/actionutils/ActionSearchParams;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "Lcom/mojang/authlib/GameProfile;", "players", "Lcom/github/quiltservertools/ledger/utility/PlayerResult;", "searchPlayers", "(Ljava/util/Set;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Ljava/io/File;", "file", "Lnet/minecraft/server/MinecraftServer;", "server", "setValues", "(Ljava/io/File;Lnet/minecraft/server/MinecraftServer;)V", "(Lorg/jetbrains/exposed/sql/Transaction;Lcom/github/quiltservertools/ledger/actionutils/ActionSearchParams;)J", "insertAction", "(Lorg/jetbrains/exposed/sql/Transaction;Lcom/github/quiltservertools/ledger/actions/ActionType;)V", "insertActionType", "(Lorg/jetbrains/exposed/sql/Transaction;Ljava/lang/String;)V", "source", "Lcom/github/quiltservertools/ledger/database/Tables$Source;", "insertAndSelectSource", "(Lorg/jetbrains/exposed/sql/Transaction;Ljava/lang/String;)Lcom/github/quiltservertools/ledger/database/Tables$Source;", "insertPlayer", "(Lorg/jetbrains/exposed/sql/Transaction;Ljava/util/UUID;Ljava/lang/String;)V", "insertRegKeys", "(Lorg/jetbrains/exposed/sql/Transaction;Ljava/util/Collection;)V", "insertWorld", "(Lorg/jetbrains/exposed/sql/Transaction;Lnet/minecraft/class_2960;)V", "(Lorg/jetbrains/exposed/sql/Transaction;Lcom/github/quiltservertools/ledger/actionutils/ActionSearchParams;)V", "Lcom/github/quiltservertools/ledger/database/Tables$ActionIdentifier;", "selectActionId", "(Lorg/jetbrains/exposed/sql/Transaction;Ljava/lang/String;)Lcom/github/quiltservertools/ledger/database/Tables$ActionIdentifier;", "", "selectActionsPreview", "(Lorg/jetbrains/exposed/sql/Transaction;Lcom/github/quiltservertools/ledger/actionutils/ActionSearchParams;Lcom/github/quiltservertools/ledger/actionutils/Preview$Type;)Ljava/util/List;", "selectActionsSearch", "(Lorg/jetbrains/exposed/sql/Transaction;Lcom/github/quiltservertools/ledger/actionutils/ActionSearchParams;I)Lcom/github/quiltservertools/ledger/actionutils/SearchResults;", "playerId", "Lcom/github/quiltservertools/ledger/database/Tables$Player;", "selectPlayer", "(Lorg/jetbrains/exposed/sql/Transaction;Ljava/util/UUID;)Lcom/github/quiltservertools/ledger/database/Tables$Player;", "playerName", "(Lorg/jetbrains/exposed/sql/Transaction;Ljava/lang/String;)Lcom/github/quiltservertools/ledger/database/Tables$Player;", "selectPlayers", "(Lorg/jetbrains/exposed/sql/Transaction;Ljava/util/Set;)Ljava/util/List;", "Lcom/github/quiltservertools/ledger/database/Tables$ObjectIdentifier;", "selectRegistryKey", "(Lorg/jetbrains/exposed/sql/Transaction;Lnet/minecraft/class_2960;)Lcom/github/quiltservertools/ledger/database/Tables$ObjectIdentifier;", "selectRestoreActions", "(Lorg/jetbrains/exposed/sql/Transaction;Lcom/github/quiltservertools/ledger/actionutils/ActionSearchParams;)Ljava/util/List;", "selectRollbackActions", "Lcom/github/quiltservertools/ledger/database/Tables$World;", "selectWorld", "(Lorg/jetbrains/exposed/sql/Transaction;Lnet/minecraft/class_2960;)Lcom/github/quiltservertools/ledger/database/Tables$World;", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "_actions", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lkotlinx/coroutines/flow/SharedFlow;", "Lkotlinx/coroutines/flow/SharedFlow;", "getActions", "()Lkotlinx/coroutines/flow/SharedFlow;", "Lorg/jetbrains/exposed/sql/Database;", "database", "Lorg/jetbrains/exposed/sql/Database;", "databaseFile", "Ljava/io/File;", "Lkotlinx/coroutines/sync/Mutex;", "dbMutex", "Lkotlinx/coroutines/sync/Mutex;", "getDbMutex", "()Lkotlinx/coroutines/sync/Mutex;", "<init>", "ledger"})
public final class DatabaseManager {
    @NotNull
    public static final DatabaseManager INSTANCE = new DatabaseManager();
    private static File databaseFile;
    private static Database database;
    @NotNull
    private static final Mutex dbMutex;
    @NotNull
    private static final MutableSharedFlow<ActionType> _actions;
    @NotNull
    private static final SharedFlow<ActionType> actions;

    private DatabaseManager() {
    }

    @NotNull
    public final Mutex getDbMutex() {
        return dbMutex;
    }

    @NotNull
    public final SharedFlow<ActionType> getActions() {
        return actions;
    }

    public final void setValues(@NotNull File file2, @NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        if (ExtensionManager.INSTANCE.getDatabaseExtensionOptional().isPresent()) {
            database = ExtensionManager.INSTANCE.getDatabaseExtensionOptional().get().getDatabase(server);
        } else {
            databaseFile = file2;
            File file3 = databaseFile;
            if (file3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"databaseFile");
                file3 = null;
            }
            String string = file3.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"databaseFile.path");
            database = Database.Companion.connect$default(Database.Companion, "jdbc:sqlite:" + StringsKt.replace$default((String)string, (char)'\\', (char)'/', (boolean)false, (int)4, null), null, null, null, null, null, null, 126, null);
        }
    }

    public final void ensureTables() {
        ThreadLocalTransactionManagerKt.transaction$default(null, ensureTables.1.INSTANCE, 1, null);
    }

    public final void autoPurge() {
        if (((Number)LedgerConfigKt.getConfig().get(DatabaseSpec.INSTANCE.getAutoPurgeDays())).intValue() > 0) {
            BuildersKt.launch$default((CoroutineScope)Ledger.INSTANCE, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
                int label;

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = DatabaseManager.access$execute(DatabaseManager.INSTANCE, (Function2)new Function2<Transaction, Continuation<? super Unit>, Object>(null){
                                int label;

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            Ledger.INSTANCE.getLogger().info("Purging actions older than " + LedgerConfigKt.getConfig().get(DatabaseSpec.INSTANCE.getAutoPurgeDays()) + " days");
                                            int deleted2 = QueriesKt.deleteWhere$default(Tables.Actions.INSTANCE, null, null, autoPurge.deleted.1.INSTANCE, 3, null);
                                            Ledger.INSTANCE.getLogger().info("Successfully purged " + deleted2 + " actions");
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull Transaction p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    @Nullable
    public final Object searchActions(@NotNull ActionSearchParams params, int page2, @NotNull Continuation<? super SearchResults> $completion) {
        return this.execute((Function2)new Function2<Transaction, Continuation<? super SearchResults>, Object>(params, page2, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ActionSearchParams $params;
            final /* synthetic */ int $page;
            {
                this.$params = $params;
                this.$page = $page;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Transaction $this$execute = (Transaction)this.L$0;
                        return DatabaseManager.access$selectActionsSearch(DatabaseManager.INSTANCE, $this$execute, this.$params, this.$page);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull Transaction p1, @Nullable Continuation<? super SearchResults> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    @Nullable
    public final Object countActions(@NotNull ActionSearchParams params, @NotNull Continuation<? super Long> $completion) {
        return this.execute((Function2)new Function2<Transaction, Continuation<? super Long>, Object>(params, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ActionSearchParams $params;
            {
                this.$params = $params;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Transaction $this$execute = (Transaction)this.L$0;
                        return Boxing.boxLong((long)DatabaseManager.access$countActions(DatabaseManager.INSTANCE, $this$execute, this.$params));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull Transaction p1, @Nullable Continuation<? super Long> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    @Nullable
    public final Object rollbackActions(@NotNull ActionSearchParams params, @NotNull Continuation<? super List<? extends ActionType>> $completion) {
        return this.execute((Function2)new Function2<Transaction, Continuation<? super List<ActionType>>, Object>(params, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ActionSearchParams $params;
            {
                this.$params = $params;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Transaction $this$execute = (Transaction)this.L$0;
                        return DatabaseManager.access$selectRollbackActions(DatabaseManager.INSTANCE, $this$execute, this.$params);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull Transaction p1, @Nullable Continuation<? super List<ActionType>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    @Nullable
    public final Object restoreActions(@NotNull ActionSearchParams params, @NotNull Continuation<? super List<? extends ActionType>> $completion) {
        return this.execute((Function2)new Function2<Transaction, Continuation<? super List<ActionType>>, Object>(params, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ActionSearchParams $params;
            {
                this.$params = $params;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Transaction $this$execute = (Transaction)this.L$0;
                        return DatabaseManager.access$selectRestoreActions(DatabaseManager.INSTANCE, $this$execute, this.$params);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull Transaction p1, @Nullable Continuation<? super List<ActionType>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    @Nullable
    public final Object previewActions(@NotNull ActionSearchParams params, @NotNull Preview.Type type, @NotNull Continuation<? super List<? extends ActionType>> $completion) {
        return this.execute((Function2)new Function2<Transaction, Continuation<? super List<ActionType>>, Object>(params, type, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ActionSearchParams $params;
            final /* synthetic */ Preview.Type $type;
            {
                this.$params = $params;
                this.$type = $type;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Transaction $this$execute = (Transaction)this.L$0;
                        return DatabaseManager.access$selectActionsPreview(DatabaseManager.INSTANCE, $this$execute, this.$params, this.$type);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull Transaction p1, @Nullable Continuation<? super List<ActionType>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    private final List<ActionType> daoToActionType(List<Tables.Action> actions) {
        List actionTypes = new ArrayList();
        for (Tables.Action action : actions) {
            GameProfile gameProfile;
            class_2680 class_26802;
            class_2680 class_26803;
            Object it;
            ActionType actionType;
            ActionType type;
            Supplier<ActionType> typeSupplier = ActionRegistry.INSTANCE.getType(action.getActionIdentifier().getIdentifier());
            if (typeSupplier == null) {
                LedgerKt.logWarn("Unknown action type " + action.getActionIdentifier().getIdentifier());
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)typeSupplier.get(), (String)"typeSupplier.get()");
            type.setTimestamp(action.getTimestamp());
            type.setPos(new class_2338(action.getX(), action.getY(), action.getZ()));
            type.setWorld(action.getWorld().getIdentifier());
            class_2960 class_29602 = action.getObjectId().getIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)class_29602, (String)"action.objectId.identifier");
            type.setObjectIdentifier(class_29602);
            class_2960 class_29603 = action.getOldObjectId().getIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)class_29603, (String)"action.oldObjectId.identifier");
            type.setOldObjectIdentifier(class_29603);
            ActionType actionType2 = type;
            if (action.getBlockState() != null) {
                actionType = actionType2;
                boolean bl = false;
                class_2487 class_24872 = class_2522.method_10718((String)it);
                Intrinsics.checkNotNullExpressionValue((Object)class_24872, (String)"parse(it)");
                class_2960 class_29604 = action.getObjectId().getIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)class_29604, (String)"action.objectId.identifier");
                class_26803 = NbtUtils.INSTANCE.blockStateFromProperties(class_24872, class_29604);
                actionType2 = actionType;
            } else {
                class_26803 = null;
            }
            actionType2.setBlockState(class_26803);
            ActionType actionType3 = type;
            if (action.getOldBlockState() != null) {
                actionType = actionType3;
                boolean bl = false;
                class_2487 class_24873 = class_2522.method_10718((String)it);
                Intrinsics.checkNotNullExpressionValue((Object)class_24873, (String)"parse(it)");
                class_2960 class_29605 = action.getOldObjectId().getIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)class_29605, (String)"action.oldObjectId.identifier");
                class_26802 = NbtUtils.INSTANCE.blockStateFromProperties(class_24873, class_29605);
                actionType3 = actionType;
            } else {
                class_26802 = null;
            }
            actionType3.setOldBlockState(class_26802);
            type.setSourceName(action.getSourceName().getName());
            ActionType actionType4 = type;
            if (action.getSourcePlayer() != null) {
                actionType = actionType4;
                boolean bl = false;
                gameProfile = new GameProfile(((Tables.Player)it).getPlayerId(), ((Tables.Player)it).getPlayerName());
                actionType4 = actionType;
            } else {
                gameProfile = null;
            }
            actionType4.setSourceProfile(gameProfile);
            type.setExtraData(action.getExtraData());
            type.setRolledBack(action.getRolledBack());
            actionTypes.add(type);
        }
        return actionTypes;
    }

    private final Query buildQuery(ActionSearchParams params) {
        Collection collection;
        List list2;
        Negatable it;
        Collection<Negatable<String>> collection2;
        Iterable $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        Collection destination$iv$iv;
        Iterable $this$map$iv;
        boolean $i$f$map;
        DatabaseManager databaseManager;
        Query query2;
        Alias<Table> oldObjectTable = AliasKt.alias((Table)Tables.ObjectIdentifiers.INSTANCE, "oldObjects");
        Query query3 = QueriesKt.selectAll(TableKt.innerJoin$default(TableKt.innerJoin$default(Tables.Actions.INSTANCE.innerJoin(Tables.ActionIdentifiers.INSTANCE).innerJoin(Tables.Worlds.INSTANCE).leftJoin(Tables.Players.INSTANCE), oldObjectTable, buildQuery.query.1.INSTANCE, new Function1<Alias<? extends Tables.ObjectIdentifiers>, Expression<?>>(oldObjectTable){
            final /* synthetic */ Alias<Tables.ObjectIdentifiers> $oldObjectTable;
            {
                this.$oldObjectTable = $oldObjectTable;
                super(1);
            }

            @NotNull
            public final Expression<?> invoke(@NotNull Alias<Tables.ObjectIdentifiers> $this$innerJoin) {
                Intrinsics.checkNotNullParameter($this$innerJoin, (String)"$this$innerJoin");
                return this.$oldObjectTable.get(Tables.ObjectIdentifiers.INSTANCE.getId());
            }
        }, null, 8, null), Tables.ObjectIdentifiers.INSTANCE, buildQuery.query.3.INSTANCE, buildQuery.query.4.INSTANCE, null, 8, null).innerJoin(Tables.Sources.INSTANCE));
        if (params.getBounds() != null) {
            QueryKt.andWhere(query3, (Function1<? super SqlExpressionBuilder, ? extends Op<Boolean>>)((Function1)new Function1<SqlExpressionBuilder, Op<Boolean>>(params){
                final /* synthetic */ ActionSearchParams $params;
                {
                    this.$params = $params;
                    super(1);
                }

                @NotNull
                public final Op<Boolean> invoke(@NotNull SqlExpressionBuilder $this$andWhere) {
                    Intrinsics.checkNotNullParameter((Object)$this$andWhere, (String)"$this$andWhere");
                    return $this$andWhere.between((ExpressionWithColumnType)Tables.Actions.INSTANCE.getX(), this.$params.getBounds().method_35415(), this.$params.getBounds().method_35418());
                }
            }));
            QueryKt.andWhere(query3, (Function1<? super SqlExpressionBuilder, ? extends Op<Boolean>>)((Function1)new Function1<SqlExpressionBuilder, Op<Boolean>>(params){
                final /* synthetic */ ActionSearchParams $params;
                {
                    this.$params = $params;
                    super(1);
                }

                @NotNull
                public final Op<Boolean> invoke(@NotNull SqlExpressionBuilder $this$andWhere) {
                    Intrinsics.checkNotNullParameter((Object)$this$andWhere, (String)"$this$andWhere");
                    return $this$andWhere.between((ExpressionWithColumnType)Tables.Actions.INSTANCE.getY(), this.$params.getBounds().method_35416(), this.$params.getBounds().method_35419());
                }
            }));
            QueryKt.andWhere(query3, (Function1<? super SqlExpressionBuilder, ? extends Op<Boolean>>)((Function1)new Function1<SqlExpressionBuilder, Op<Boolean>>(params){
                final /* synthetic */ ActionSearchParams $params;
                {
                    this.$params = $params;
                    super(1);
                }

                @NotNull
                public final Op<Boolean> invoke(@NotNull SqlExpressionBuilder $this$andWhere) {
                    Intrinsics.checkNotNullParameter((Object)$this$andWhere, (String)"$this$andWhere");
                    return $this$andWhere.between((ExpressionWithColumnType)Tables.Actions.INSTANCE.getZ(), this.$params.getBounds().method_35417(), this.$params.getBounds().method_35420());
                }
            }));
        }
        if (params.getBefore() != null && params.getAfter() != null) {
            QueryKt.andWhere(QueryKt.andWhere(query3, (Function1<? super SqlExpressionBuilder, ? extends Op<Boolean>>)((Function1)new Function1<SqlExpressionBuilder, Op<Boolean>>(params){
                final /* synthetic */ ActionSearchParams $params;
                {
                    this.$params = $params;
                    super(1);
                }

                @NotNull
                public final Op<Boolean> invoke(@NotNull SqlExpressionBuilder $this$andWhere) {
                    Intrinsics.checkNotNullParameter((Object)$this$andWhere, (String)"$this$andWhere");
                    return $this$andWhere.greaterEq((ExpressionWithColumnType)Tables.Actions.INSTANCE.getTimestamp(), (Comparable)this.$params.getAfter());
                }
            })), (Function1<? super SqlExpressionBuilder, ? extends Op<Boolean>>)((Function1)new Function1<SqlExpressionBuilder, Op<Boolean>>(params){
                final /* synthetic */ ActionSearchParams $params;
                {
                    this.$params = $params;
                    super(1);
                }

                @NotNull
                public final Op<Boolean> invoke(@NotNull SqlExpressionBuilder $this$andWhere) {
                    Intrinsics.checkNotNullParameter((Object)$this$andWhere, (String)"$this$andWhere");
                    return $this$andWhere.lessEq((ExpressionWithColumnType)Tables.Actions.INSTANCE.getTimestamp(), (Comparable)this.$params.getBefore());
                }
            }));
        } else if (params.getBefore() != null) {
            QueryKt.andWhere(query3, (Function1<? super SqlExpressionBuilder, ? extends Op<Boolean>>)((Function1)new Function1<SqlExpressionBuilder, Op<Boolean>>(params){
                final /* synthetic */ ActionSearchParams $params;
                {
                    this.$params = $params;
                    super(1);
                }

                @NotNull
                public final Op<Boolean> invoke(@NotNull SqlExpressionBuilder $this$andWhere) {
                    Intrinsics.checkNotNullParameter((Object)$this$andWhere, (String)"$this$andWhere");
                    return $this$andWhere.lessEq((ExpressionWithColumnType)Tables.Actions.INSTANCE.getTimestamp(), (Comparable)this.$params.getBefore());
                }
            }));
        } else if (params.getAfter() != null) {
            QueryKt.andWhere(query3, (Function1<? super SqlExpressionBuilder, ? extends Op<Boolean>>)((Function1)new Function1<SqlExpressionBuilder, Op<Boolean>>(params){
                final /* synthetic */ ActionSearchParams $params;
                {
                    this.$params = $params;
                    super(1);
                }

                @NotNull
                public final Op<Boolean> invoke(@NotNull SqlExpressionBuilder $this$andWhere) {
                    Intrinsics.checkNotNullParameter((Object)$this$andWhere, (String)"$this$andWhere");
                    return $this$andWhere.greaterEq((ExpressionWithColumnType)Tables.Actions.INSTANCE.getTimestamp(), (Comparable)this.$params.getAfter());
                }
            }));
        }
        DatabaseManager.addParameters$default(this, query3, params.getSourceNames(), Tables.Sources.INSTANCE.getName(), null, 8, null);
        DatabaseManager.addParameters$default(this, query3, params.getActions(), Tables.ActionIdentifiers.INSTANCE.getActionIdentifier(), null, 8, null);
        DatabaseManager databaseManager2 = this;
        Query query4 = query3;
        Set<Negatable<class_2960>> set = params.getWorlds();
        if (set != null) {
            Iterable iterable = set;
            query2 = query4;
            databaseManager = databaseManager2;
            $i$f$map = false;
            void var6_8 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Negatable<String> negatable;
                Negatable negatable2 = (Negatable)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl = false;
                if (it.getAllowed()) {
                    String string = ((class_2960)it.getProperty()).toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.property.toString()");
                    negatable = Negatable.Companion.allow(string);
                } else {
                    String string = ((class_2960)it.getProperty()).toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.property.toString()");
                    negatable = Negatable.Companion.deny(string);
                }
                collection2.add(negatable);
            }
            collection2 = (List)destination$iv$iv;
            databaseManager2 = databaseManager;
            query4 = query2;
            list2 = collection2;
        } else {
            list2 = null;
        }
        DatabaseManager.addParameters$default(databaseManager2, query4, list2, Tables.Worlds.INSTANCE.getIdentifier(), null, 8, null);
        DatabaseManager databaseManager3 = this;
        Query query5 = query3;
        Set<Negatable<class_2960>> set2 = params.getObjects();
        if (set2 != null) {
            $this$map$iv = set2;
            query2 = query5;
            databaseManager = databaseManager3;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Negatable<String> negatable;
                it = (Negatable)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl = false;
                if (it.getAllowed()) {
                    String string = ((class_2960)it.getProperty()).toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.property.toString()");
                    negatable = Negatable.Companion.allow(string);
                } else {
                    String string = ((class_2960)it.getProperty()).toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.property.toString()");
                    negatable = Negatable.Companion.deny(string);
                }
                collection2.add(negatable);
            }
            collection2 = (List)destination$iv$iv;
            databaseManager3 = databaseManager;
            query5 = query2;
            collection = collection2;
        } else {
            collection = null;
        }
        databaseManager3.addParameters(query5, collection, Tables.ObjectIdentifiers.INSTANCE.getIdentifier(), oldObjectTable.get(Tables.ObjectIdentifiers.INSTANCE.getIdentifier()));
        DatabaseManager.addParameters$default(this, query3, params.getSourcePlayerNames(), Tables.Players.INSTANCE.getPlayerName(), null, 8, null);
        return query3;
    }

    /*
     * WARNING - void declaration
     */
    private final <E> void addParameters(Query query2, Collection<Negatable<E>> paramSet, Column<E> column, Column<E> orColumn) {
        Iterable $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Negatable it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable<Negatable<E>> iterable = paramSet;
        if (iterable == null || iterable.isEmpty()) {
            return;
        }
        iterable = paramSet;
        Column<E> column2 = column;
        Query query3 = query2;
        Column<E> column3 = orColumn;
        boolean $i$f$filter = false;
        void var7_10 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Negatable)element$iv$iv;
            boolean bl = false;
            if (!it.getAllowed()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection collection = (List)destination$iv$iv;
        $this$filter$iv = collection;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Negatable)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getProperty());
        }
        collection = (List)destination$iv$iv;
        DatabaseManager.addParameters$addAllowedParameters(column3, query3, column2, collection);
        $this$map$iv = paramSet;
        column2 = column;
        query3 = query2;
        column3 = orColumn;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (Negatable)element$iv$iv;
            boolean bl = false;
            if (it.getAllowed()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        collection = (List)destination$iv$iv;
        $this$filterNot$iv = collection;
        $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Negatable)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getProperty());
        }
        collection = (List)destination$iv$iv;
        DatabaseManager.addParameters$addDeniedParameters(column3, query3, column2, collection);
    }

    static /* synthetic */ void addParameters$default(DatabaseManager databaseManager, Query query2, Collection collection, Column column, Column column2, int n, Object object) {
        if ((n & 8) != 0) {
            column2 = null;
        }
        databaseManager.addParameters(query2, collection, column, column2);
    }

    public final void logAction(@NotNull ActionType action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        if (action.isBlacklisted()) {
            return;
        }
        _actions.tryEmit((Object)action);
    }

    @Nullable
    public final Object registerWorld(@NotNull class_2960 identifier2, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.execute((Function2)new Function2<Transaction, Continuation<? super Unit>, Object>(identifier2, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ class_2960 $identifier;
            {
                this.$identifier = $identifier;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Transaction $this$execute = (Transaction)this.L$0;
                        DatabaseManager.access$insertWorld(DatabaseManager.INSTANCE, $this$execute, this.$identifier);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull Transaction p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object registerActionType(@NotNull String id2, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.execute((Function2)new Function2<Transaction, Continuation<? super Unit>, Object>(id2, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ String $id;
            {
                this.$id = $id;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Transaction $this$execute = (Transaction)this.L$0;
                        DatabaseManager.access$insertActionType(DatabaseManager.INSTANCE, $this$execute, this.$id);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull Transaction p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object logPlayer(@NotNull UUID uuid, @NotNull String name, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.execute((Function2)new Function2<Transaction, Continuation<? super Unit>, Object>(uuid, name, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ UUID $uuid;
            final /* synthetic */ String $name;
            {
                this.$uuid = $uuid;
                this.$name = $name;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Transaction $this$execute = (Transaction)this.L$0;
                        DatabaseManager.access$insertPlayer(DatabaseManager.INSTANCE, $this$execute, this.$uuid, this.$name);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull Transaction p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object insertIdentifiers(@NotNull Collection<? extends class_2960> identifiers, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.execute((Function2)new Function2<Transaction, Continuation<? super Unit>, Object>(identifiers, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Collection<class_2960> $identifiers;
            {
                this.$identifiers = $identifiers;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Transaction $this$execute = (Transaction)this.L$0;
                        DatabaseManager.access$insertRegKeys(DatabaseManager.INSTANCE, $this$execute, this.$identifiers);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull Transaction p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Exception decompiling
     */
    private final <T> Object execute(Function2<? super Transaction, ? super Continuation<? super T>, ? extends Object> var1_1, Continuation<? super T> var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 11[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    public final Object purgeActions(@NotNull ActionSearchParams params, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.execute((Function2)new Function2<Transaction, Continuation<? super Unit>, Object>(params, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ActionSearchParams $params;
            {
                this.$params = $params;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Transaction $this$execute = (Transaction)this.L$0;
                        DatabaseManager.access$purgeActions(DatabaseManager.INSTANCE, $this$execute, this.$params);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull Transaction p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object searchPlayers(@NotNull Set<? extends GameProfile> players, @NotNull Continuation<? super List<PlayerResult>> $completion) {
        return this.execute((Function2)new Function2<Transaction, Continuation<? super List<? extends PlayerResult>>, Object>(players, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Set<GameProfile> $players;
            {
                this.$players = $players;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Transaction $this$execute = (Transaction)this.L$0;
                        return DatabaseManager.access$selectPlayers(DatabaseManager.INSTANCE, $this$execute, this.$players);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull Transaction p1, @Nullable Continuation<? super List<PlayerResult>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    private final void insertActionType(Transaction $this$insertActionType, String id2) {
        if (Tables.ActionIdentifier.Companion.find((Function1<SqlExpressionBuilder, Op<Boolean>>)((Function1)new Function1<SqlExpressionBuilder, Op<Boolean>>(id2){
            final /* synthetic */ String $id;
            {
                this.$id = $id;
                super(1);
            }

            @NotNull
            public final Op<Boolean> invoke(@NotNull SqlExpressionBuilder $this$find) {
                Intrinsics.checkNotNullParameter((Object)$this$find, (String)"$this$find");
                return $this$find.eq((ExpressionWithColumnType)Tables.ActionIdentifiers.INSTANCE.getActionIdentifier(), this.$id);
            }
        })).empty()) {
            Tables.ActionIdentifier actionIdentifier2 = (Tables.ActionIdentifier)Tables.ActionIdentifier.Companion.new((Function1)new Function1<Tables.ActionIdentifier, Unit>(id2){
                final /* synthetic */ String $id;
                {
                    this.$id = $id;
                    super(1);
                }

                public final void invoke(@NotNull Tables.ActionIdentifier $this$new) {
                    Intrinsics.checkNotNullParameter((Object)$this$new, (String)"$this$new");
                    $this$new.setIdentifier(this.$id);
                }
            });
        }
    }

    private final void insertWorld(Transaction $this$insertWorld, class_2960 identifier2) {
        QueriesKt.insertIgnore((Table)Tables.Worlds.INSTANCE, (Function2)new Function2<Tables.Worlds, UpdateBuilder<?>, Unit>(identifier2){
            final /* synthetic */ class_2960 $identifier;
            {
                this.$identifier = $identifier;
                super(2);
            }

            public final void invoke(@NotNull Tables.Worlds $this$insertIgnore, @NotNull UpdateBuilder<?> it) {
                Intrinsics.checkNotNullParameter((Object)$this$insertIgnore, (String)"$this$insertIgnore");
                Intrinsics.checkNotNullParameter(it, (String)"it");
                Column<String> column = $this$insertIgnore.getIdentifier();
                String string = this.$identifier.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"identifier.toString()");
                it.set(column, string);
            }
        });
    }

    private final void insertRegKeys(Transaction $this$insertRegKeys, Collection<? extends class_2960> identifiers) {
        QueriesKt.batchInsert$default((Table)Tables.ObjectIdentifiers.INSTANCE, identifiers, true, false, (Function2)insertRegKeys.1.INSTANCE, 4, null);
    }

    private final void insertAction(Transaction $this$insertAction, ActionType action) {
        Tables.Action.Companion.new((Function1)new Function1<Tables.Action, Unit>($this$insertAction, action){
            final /* synthetic */ Transaction $this_insertAction;
            final /* synthetic */ ActionType $action;
            {
                this.$this_insertAction = $receiver;
                this.$action = $action;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Tables.Action $this$new) {
                Tables.Player player2;
                String string;
                String string2;
                class_2680 it;
                Tables.Action action;
                Object object;
                Intrinsics.checkNotNullParameter((Object)$this$new, (String)"$this$new");
                $this$new.setActionIdentifier(DatabaseManager.access$selectActionId(DatabaseManager.INSTANCE, this.$this_insertAction, this.$action.getIdentifier()));
                $this$new.setTimestamp(this.$action.getTimestamp());
                $this$new.setX(this.$action.getPos().method_10263());
                $this$new.setY(this.$action.getPos().method_10264());
                $this$new.setZ(this.$action.getPos().method_10260());
                $this$new.setObjectId(DatabaseManager.access$selectRegistryKey(DatabaseManager.INSTANCE, this.$this_insertAction, this.$action.getObjectIdentifier()));
                $this$new.setOldObjectId(DatabaseManager.access$selectRegistryKey(DatabaseManager.INSTANCE, this.$this_insertAction, this.$action.getOldObjectIdentifier()));
                class_2960 class_29602 = this.$action.getWorld();
                if (class_29602 == null) {
                    class_29602 = Ledger.INSTANCE.getServer().method_30002().method_27983().method_29177();
                }
                Intrinsics.checkNotNullExpressionValue((Object)class_29602, (String)"action.world ?: Ledger.s\u2026erworld.registryKey.value");
                $this$new.setWorld(DatabaseManager.access$selectWorld(DatabaseManager.INSTANCE, this.$this_insertAction, class_29602));
                Tables.Action action2 = $this$new;
                class_2680 class_26802 = this.$action.getBlockState();
                if (class_26802 != null) {
                    object = class_26802;
                    action = action2;
                    boolean bl = false;
                    class_2487 class_24872 = NbtUtils.INSTANCE.blockStateToProperties(it);
                    string2 = class_24872 != null ? class_24872.method_10714() : null;
                    action2 = action;
                } else {
                    string2 = null;
                }
                action2.setBlockState(string2);
                Tables.Action action3 = $this$new;
                class_2680 class_26803 = this.$action.getOldBlockState();
                if (class_26803 != null) {
                    it = class_26803;
                    action = action3;
                    boolean bl = false;
                    class_2487 class_24873 = NbtUtils.INSTANCE.blockStateToProperties(it);
                    string = class_24873 != null ? class_24873.method_10714() : null;
                    action3 = action;
                } else {
                    string = null;
                }
                action3.setOldBlockState(string);
                $this$new.setSourceName(DatabaseManager.access$insertAndSelectSource(DatabaseManager.INSTANCE, this.$this_insertAction, this.$action.getSourceName()));
                Tables.Action action4 = $this$new;
                GameProfile gameProfile = this.$action.getSourceProfile();
                if (gameProfile != null) {
                    void it2;
                    GameProfile gameProfile2 = gameProfile;
                    object = this.$this_insertAction;
                    GameProfile bl = gameProfile2;
                    action = action4;
                    boolean bl2 = false;
                    UUID uUID = it2.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"it.id");
                    player2 = DatabaseManager.access$selectPlayer(DatabaseManager.INSTANCE, (Transaction)object, uUID);
                    action4 = action;
                } else {
                    player2 = null;
                }
                action4.setSourcePlayer(player2);
                $this$new.setExtraData(this.$action.getExtraData());
            }
        });
    }

    private final void insertPlayer(Transaction $this$insertPlayer, UUID uuid, String name) {
        Tables.Player player2 = (Tables.Player)CollectionsKt.firstOrNull((Iterable)Tables.Player.Companion.find((Function1<SqlExpressionBuilder, Op<Boolean>>)((Function1)new Function1<SqlExpressionBuilder, Op<Boolean>>(uuid){
            final /* synthetic */ UUID $uuid;
            {
                this.$uuid = $uuid;
                super(1);
            }

            @NotNull
            public final Op<Boolean> invoke(@NotNull SqlExpressionBuilder $this$find) {
                Intrinsics.checkNotNullParameter((Object)$this$find, (String)"$this$find");
                return $this$find.eq((ExpressionWithColumnType)Tables.Players.INSTANCE.getPlayerId(), this.$uuid);
            }
        })));
        if (player2 != null) {
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
            player2.setLastJoin(instant);
            player2.setPlayerName(name);
        } else {
            Tables.Player.Companion.new((Function1)new Function1<Tables.Player, Unit>(uuid, name){
                final /* synthetic */ UUID $uuid;
                final /* synthetic */ String $name;
                {
                    this.$uuid = $uuid;
                    this.$name = $name;
                    super(1);
                }

                public final void invoke(@NotNull Tables.Player $this$new) {
                    Intrinsics.checkNotNullParameter((Object)$this$new, (String)"$this$new");
                    $this$new.setPlayerId(this.$uuid);
                    $this$new.setPlayerName(this.$name);
                }
            });
        }
    }

    private final SearchResults selectActionsSearch(Transaction $this$selectActionsSearch, ActionSearchParams params, int page2) {
        List actionTypes = new ArrayList();
        long totalActions = 0L;
        Query query2 = this.buildQuery(params);
        totalActions = query2.copy().count();
        if (totalActions == 0L) {
            return new SearchResults(actionTypes, params, page2, 0);
        }
        query2 = (Query)query2.orderBy((Expression)Tables.Actions.INSTANCE.getId(), SortOrder.DESC);
        query2 = (Query)AbstractQuery.withDistinct$default((AbstractQuery)query2.limit(((Number)LedgerConfigKt.getConfig().get(SearchSpec.INSTANCE.getPageSize())).intValue(), ((Number)LedgerConfigKt.getConfig().get(SearchSpec.INSTANCE.getPageSize())).intValue() * (page2 - 1)), false, 1, null);
        List actions = CollectionsKt.toList((Iterable)Tables.Action.Companion.wrapRows(query2));
        actionTypes.addAll((Collection)this.daoToActionType(actions));
        int totalPages = (int)Math.ceil((double)totalActions / (double)((Number)LedgerConfigKt.getConfig().get(SearchSpec.INSTANCE.getPageSize())).intValue());
        return new SearchResults(actionTypes, params, page2, totalPages);
    }

    private final long countActions(Transaction $this$countActions, ActionSearchParams params) {
        return this.buildQuery(params).copy().count();
    }

    private final List<ActionType> selectActionsPreview(Transaction $this$selectActionsPreview, ActionSearchParams params, Preview.Type type) {
        List actionTypes = new ArrayList();
        boolean isRestore = type == Preview.Type.RESTORE;
        Query query2 = (Query)QueryKt.andWhere(this.buildQuery(params), (Function1<? super SqlExpressionBuilder, ? extends Op<Boolean>>)((Function1)new Function1<SqlExpressionBuilder, Op<Boolean>>(isRestore){
            final /* synthetic */ boolean $isRestore;
            {
                this.$isRestore = $isRestore;
                super(1);
            }

            @NotNull
            public final Op<Boolean> invoke(@NotNull SqlExpressionBuilder $this$andWhere) {
                Intrinsics.checkNotNullParameter((Object)$this$andWhere, (String)"$this$andWhere");
                return $this$andWhere.eq((ExpressionWithColumnType)Tables.Actions.INSTANCE.getRolledBack(), this.$isRestore);
            }
        })).orderBy((Expression)Tables.Actions.INSTANCE.getId(), isRestore ? SortOrder.ASC : SortOrder.DESC);
        List actions = CollectionsKt.toList((Iterable)Tables.Action.Companion.wrapRows(query2));
        actionTypes.addAll((Collection)this.daoToActionType(actions));
        return actionTypes;
    }

    private final List<ActionType> selectRollbackActions(Transaction $this$selectRollbackActions, ActionSearchParams params) {
        List actionTypes = new ArrayList();
        Query query2 = (Query)QueryKt.andWhere(this.buildQuery(params), (Function1<? super SqlExpressionBuilder, ? extends Op<Boolean>>)((Function1)selectRollbackActions.query.1.INSTANCE)).orderBy((Expression)Tables.Actions.INSTANCE.getId(), SortOrder.DESC);
        List actions = CollectionsKt.toList((Iterable)Tables.Action.Companion.wrapRows(query2));
        for (Tables.Action action : actions) {
            action.setRolledBack(true);
        }
        actionTypes.addAll((Collection)this.daoToActionType(actions));
        return actionTypes;
    }

    private final List<ActionType> selectRestoreActions(Transaction $this$selectRestoreActions, ActionSearchParams params) {
        List actionTypes = new ArrayList();
        Query query2 = (Query)QueryKt.andWhere(this.buildQuery(params), (Function1<? super SqlExpressionBuilder, ? extends Op<Boolean>>)((Function1)selectRestoreActions.query.1.INSTANCE)).orderBy((Expression)Tables.Actions.INSTANCE.getId(), SortOrder.ASC);
        List actions = CollectionsKt.toList((Iterable)Tables.Action.Companion.wrapRows(query2));
        for (Tables.Action action : actions) {
            action.setRolledBack(false);
        }
        actionTypes.addAll((Collection)this.daoToActionType(actions));
        return actionTypes;
    }

    private final Tables.Player selectPlayer(Transaction $this$selectPlayer, UUID playerId) {
        return (Tables.Player)CollectionsKt.firstOrNull((Iterable)Tables.Player.Companion.find((Function1<SqlExpressionBuilder, Op<Boolean>>)((Function1)new Function1<SqlExpressionBuilder, Op<Boolean>>(playerId){
            final /* synthetic */ UUID $playerId;
            {
                this.$playerId = $playerId;
                super(1);
            }

            @NotNull
            public final Op<Boolean> invoke(@NotNull SqlExpressionBuilder $this$find) {
                Intrinsics.checkNotNullParameter((Object)$this$find, (String)"$this$find");
                return $this$find.eq((ExpressionWithColumnType)Tables.Players.INSTANCE.getPlayerId(), this.$playerId);
            }
        })));
    }

    private final Tables.Player selectPlayer(Transaction $this$selectPlayer, String playerName) {
        return (Tables.Player)CollectionsKt.firstOrNull((Iterable)Tables.Player.Companion.find((Function1<SqlExpressionBuilder, Op<Boolean>>)((Function1)new Function1<SqlExpressionBuilder, Op<Boolean>>(playerName){
            final /* synthetic */ String $playerName;
            {
                this.$playerName = $playerName;
                super(1);
            }

            @NotNull
            public final Op<Boolean> invoke(@NotNull SqlExpressionBuilder $this$find) {
                Intrinsics.checkNotNullParameter((Object)$this$find, (String)"$this$find");
                return $this$find.eq((ExpressionWithColumnType)SQLExpressionBuilderKt.lowerCase(Tables.Players.INSTANCE.getPlayerName()), this.$playerName);
            }
        })));
    }

    private final Tables.Source insertAndSelectSource(Transaction $this$insertAndSelectSource, String source) {
        Tables.Source sourceDAO2 = (Tables.Source)CollectionsKt.firstOrNull((Iterable)Tables.Source.Companion.find((Function1<SqlExpressionBuilder, Op<Boolean>>)((Function1)new Function1<SqlExpressionBuilder, Op<Boolean>>(source){
            final /* synthetic */ String $source;
            {
                this.$source = $source;
                super(1);
            }

            @NotNull
            public final Op<Boolean> invoke(@NotNull SqlExpressionBuilder $this$find) {
                Intrinsics.checkNotNullParameter((Object)$this$find, (String)"$this$find");
                return $this$find.eq((ExpressionWithColumnType)Tables.Sources.INSTANCE.getName(), this.$source);
            }
        })));
        if (sourceDAO2 == null) {
            sourceDAO2 = (Tables.Source)Tables.Source.Companion.get(QueriesKt.insertAndGetId((IdTable)Tables.Sources.INSTANCE, (Function2)new Function2<Tables.Sources, InsertStatement<EntityID<Integer>>, Unit>(source){
                final /* synthetic */ String $source;
                {
                    this.$source = $source;
                    super(2);
                }

                public final void invoke(@NotNull Tables.Sources $this$insertAndGetId, @NotNull InsertStatement<EntityID<Integer>> it) {
                    Intrinsics.checkNotNullParameter((Object)$this$insertAndGetId, (String)"$this$insertAndGetId");
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    it.set($this$insertAndGetId.getName(), this.$source);
                }
            }));
        }
        return sourceDAO2;
    }

    private final Tables.ActionIdentifier selectActionId(Transaction $this$selectActionId, String id2) {
        return (Tables.ActionIdentifier)CollectionsKt.first((Iterable)Tables.ActionIdentifier.Companion.find((Function1<SqlExpressionBuilder, Op<Boolean>>)((Function1)new Function1<SqlExpressionBuilder, Op<Boolean>>(id2){
            final /* synthetic */ String $id;
            {
                this.$id = $id;
                super(1);
            }

            @NotNull
            public final Op<Boolean> invoke(@NotNull SqlExpressionBuilder $this$find) {
                Intrinsics.checkNotNullParameter((Object)$this$find, (String)"$this$find");
                return $this$find.eq((ExpressionWithColumnType)Tables.ActionIdentifiers.INSTANCE.getActionIdentifier(), this.$id);
            }
        })));
    }

    private final Tables.ObjectIdentifier selectRegistryKey(Transaction $this$selectRegistryKey, class_2960 identifier2) {
        return (Tables.ObjectIdentifier)CollectionsKt.first((Iterable)SizedIterable.DefaultImpls.limit$default(Tables.ObjectIdentifier.Companion.find((Function1<SqlExpressionBuilder, Op<Boolean>>)((Function1)new Function1<SqlExpressionBuilder, Op<Boolean>>(identifier2){
            final /* synthetic */ class_2960 $identifier;
            {
                this.$identifier = $identifier;
                super(1);
            }

            @NotNull
            public final Op<Boolean> invoke(@NotNull SqlExpressionBuilder $this$find) {
                Intrinsics.checkNotNullParameter((Object)$this$find, (String)"$this$find");
                ExpressionWithColumnType expressionWithColumnType = Tables.ObjectIdentifiers.INSTANCE.getIdentifier();
                String string = this.$identifier.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"identifier.toString()");
                return $this$find.eq(expressionWithColumnType, string);
            }
        })), 1, 0L, 2, null));
    }

    private final Tables.World selectWorld(Transaction $this$selectWorld, class_2960 identifier2) {
        return (Tables.World)CollectionsKt.first((Iterable)SizedIterable.DefaultImpls.limit$default(Tables.World.Companion.find((Function1<SqlExpressionBuilder, Op<Boolean>>)((Function1)new Function1<SqlExpressionBuilder, Op<Boolean>>(identifier2){
            final /* synthetic */ class_2960 $identifier;
            {
                this.$identifier = $identifier;
                super(1);
            }

            @NotNull
            public final Op<Boolean> invoke(@NotNull SqlExpressionBuilder $this$find) {
                Intrinsics.checkNotNullParameter((Object)$this$find, (String)"$this$find");
                ExpressionWithColumnType expressionWithColumnType = Tables.Worlds.INSTANCE.getIdentifier();
                String string = this.$identifier.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"identifier.toString()");
                return $this$find.eq(expressionWithColumnType, string);
            }
        })), 1, 0L, 2, null));
    }

    private final void purgeActions(Transaction $this$purgeActions, ActionSearchParams params) {
        Query query2 = this.buildQuery(params);
        List actions = CollectionsKt.toList((Iterable)Tables.Action.Companion.wrapRows(query2));
        Iterable $this$forEach$iv = actions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Tables.Action action = (Tables.Action)element$iv;
            boolean bl = false;
            action.delete();
        }
    }

    private final List<PlayerResult> selectPlayers(Transaction $this$selectPlayers, Set<? extends GameProfile> players) {
        Tables.Player it;
        Collection<Negatable<UUID>> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Query query2 = QueriesKt.selectAll(Tables.Players.INSTANCE);
        Iterable iterable = players;
        Query query3 = query2;
        Object object = this;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            GameProfile gameProfile = (GameProfile)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            UUID uUID = it.getId();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"it.id");
            collection.add(Negatable.Companion.allow(uUID));
        }
        collection = (List)destination$iv$iv;
        DatabaseManager.addParameters$default((DatabaseManager)object, query3, collection, Tables.Players.INSTANCE.getPlayerId(), null, 8, null);
        $this$map$iv = CollectionsKt.toList((Iterable)Tables.Player.Companion.wrapRows(query2));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Tables.Player)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(PlayerResult.Companion.fromRow(it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final void addParameters$addAllowedParameters$lambda-9(Ref.ObjectRef $operator, Column $orColumn, Column $column, Object param) {
        Op<Boolean> op;
        Intrinsics.checkNotNullParameter((Object)$operator, (String)"$operator");
        Intrinsics.checkNotNullParameter((Object)$column, (String)"$column");
        Ref.ObjectRef objectRef = $operator;
        if ($orColumn != null) {
            void $this$addParameters_u24addAllowedParameters_u24lambda_u2d9_u24lambda_u2d7;
            Expression $this$or$iv = (Expression)$operator.element;
            boolean $i$f$or = false;
            Op.Companion this_$iv$iv = Op.Companion;
            boolean $i$f$build = false;
            SqlExpressionBuilder sqlExpressionBuilder = SqlExpressionBuilder.INSTANCE;
            Expression expression = $this$or$iv;
            Ref.ObjectRef objectRef2 = objectRef;
            boolean bl = false;
            Op<Boolean> op2 = OpKt.or((Expression<Boolean>)$this$addParameters_u24addAllowedParameters_u24lambda_u2d9_u24lambda_u2d7.eq($column, param), (Expression<Boolean>)$this$addParameters_u24addAllowedParameters_u24lambda_u2d9_u24lambda_u2d7.eq($orColumn, param));
            v1 = objectRef2;
            op = OpKt.or((Expression<Boolean>)expression, (Expression<Boolean>)op2);
        } else {
            void $this$addParameters_u24addAllowedParameters_u24lambda_u2d9_u24lambda_u2d8;
            Expression $this$or$iv = (Expression)$operator.element;
            boolean $i$f$or = false;
            Op.Companion this_$iv$iv = Op.Companion;
            boolean $i$f$build = false;
            SqlExpressionBuilder $this$addParameters_u24addAllowedParameters_u24lambda_u2d9_u24lambda_u2d7 = SqlExpressionBuilder.INSTANCE;
            Expression expression = $this$or$iv;
            Ref.ObjectRef objectRef3 = objectRef;
            boolean bl = false;
            Op<Boolean> op3 = $this$addParameters_u24addAllowedParameters_u24lambda_u2d9_u24lambda_u2d8.eq($column, param);
            v1 = objectRef3;
            op = OpKt.or((Expression<Boolean>)expression, (Expression<Boolean>)op3);
        }
        v1.element = op;
    }

    /*
     * WARNING - void declaration
     */
    private static final <E> void addParameters$addAllowedParameters(Column<E> $orColumn, Query $query, Column<E> $column, Collection<? extends E> allowed) {
        Op<Boolean> op;
        Ref.ObjectRef operator;
        if (allowed.isEmpty()) {
            return;
        }
        Ref.ObjectRef objectRef = operator = new Ref.ObjectRef();
        if ($orColumn != null) {
            void $this$addParameters_u24addAllowedParameters_u24lambda_u2d5;
            Op.Companion this_$iv = Op.Companion;
            boolean $i$f$build = false;
            SqlExpressionBuilder sqlExpressionBuilder = SqlExpressionBuilder.INSTANCE;
            Ref.ObjectRef objectRef2 = objectRef;
            boolean bl = false;
            op = OpKt.or((Expression<Boolean>)$this$addParameters_u24addAllowedParameters_u24lambda_u2d5.eq((ExpressionWithColumnType)$column, CollectionsKt.first((Iterable)allowed)), (Expression<Boolean>)$this$addParameters_u24addAllowedParameters_u24lambda_u2d5.eq((ExpressionWithColumnType)$orColumn, CollectionsKt.first((Iterable)allowed)));
            v2 = objectRef2;
        } else {
            void $this$addParameters_u24addAllowedParameters_u24lambda_u2d6;
            Op.Companion this_$iv = Op.Companion;
            boolean $i$f$build = false;
            SqlExpressionBuilder $this$addParameters_u24addAllowedParameters_u24lambda_u2d5 = SqlExpressionBuilder.INSTANCE;
            Ref.ObjectRef objectRef3 = objectRef;
            boolean bl = false;
            op = $this$addParameters_u24addAllowedParameters_u24lambda_u2d6.eq((ExpressionWithColumnType)$column, CollectionsKt.first((Iterable)allowed));
            v2 = objectRef3;
        }
        v2.element = op;
        allowed.stream().skip(1L).forEach(arg_0 -> DatabaseManager.addParameters$addAllowedParameters$lambda-9(operator, $orColumn, $column, arg_0));
        QueryKt.andWhere($query, (Function1<? super SqlExpressionBuilder, ? extends Op<Boolean>>)((Function1)new Function1<SqlExpressionBuilder, Op<Boolean>>((Ref.ObjectRef<Op<Boolean>>)operator){
            final /* synthetic */ Ref.ObjectRef<Op<Boolean>> $operator;
            {
                this.$operator = $operator;
                super(1);
            }

            @NotNull
            public final Op<Boolean> invoke(@NotNull SqlExpressionBuilder $this$andWhere) {
                Intrinsics.checkNotNullParameter((Object)$this$andWhere, (String)"$this$andWhere");
                return (Op)this.$operator.element;
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private static final void addParameters$addDeniedParameters$lambda-14(Ref.ObjectRef $operator, Column $orColumn, Column $column, Object param) {
        Op<Boolean> op;
        Intrinsics.checkNotNullParameter((Object)$operator, (String)"$operator");
        Intrinsics.checkNotNullParameter((Object)$column, (String)"$column");
        Ref.ObjectRef objectRef = $operator;
        if ($orColumn != null) {
            void $this$addParameters_u24addDeniedParameters_u24lambda_u2d14_u24lambda_u2d12;
            Expression $this$and$iv = (Expression)$operator.element;
            boolean $i$f$and = false;
            Op.Companion this_$iv$iv = Op.Companion;
            boolean $i$f$build = false;
            SqlExpressionBuilder sqlExpressionBuilder = SqlExpressionBuilder.INSTANCE;
            Expression expression = $this$and$iv;
            Ref.ObjectRef objectRef2 = objectRef;
            boolean bl = false;
            Op<Boolean> op2 = OpKt.and((Expression<Boolean>)$this$addParameters_u24addDeniedParameters_u24lambda_u2d14_u24lambda_u2d12.neq($column, param), (Expression<Boolean>)$this$addParameters_u24addDeniedParameters_u24lambda_u2d14_u24lambda_u2d12.neq($orColumn, param));
            v1 = objectRef2;
            op = OpKt.and((Expression<Boolean>)expression, (Expression<Boolean>)op2);
        } else {
            void $this$addParameters_u24addDeniedParameters_u24lambda_u2d14_u24lambda_u2d13;
            Expression $this$and$iv = (Expression)$operator.element;
            boolean $i$f$and = false;
            Op.Companion this_$iv$iv = Op.Companion;
            boolean $i$f$build = false;
            SqlExpressionBuilder $this$addParameters_u24addDeniedParameters_u24lambda_u2d14_u24lambda_u2d12 = SqlExpressionBuilder.INSTANCE;
            Expression expression = $this$and$iv;
            Ref.ObjectRef objectRef3 = objectRef;
            boolean bl = false;
            Op<Boolean> op3 = OpKt.or((Expression<Boolean>)$this$addParameters_u24addDeniedParameters_u24lambda_u2d14_u24lambda_u2d13.neq($column, param), $this$addParameters_u24addDeniedParameters_u24lambda_u2d14_u24lambda_u2d13.isNull($column));
            v1 = objectRef3;
            op = OpKt.and((Expression<Boolean>)expression, (Expression<Boolean>)op3);
        }
        v1.element = op;
    }

    /*
     * WARNING - void declaration
     */
    private static final <E> void addParameters$addDeniedParameters(Column<E> $orColumn, Query $query, Column<E> $column, Collection<? extends E> denied) {
        Op<Boolean> op;
        Ref.ObjectRef operator;
        if (denied.isEmpty()) {
            return;
        }
        Ref.ObjectRef objectRef = operator = new Ref.ObjectRef();
        if ($orColumn != null) {
            void $this$addParameters_u24addDeniedParameters_u24lambda_u2d10;
            Op.Companion this_$iv = Op.Companion;
            boolean $i$f$build = false;
            SqlExpressionBuilder sqlExpressionBuilder = SqlExpressionBuilder.INSTANCE;
            Ref.ObjectRef objectRef2 = objectRef;
            boolean bl = false;
            op = OpKt.and((Expression<Boolean>)$this$addParameters_u24addDeniedParameters_u24lambda_u2d10.neq((ExpressionWithColumnType)$column, CollectionsKt.first((Iterable)denied)), (Expression<Boolean>)$this$addParameters_u24addDeniedParameters_u24lambda_u2d10.neq((ExpressionWithColumnType)$orColumn, CollectionsKt.first((Iterable)denied)));
            v2 = objectRef2;
        } else {
            void $this$addParameters_u24addDeniedParameters_u24lambda_u2d11;
            Op.Companion this_$iv = Op.Companion;
            boolean $i$f$build = false;
            SqlExpressionBuilder $this$addParameters_u24addDeniedParameters_u24lambda_u2d10 = SqlExpressionBuilder.INSTANCE;
            Ref.ObjectRef objectRef3 = objectRef;
            boolean bl = false;
            op = OpKt.or((Expression<Boolean>)$this$addParameters_u24addDeniedParameters_u24lambda_u2d11.neq((ExpressionWithColumnType)$column, CollectionsKt.first((Iterable)denied)), $this$addParameters_u24addDeniedParameters_u24lambda_u2d11.isNull($column));
            v2 = objectRef3;
        }
        v2.element = op;
        denied.stream().skip(1L).forEach(arg_0 -> DatabaseManager.addParameters$addDeniedParameters$lambda-14(operator, $orColumn, $column, arg_0));
        QueryKt.andWhere($query, (Function1<? super SqlExpressionBuilder, ? extends Op<Boolean>>)((Function1)new Function1<SqlExpressionBuilder, Op<Boolean>>((Ref.ObjectRef<Op<Boolean>>)operator){
            final /* synthetic */ Ref.ObjectRef<Op<Boolean>> $operator;
            {
                this.$operator = $operator;
                super(1);
            }

            @NotNull
            public final Op<Boolean> invoke(@NotNull SqlExpressionBuilder $this$andWhere) {
                Intrinsics.checkNotNullParameter((Object)$this$andWhere, (String)"$this$andWhere");
                return (Op)this.$operator.element;
            }
        }));
    }

    public static final /* synthetic */ Object access$execute(DatabaseManager $this, Function2 body, Continuation $completion) {
        return $this.execute(body, $completion);
    }

    public static final /* synthetic */ SearchResults access$selectActionsSearch(DatabaseManager $this, Transaction $receiver, ActionSearchParams params, int page2) {
        return $this.selectActionsSearch($receiver, params, page2);
    }

    public static final /* synthetic */ long access$countActions(DatabaseManager $this, Transaction $receiver, ActionSearchParams params) {
        return $this.countActions($receiver, params);
    }

    public static final /* synthetic */ List access$selectRollbackActions(DatabaseManager $this, Transaction $receiver, ActionSearchParams params) {
        return $this.selectRollbackActions($receiver, params);
    }

    public static final /* synthetic */ List access$selectRestoreActions(DatabaseManager $this, Transaction $receiver, ActionSearchParams params) {
        return $this.selectRestoreActions($receiver, params);
    }

    public static final /* synthetic */ List access$selectActionsPreview(DatabaseManager $this, Transaction $receiver, ActionSearchParams params, Preview.Type type) {
        return $this.selectActionsPreview($receiver, params, type);
    }

    public static final /* synthetic */ void access$insertWorld(DatabaseManager $this, Transaction $receiver, class_2960 identifier2) {
        $this.insertWorld($receiver, identifier2);
    }

    public static final /* synthetic */ void access$insertActionType(DatabaseManager $this, Transaction $receiver, String id2) {
        $this.insertActionType($receiver, id2);
    }

    public static final /* synthetic */ void access$insertPlayer(DatabaseManager $this, Transaction $receiver, UUID uuid, String name) {
        $this.insertPlayer($receiver, uuid, name);
    }

    public static final /* synthetic */ void access$insertRegKeys(DatabaseManager $this, Transaction $receiver, Collection identifiers) {
        $this.insertRegKeys($receiver, identifiers);
    }

    public static final /* synthetic */ void access$purgeActions(DatabaseManager $this, Transaction $receiver, ActionSearchParams params) {
        $this.purgeActions($receiver, params);
    }

    public static final /* synthetic */ List access$selectPlayers(DatabaseManager $this, Transaction $receiver, Set players) {
        return $this.selectPlayers($receiver, players);
    }

    public static final /* synthetic */ Tables.ActionIdentifier access$selectActionId(DatabaseManager $this, Transaction $receiver, String id2) {
        return $this.selectActionId($receiver, id2);
    }

    public static final /* synthetic */ Tables.ObjectIdentifier access$selectRegistryKey(DatabaseManager $this, Transaction $receiver, class_2960 identifier2) {
        return $this.selectRegistryKey($receiver, identifier2);
    }

    public static final /* synthetic */ Tables.World access$selectWorld(DatabaseManager $this, Transaction $receiver, class_2960 identifier2) {
        return $this.selectWorld($receiver, identifier2);
    }

    public static final /* synthetic */ Tables.Source access$insertAndSelectSource(DatabaseManager $this, Transaction $receiver, String source) {
        return $this.insertAndSelectSource($receiver, source);
    }

    public static final /* synthetic */ Tables.Player access$selectPlayer(DatabaseManager $this, Transaction $receiver, UUID playerId) {
        return $this.selectPlayer($receiver, playerId);
    }

    static {
        dbMutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
        _actions = SharedFlowKt.MutableSharedFlow$default((int)0, (int)Integer.MAX_VALUE, null, (int)5, null);
        actions = FlowKt.asSharedFlow(_actions);
        BuildersKt.launch$default((CoroutineScope)Ledger.INSTANCE, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = INSTANCE.getActions().collect((FlowCollector)1.INSTANCE, (Continuation)this);
                        if (object3 != object2) throw new KotlinNothingValueException();
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }
}

