/*
 * Decompiled with CFR 0.152.
 */
package com.github.quiltservertools.ledger.network;

import com.github.quiltservertools.ledger.config.LedgerConfigKt;
import com.github.quiltservertools.ledger.config.NetworkingSpec;
import com.github.quiltservertools.ledger.network.packet.LedgerPacketTypes;
import com.github.quiltservertools.ledger.network.packet.Receiver;
import com.github.quiltservertools.ledger.network.packet.receiver.HandshakePacketReceiver;
import com.github.quiltservertools.ledger.network.packet.receiver.InspectReceiver;
import com.github.quiltservertools.ledger.network.packet.receiver.PurgeReceiver;
import com.github.quiltservertools.ledger.network.packet.receiver.RollbackReceiver;
import com.github.quiltservertools.ledger.network.packet.receiver.SearchReceiver;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001f\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0011\u0010\u000b\u001a\u00020\n*\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0011\u0010\r\u001a\u00020\n*\u00020\t\u00a2\u0006\u0004\b\r\u0010\fJ\u0011\u0010\u000e\u001a\u00020\n*\u00020\t\u00a2\u0006\u0004\b\u000e\u0010\fR\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u00128\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0017"}, d2={"Lcom/github/quiltservertools/ledger/network/Networking;", "", "Lnet/minecraft/class_2960;", "channel", "Lcom/github/quiltservertools/ledger/network/packet/Receiver;", "receiver", "", "register", "(Lnet/minecraft/class_2960;Lcom/github/quiltservertools/ledger/network/packet/Receiver;)V", "Lnet/minecraft/class_3222;", "", "disableNetworking", "(Lnet/minecraft/class_3222;)Z", "enableNetworking", "hasNetworking", "", "networkedPlayers", "Ljava/util/Set;", "", "protocolVersion", "I", "<init>", "()V", "ledger"})
public final class Networking {
    @NotNull
    public static final Networking INSTANCE = new Networking();
    @NotNull
    private static Set<class_3222> networkedPlayers = new LinkedHashSet();
    public static final int protocolVersion = 2;

    private Networking() {
    }

    private final void register(class_2960 channel, Receiver receiver) {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)channel, (arg_0, arg_1, arg_2, arg_3, arg_4) -> Networking.register$lambda-0(receiver, arg_0, arg_1, arg_2, arg_3, arg_4));
    }

    public final boolean hasNetworking(@NotNull class_3222 $this$hasNetworking) {
        Intrinsics.checkNotNullParameter((Object)$this$hasNetworking, (String)"<this>");
        return networkedPlayers.contains($this$hasNetworking);
    }

    public final boolean enableNetworking(@NotNull class_3222 $this$enableNetworking) {
        Intrinsics.checkNotNullParameter((Object)$this$enableNetworking, (String)"<this>");
        return networkedPlayers.add($this$enableNetworking);
    }

    public final boolean disableNetworking(@NotNull class_3222 $this$disableNetworking) {
        Intrinsics.checkNotNullParameter((Object)$this$disableNetworking, (String)"<this>");
        return networkedPlayers.remove($this$disableNetworking);
    }

    private static final void register$lambda-0(Receiver $receiver, MinecraftServer server, class_3222 player2, class_3244 handler, class_2540 buf, PacketSender sender) {
        Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)player2, (String)"player");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        $receiver.receive(server, player2, handler, buf, sender);
    }

    static {
        if (((Boolean)LedgerConfigKt.getConfig().get(NetworkingSpec.INSTANCE.getNetworking())).booleanValue()) {
            INSTANCE.register(LedgerPacketTypes.INSPECT_POS.getId(), new InspectReceiver());
            INSTANCE.register(LedgerPacketTypes.SEARCH.getId(), new SearchReceiver());
            INSTANCE.register(LedgerPacketTypes.HANDSHAKE.getId(), new HandshakePacketReceiver());
            INSTANCE.register(LedgerPacketTypes.ROLLBACK.getId(), new RollbackReceiver());
            INSTANCE.register(LedgerPacketTypes.PURGE.getId(), new PurgeReceiver());
        }
    }
}

