/*
 * Decompiled with CFR 0.152.
 */
package com.github.quiltservertools.ledger.utility;

import com.github.quiltservertools.ledger.database.Tables;
import com.github.quiltservertools.ledger.utility.ExtensionsKt;
import com.github.quiltservertools.ledger.utility.MessageUtils;
import com.github.quiltservertools.ledger.utility.TextColorPallet;
import java.time.Instant;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\b\u0018\u0000 &2\u00020\u0001:\u0001&B'\u0012\u0006\u0010\f\u001a\u00020\u0002\u0012\u0006\u0010\r\u001a\u00020\u0005\u0012\u0006\u0010\u000e\u001a\u00020\b\u0012\u0006\u0010\u000f\u001a\u00020\b\u00a2\u0006\u0004\b$\u0010%J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\t\u001a\u00020\bH\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\bH\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\nJ8\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\f\u001a\u00020\u00022\b\b\u0002\u0010\r\u001a\u00020\u00052\b\b\u0002\u0010\u000e\u001a\u00020\b2\b\b\u0002\u0010\u000f\u001a\u00020\bH\u00c6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u0014\u001a\u00020\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0017\u001a\u00020\u0016H\u00d6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u0005H\u00d6\u0001\u00a2\u0006\u0004\b\u0019\u0010\u0007J\r\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0017\u0010\u000e\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u001d\u001a\u0004\b\u001e\u0010\nR\u0017\u0010\u000f\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u001d\u001a\u0004\b\u001f\u0010\nR\u0017\u0010\r\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\r\u0010 \u001a\u0004\b!\u0010\u0007R\u0017\u0010\f\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\"\u001a\u0004\b#\u0010\u0004\u00a8\u0006'"}, d2={"Lcom/github/quiltservertools/ledger/utility/PlayerResult;", "", "Ljava/util/UUID;", "component1", "()Ljava/util/UUID;", "", "component2", "()Ljava/lang/String;", "Ljava/time/Instant;", "component3", "()Ljava/time/Instant;", "component4", "uuid", "name", "firstJoin", "lastJoin", "copy", "(Ljava/util/UUID;Ljava/lang/String;Ljava/time/Instant;Ljava/time/Instant;)Lcom/github/quiltservertools/ledger/utility/PlayerResult;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Lnet/minecraft/class_2561;", "toText", "()Lnet/minecraft/class_2561;", "Ljava/time/Instant;", "getFirstJoin", "getLastJoin", "Ljava/lang/String;", "getName", "Ljava/util/UUID;", "getUuid", "<init>", "(Ljava/util/UUID;Ljava/lang/String;Ljava/time/Instant;Ljava/time/Instant;)V", "Companion", "ledger"})
public final class PlayerResult {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UUID uuid;
    @NotNull
    private final String name;
    @NotNull
    private final Instant firstJoin;
    @NotNull
    private final Instant lastJoin;

    public PlayerResult(@NotNull UUID uuid, @NotNull String name, @NotNull Instant firstJoin2, @NotNull Instant lastJoin2) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)firstJoin2, (String)"firstJoin");
        Intrinsics.checkNotNullParameter((Object)lastJoin2, (String)"lastJoin");
        this.uuid = uuid;
        this.name = name;
        this.firstJoin = firstJoin2;
        this.lastJoin = lastJoin2;
    }

    @NotNull
    public final UUID getUuid() {
        return this.uuid;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Instant getFirstJoin() {
        return this.firstJoin;
    }

    @NotNull
    public final Instant getLastJoin() {
        return this.lastJoin;
    }

    @NotNull
    public final class_2561 toText() {
        Object[] objectArray = new Object[]{ExtensionsKt.literal(this.name).method_10862(TextColorPallet.INSTANCE.getLight()), MessageUtils.INSTANCE.instantToText(this.firstJoin).method_10862(TextColorPallet.INSTANCE.getPrimaryVariant()), MessageUtils.INSTANCE.instantToText(this.lastJoin).method_10862(TextColorPallet.INSTANCE.getPrimaryVariant())};
        class_5250 class_52502 = class_2561.method_43469((String)"text.ledger.player.result", (Object[])objectArray).method_10862(TextColorPallet.INSTANCE.getSecondary());
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"translatable(\n          \u2026extColorPallet.secondary)");
        return (class_2561)class_52502;
    }

    @NotNull
    public final UUID component1() {
        return this.uuid;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    @NotNull
    public final Instant component3() {
        return this.firstJoin;
    }

    @NotNull
    public final Instant component4() {
        return this.lastJoin;
    }

    @NotNull
    public final PlayerResult copy(@NotNull UUID uuid, @NotNull String name, @NotNull Instant firstJoin2, @NotNull Instant lastJoin2) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)firstJoin2, (String)"firstJoin");
        Intrinsics.checkNotNullParameter((Object)lastJoin2, (String)"lastJoin");
        return new PlayerResult(uuid, name, firstJoin2, lastJoin2);
    }

    public static /* synthetic */ PlayerResult copy$default(PlayerResult playerResult, UUID uUID, String string, Instant instant, Instant instant2, int n, Object object) {
        if ((n & 1) != 0) {
            uUID = playerResult.uuid;
        }
        if ((n & 2) != 0) {
            string = playerResult.name;
        }
        if ((n & 4) != 0) {
            instant = playerResult.firstJoin;
        }
        if ((n & 8) != 0) {
            instant2 = playerResult.lastJoin;
        }
        return playerResult.copy(uUID, string, instant, instant2);
    }

    @NotNull
    public String toString() {
        return "PlayerResult(uuid=" + this.uuid + ", name=" + this.name + ", firstJoin=" + this.firstJoin + ", lastJoin=" + this.lastJoin + ")";
    }

    public int hashCode() {
        int result2 = this.uuid.hashCode();
        result2 = result2 * 31 + this.name.hashCode();
        result2 = result2 * 31 + this.firstJoin.hashCode();
        result2 = result2 * 31 + this.lastJoin.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PlayerResult)) {
            return false;
        }
        PlayerResult playerResult = (PlayerResult)other;
        if (!Intrinsics.areEqual((Object)this.uuid, (Object)playerResult.uuid)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)playerResult.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.firstJoin, (Object)playerResult.firstJoin)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.lastJoin, (Object)playerResult.lastJoin);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/github/quiltservertools/ledger/utility/PlayerResult$Companion;", "", "Lcom/github/quiltservertools/ledger/database/Tables$Player;", "row", "Lcom/github/quiltservertools/ledger/utility/PlayerResult;", "fromRow", "(Lcom/github/quiltservertools/ledger/database/Tables$Player;)Lcom/github/quiltservertools/ledger/utility/PlayerResult;", "<init>", "()V", "ledger"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PlayerResult fromRow(@NotNull Tables.Player row) {
            Intrinsics.checkNotNullParameter((Object)row, (String)"row");
            return new PlayerResult(row.getPlayerId(), row.getPlayerName(), row.getFirstJoin(), row.getLastJoin());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

