/*
 * Decompiled with CFR 0.152.
 */
package com.github.quiltservertools.libs.com.moandjiezana.toml;

import com.github.quiltservertools.libs.com.moandjiezana.toml.Context;
import com.github.quiltservertools.libs.com.moandjiezana.toml.Identifier;
import com.github.quiltservertools.libs.com.moandjiezana.toml.IdentifierConverter;
import com.github.quiltservertools.libs.com.moandjiezana.toml.Results;
import com.github.quiltservertools.libs.com.moandjiezana.toml.ValueReaders;
import java.util.concurrent.atomic.AtomicInteger;

class TomlParser {
    static Results run(String tomlString) {
        Results results = new Results();
        if (tomlString.isEmpty()) {
            return results;
        }
        AtomicInteger index = new AtomicInteger();
        boolean inComment = false;
        AtomicInteger line = new AtomicInteger(1);
        Identifier identifier2 = null;
        Object value2 = null;
        int i = index.get();
        while (i < tomlString.length()) {
            char c = tomlString.charAt(i);
            if (results.errors.hasErrors()) break;
            if (c == '#' && !inComment) {
                inComment = true;
            } else if (!Character.isWhitespace(c) && !inComment && identifier2 == null) {
                Identifier id2 = IdentifierConverter.IDENTIFIER_CONVERTER.convert(tomlString, index, new Context(null, line, results.errors));
                if (id2 != Identifier.INVALID) {
                    if (id2.isKey()) {
                        identifier2 = id2;
                    } else if (id2.isTable()) {
                        results.startTables(id2, line);
                    } else if (id2.isTableArray()) {
                        results.startTableArray(id2, line);
                    }
                }
            } else if (c == '\n') {
                inComment = false;
                identifier2 = null;
                value2 = null;
                line.incrementAndGet();
            } else if (!inComment && identifier2 != null && identifier2.isKey() && value2 == null && !Character.isWhitespace(c)) {
                value2 = ValueReaders.VALUE_READERS.convert(tomlString, index, new Context(identifier2, line, results.errors));
                if (value2 instanceof Results.Errors) {
                    results.errors.add((Results.Errors)value2);
                } else {
                    results.addValue(identifier2.getName(), value2, line);
                }
            } else if (value2 != null && !inComment && !Character.isWhitespace(c)) {
                results.errors.invalidTextAfterIdentifier(identifier2, c, line.get());
            }
            i = index.incrementAndGet();
        }
        return results;
    }

    private TomlParser() {
    }
}

