/*
 * Decompiled with CFR 0.152.
 */
package com.github.quiltservertools.libs.com.moandjiezana.toml;

import com.github.quiltservertools.libs.com.moandjiezana.toml.BooleanValueReaderWriter;
import com.github.quiltservertools.libs.com.moandjiezana.toml.DateValueReaderWriter;
import com.github.quiltservertools.libs.com.moandjiezana.toml.MapValueWriter;
import com.github.quiltservertools.libs.com.moandjiezana.toml.NumberValueReaderWriter;
import com.github.quiltservertools.libs.com.moandjiezana.toml.ObjectValueWriter;
import com.github.quiltservertools.libs.com.moandjiezana.toml.PrimitiveArrayValueWriter;
import com.github.quiltservertools.libs.com.moandjiezana.toml.StringValueReaderWriter;
import com.github.quiltservertools.libs.com.moandjiezana.toml.TableArrayValueWriter;
import com.github.quiltservertools.libs.com.moandjiezana.toml.ValueWriter;

class ValueWriters {
    static final ValueWriters WRITERS = new ValueWriters();
    private static final ValueWriter[] VALUE_WRITERS = new ValueWriter[]{StringValueReaderWriter.STRING_VALUE_READER_WRITER, NumberValueReaderWriter.NUMBER_VALUE_READER_WRITER, BooleanValueReaderWriter.BOOLEAN_VALUE_READER_WRITER, ValueWriters.getPlatformSpecificDateConverter(), MapValueWriter.MAP_VALUE_WRITER, PrimitiveArrayValueWriter.PRIMITIVE_ARRAY_VALUE_WRITER, TableArrayValueWriter.TABLE_ARRAY_VALUE_WRITER};

    ValueWriter findWriterFor(Object value2) {
        for (ValueWriter valueWriter : VALUE_WRITERS) {
            if (!valueWriter.canWrite(value2)) continue;
            return valueWriter;
        }
        return ObjectValueWriter.OBJECT_VALUE_WRITER;
    }

    private ValueWriters() {
    }

    private static DateValueReaderWriter getPlatformSpecificDateConverter() {
        String specificationVersion = Runtime.class.getPackage().getSpecificationVersion();
        return specificationVersion != null && specificationVersion.startsWith("1.6") ? DateValueReaderWriter.DATE_PARSER_JDK_6 : DateValueReaderWriter.DATE_VALUE_READER_WRITER;
    }
}

