/*
 * Decompiled with CFR 0.152.
 */
package com.github.quiltservertools.libs.com.uchuhimo.konf.source.deserializer;

import com.github.quiltservertools.libs.com.uchuhimo.konf.source.SourceException;
import com.github.quiltservertools.libs.com.uchuhimo.konf.source.UtilsKt;
import com.github.quiltservertools.libs.com.uchuhimo.konf.source.deserializer.JSR310Deserializer;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/github/quiltservertools/libs/com/uchuhimo/konf/source/deserializer/DurationDeserializer;", "Lcom/github/quiltservertools/libs/com/uchuhimo/konf/source/deserializer/JSR310Deserializer;", "Ljava/time/Duration;", "", "string", "parse", "(Ljava/lang/String;)Ljava/time/Duration;", "<init>", "()V", "konf-core"})
public final class DurationDeserializer
extends JSR310Deserializer<Duration> {
    @NotNull
    public static final DurationDeserializer INSTANCE;

    @Override
    @NotNull
    public Duration parse(@NotNull String string) {
        Duration duration;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        try {
            Duration duration2 = Duration.parse(string);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"Duration.parse(string)");
            duration = duration2;
        }
        catch (DateTimeParseException exception) {
            Duration duration3;
            try {
                duration3 = UtilsKt.toDuration(string);
            }
            catch (SourceException _) {
                throw (Throwable)exception;
            }
            duration = duration3;
        }
        return duration;
    }

    private DurationDeserializer() {
        super(Duration.class);
    }

    static {
        DurationDeserializer durationDeserializer;
        INSTANCE = durationDeserializer = new DurationDeserializer();
    }
}

