/*
 * Decompiled with CFR 0.152.
 */
package com.github.quiltservertools.libs.com.uchuhimo.konf.source.json;

import com.github.quiltservertools.libs.com.fasterxml.jackson.databind.JsonNode;
import com.github.quiltservertools.libs.com.uchuhimo.konf.Feature;
import com.github.quiltservertools.libs.com.uchuhimo.konf.TreeNode;
import com.github.quiltservertools.libs.com.uchuhimo.konf.source.Source;
import com.github.quiltservertools.libs.com.uchuhimo.konf.source.SourceInfo;
import com.github.quiltservertools.libs.com.uchuhimo.konf.source.json.JsonSourceKt;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\r\u001a\u00020\f8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lcom/github/quiltservertools/libs/com/uchuhimo/konf/source/json/JsonSource;", "Lcom/github/quiltservertools/libs/com/uchuhimo/konf/source/Source;", "Lcom/github/quiltservertools/libs/com/uchuhimo/konf/source/SourceInfo;", "info", "Lcom/github/quiltservertools/libs/com/uchuhimo/konf/source/SourceInfo;", "getInfo", "()Lcom/uchuhimo/konf/source/SourceInfo;", "Lcom/github/quiltservertools/libs/com/fasterxml/jackson/databind/JsonNode;", "node", "Lcom/github/quiltservertools/libs/com/fasterxml/jackson/databind/JsonNode;", "getNode", "()Lcom/fasterxml/jackson/databind/JsonNode;", "Lcom/github/quiltservertools/libs/com/uchuhimo/konf/TreeNode;", "tree", "Lcom/github/quiltservertools/libs/com/uchuhimo/konf/TreeNode;", "getTree", "()Lcom/uchuhimo/konf/TreeNode;", "<init>", "(Lcom/fasterxml/jackson/databind/JsonNode;)V", "konf-core"})
public final class JsonSource
implements Source {
    @NotNull
    private final SourceInfo info;
    @NotNull
    private final TreeNode tree;
    @NotNull
    private final JsonNode node;

    @Override
    @NotNull
    public SourceInfo getInfo() {
        return this.info;
    }

    @Override
    @NotNull
    public TreeNode getTree() {
        return this.tree;
    }

    @NotNull
    public final JsonNode getNode() {
        return this.node;
    }

    public JsonSource(@NotNull JsonNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.node = node;
        this.info = new SourceInfo(TuplesKt.to((Object)"type", (Object)"JSON"));
        this.tree = JsonSourceKt.toTree(this.node);
    }

    @Override
    @NotNull
    public String getDescription() {
        return Source.DefaultImpls.getDescription(this);
    }

    @Override
    @NotNull
    public Map<Feature, Boolean> getFeatures() {
        return Source.DefaultImpls.getFeatures(this);
    }

    @Override
    public boolean contains(@NotNull List<String> path) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        return Source.DefaultImpls.contains((Source)this, path);
    }

    @Override
    public boolean contains(@NotNull String prefix2) {
        Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix");
        return Source.DefaultImpls.contains((Source)this, prefix2);
    }

    @Override
    @Nullable
    public Source getOrNull(@NotNull List<String> path) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        return Source.DefaultImpls.getOrNull((Source)this, path);
    }

    @Override
    @Nullable
    public Source getOrNull(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return Source.DefaultImpls.getOrNull((Source)this, path);
    }

    @Override
    @Nullable
    public TreeNode getNodeOrNull(@NotNull List<String> path, boolean lowercased, boolean littleCamelCased) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        return Source.DefaultImpls.getNodeOrNull(this, path, lowercased, littleCamelCased);
    }

    @Override
    @NotNull
    public Source get(@NotNull List<String> path) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        return Source.DefaultImpls.get((Source)this, path);
    }

    @Override
    @NotNull
    public Source get(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return Source.DefaultImpls.get((Source)this, path);
    }

    @Override
    @NotNull
    public Source withPrefix(@NotNull List<String> prefix2) {
        Intrinsics.checkNotNullParameter(prefix2, (String)"prefix");
        return Source.DefaultImpls.withPrefix((Source)this, prefix2);
    }

    @Override
    @NotNull
    public Source withPrefix(@NotNull String prefix2) {
        Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix");
        return Source.DefaultImpls.withPrefix((Source)this, prefix2);
    }

    @Override
    @NotNull
    public Source withFallback(@NotNull Source fallback) {
        Intrinsics.checkNotNullParameter((Object)fallback, (String)"fallback");
        return Source.DefaultImpls.withFallback(this, fallback);
    }

    @Override
    @NotNull
    public Source plus(@NotNull Source facade) {
        Intrinsics.checkNotNullParameter((Object)facade, (String)"facade");
        return Source.DefaultImpls.plus(this, facade);
    }

    @Override
    @NotNull
    public Source substituted(@NotNull Source root, boolean enabled2, boolean errorWhenUndefined) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        return Source.DefaultImpls.substituted(this, root, enabled2, errorWhenUndefined);
    }

    @Override
    @NotNull
    public Source lowercased(boolean enabled2) {
        return Source.DefaultImpls.lowercased(this, enabled2);
    }

    @Override
    @NotNull
    public Source littleCamelCased(boolean enabled2) {
        return Source.DefaultImpls.littleCamelCased(this, enabled2);
    }

    @Override
    @NotNull
    public Source normalized(boolean lowercased, boolean littleCamelCased) {
        return Source.DefaultImpls.normalized(this, lowercased, littleCamelCased);
    }

    @Override
    @NotNull
    public Source enabled(@NotNull Feature feature) {
        Intrinsics.checkNotNullParameter((Object)((Object)feature), (String)"feature");
        return Source.DefaultImpls.enabled(this, feature);
    }

    @Override
    @NotNull
    public Source disabled(@NotNull Feature feature) {
        Intrinsics.checkNotNullParameter((Object)((Object)feature), (String)"feature");
        return Source.DefaultImpls.disabled(this, feature);
    }

    @Override
    public boolean isEnabled(@NotNull Feature feature) {
        Intrinsics.checkNotNullParameter((Object)((Object)feature), (String)"feature");
        return Source.DefaultImpls.isEnabled(this, feature);
    }
}

