/*
 * Decompiled with CFR 0.152.
 */
package com.github.quiltservertools.libs.org.reflections.vfs;

import com.github.quiltservertools.libs.org.reflections.ReflectionsException;
import com.github.quiltservertools.libs.org.reflections.vfs.SystemFile;
import com.github.quiltservertools.libs.org.reflections.vfs.Vfs;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collections;

public class SystemDir
implements Vfs.Dir {
    private final File file;

    public SystemDir(File file2) {
        if (!(file2 == null || file2.isDirectory() && file2.canRead())) {
            throw new RuntimeException("cannot use dir " + file2);
        }
        this.file = file2;
    }

    @Override
    public String getPath() {
        if (this.file == null) {
            return "/NO-SUCH-DIRECTORY/";
        }
        return this.file.getPath().replace("\\", "/");
    }

    @Override
    public Iterable<Vfs.File> getFiles() {
        if (this.file == null || !this.file.exists()) {
            return Collections.emptyList();
        }
        return () -> {
            try {
                return Files.walk(this.file.toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(path -> new SystemFile(this, path.toFile())).iterator();
            }
            catch (IOException e) {
                throw new ReflectionsException("could not get files for " + this.file, e);
            }
        };
    }

    @Override
    public void close() {
    }

    public String toString() {
        return this.getPath();
    }
}

