/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.Function;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.TextColumnType;
import org.jetbrains.exposed.sql.vendors.DefaultKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B+\u0012\u0006\u0010\u000e\u001a\u00020\u0002\u0012\u001a\u0010\n\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\t0\b\"\u0006\u0012\u0002\b\u00030\t\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007R#\u0010\n\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\t0\b8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/exposed/sql/Concat;", "Lorg/jetbrains/exposed/sql/Function;", "", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "queryBuilder", "", "toQueryBuilder", "(Lorg/jetbrains/exposed/sql/QueryBuilder;)V", "", "Lorg/jetbrains/exposed/sql/Expression;", "expr", "[Lorg/jetbrains/exposed/sql/Expression;", "getExpr", "()[Lorg/jetbrains/exposed/sql/Expression;", "separator", "Ljava/lang/String;", "getSeparator", "()Ljava/lang/String;", "<init>", "(Ljava/lang/String;[Lorg/jetbrains/exposed/sql/Expression;)V", "exposed-core"})
public final class Concat
extends Function<String> {
    @NotNull
    private final String separator;
    @NotNull
    private final Expression<?>[] expr;

    public Concat(@NotNull String separator, Expression<?> ... expr) {
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        Intrinsics.checkNotNullParameter(expr, (String)"expr");
        super(new TextColumnType(null, false, 3, null));
        this.separator = separator;
        this.expr = expr;
    }

    @NotNull
    public final String getSeparator() {
        return this.separator;
    }

    @NotNull
    public final Expression<?>[] getExpr() {
        return this.expr;
    }

    @Override
    public void toQueryBuilder(@NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        Expression<?>[] expressionArray = this.expr;
        DefaultKt.getCurrentDialect().getFunctionProvider().concat(this.separator, queryBuilder, Arrays.copyOf(expressionArray, expressionArray.length));
    }
}

