/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.exceptions.UnsupportedByDialectException;
import org.jetbrains.exposed.sql.SchemaKt;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DefaultKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0016\u0018\u00002\u00020\u0001BW\u0012\u0006\u0010\u001c\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b \u0010!J\u0013\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0005R\u0019\u0010\b\u001a\u0004\u0018\u00010\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\r\u001a\u0004\u0018\u00010\f8\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0005R\u0011\u0010\u0015\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0019\u0010\u0016\u001a\u0004\u0018\u00010\u00078\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\t\u001a\u0004\b\u0017\u0010\u000bR\u0019\u0010\u0018\u001a\u0004\u0018\u00010\u00078\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\t\u001a\u0004\b\u0019\u0010\u000bR\u0019\u0010\u001a\u001a\u0004\u0018\u00010\u00078\u0006\u00a2\u0006\f\n\u0004\b\u001a\u0010\t\u001a\u0004\b\u001b\u0010\u000bR\u0014\u0010\u001c\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0019\u0010\u001e\u001a\u0004\u0018\u00010\u00078\u0006\u00a2\u0006\f\n\u0004\b\u001e\u0010\t\u001a\u0004\b\u001f\u0010\u000b\u00a8\u0006\""}, d2={"Lorg/jetbrains/exposed/sql/Sequence;", "", "", "", "createStatement", "()Ljava/util/List;", "dropStatement", "", "cache", "Ljava/lang/Long;", "getCache", "()Ljava/lang/Long;", "", "cycle", "Ljava/lang/Boolean;", "getCycle", "()Ljava/lang/Boolean;", "getDdl", "ddl", "getIdentifier", "()Ljava/lang/String;", "identifier", "incrementBy", "getIncrementBy", "maxValue", "getMaxValue", "minValue", "getMinValue", "name", "Ljava/lang/String;", "startWith", "getStartWith", "<init>", "(Ljava/lang/String;Ljava/lang/Long;Ljava/lang/Long;Ljava/lang/Long;Ljava/lang/Long;Ljava/lang/Boolean;Ljava/lang/Long;)V", "exposed-core"})
public final class Sequence {
    @NotNull
    private final String name;
    @Nullable
    private final Long startWith;
    @Nullable
    private final Long incrementBy;
    @Nullable
    private final Long minValue;
    @Nullable
    private final Long maxValue;
    @Nullable
    private final Boolean cycle;
    @Nullable
    private final Long cache;

    public Sequence(@NotNull String name, @Nullable Long startWith, @Nullable Long incrementBy, @Nullable Long minValue, @Nullable Long maxValue, @Nullable Boolean cycle, @Nullable Long cache) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.startWith = startWith;
        this.incrementBy = incrementBy;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.cycle = cycle;
        this.cache = cache;
    }

    public /* synthetic */ Sequence(String string, Long l, Long l2, Long l3, Long l4, Boolean bl, Long l5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = null;
        }
        if ((n & 4) != 0) {
            l2 = null;
        }
        if ((n & 8) != 0) {
            l3 = null;
        }
        if ((n & 0x10) != 0) {
            l4 = null;
        }
        if ((n & 0x20) != 0) {
            bl = null;
        }
        if ((n & 0x40) != 0) {
            l5 = null;
        }
        this(string, l, l2, l3, l4, bl, l5);
    }

    @Nullable
    public final Long getStartWith() {
        return this.startWith;
    }

    @Nullable
    public final Long getIncrementBy() {
        return this.incrementBy;
    }

    @Nullable
    public final Long getMinValue() {
        return this.minValue;
    }

    @Nullable
    public final Long getMaxValue() {
        return this.maxValue;
    }

    @Nullable
    public final Boolean getCycle() {
        return this.cycle;
    }

    @Nullable
    public final Long getCache() {
        return this.cache;
    }

    @NotNull
    public final String getIdentifier() {
        return TransactionManager.Companion.current().getDb().getIdentifierManager().cutIfNecessaryAndQuote(this.name);
    }

    @NotNull
    public final List<String> getDdl() {
        return this.createStatement();
    }

    @NotNull
    public final List<String> createStatement() {
        StringBuilder stringBuilder;
        if (!DefaultKt.getCurrentDialect().getSupportsCreateSequence()) {
            throw new UnsupportedByDialectException("The current dialect doesn't support create sequence statement", DefaultKt.getCurrentDialect());
        }
        StringBuilder $this$createStatement_u24lambda_u2d0 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$createStatement_u24lambda_u2d0.append("CREATE SEQUENCE ");
        if (DefaultKt.getCurrentDialect().getSupportsIfNotExists()) {
            $this$createStatement_u24lambda_u2d0.append("IF NOT EXISTS ");
        }
        $this$createStatement_u24lambda_u2d0.append(this.getIdentifier());
        SchemaKt.appendIfNotNull($this$createStatement_u24lambda_u2d0, " START WITH", this.startWith);
        SchemaKt.appendIfNotNull($this$createStatement_u24lambda_u2d0, " INCREMENT BY", this.incrementBy);
        SchemaKt.appendIfNotNull($this$createStatement_u24lambda_u2d0, " MINVALUE", this.minValue);
        SchemaKt.appendIfNotNull($this$createStatement_u24lambda_u2d0, " MAXVALUE", this.maxValue);
        if (Intrinsics.areEqual((Object)this.cycle, (Object)true)) {
            $this$createStatement_u24lambda_u2d0.append(" CYCLE");
        }
        SchemaKt.appendIfNotNull($this$createStatement_u24lambda_u2d0, " CACHE", this.cache);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String createSequenceDDL = string;
        return CollectionsKt.listOf((Object)createSequenceDDL);
    }

    @NotNull
    public final List<String> dropStatement() {
        StringBuilder stringBuilder;
        if (!DefaultKt.getCurrentDialect().getSupportsCreateSequence()) {
            throw new UnsupportedByDialectException("The current dialect doesn't support drop sequence statement", DefaultKt.getCurrentDialect());
        }
        StringBuilder $this$dropStatement_u24lambda_u2d1 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$dropStatement_u24lambda_u2d1.append("DROP SEQUENCE ");
        if (DefaultKt.getCurrentDialect().getSupportsIfNotExists()) {
            $this$dropStatement_u24lambda_u2d1.append("IF EXISTS ");
        }
        $this$dropStatement_u24lambda_u2d1.append(this.getIdentifier());
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String dropSequenceDDL = string;
        return CollectionsKt.listOf((Object)dropSequenceDDL);
    }
}

