/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.internal.LowPriorityInOverloadResolution;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.dao.id.EntityID;
import org.jetbrains.exposed.sql.AliasKt;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.CompositeColumn;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.Query;
import org.jetbrains.exposed.sql.SqlExpressionBuilder;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.statements.Statement;
import org.jetbrains.exposed.sql.statements.StatementType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\b\u0012\u0004\u0012\u00028\u00000\u0002B\u001d\u0012\u0006\u0010/\u001a\u00020.\u0012\f\u00102\u001a\b\u0012\u0004\u0012\u00020100\u00a2\u0006\u0004\b3\u00104J\u001b\u0010\u0006\u001a\u00020\u00052\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\t\u001a\u00020\b2\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0096\u0002\u00a2\u0006\u0004\b\t\u0010\nJL\u0010\u0013\u001a\u00020\u0005\"\u0004\b\u0001\u0010\u000b\"\u000e\b\u0002\u0010\r*\b\u0012\u0004\u0012\u00028\u00010\f\"\u000e\b\u0003\u0010\u000f*\b\u0012\u0004\u0012\u00028\u00010\u000e2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00020\u00032\u0006\u0010\u0010\u001a\u00028\u0003H\u0087\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012JF\u0010\u0013\u001a\u00020\u0005\"\u000e\b\u0001\u0010\u000b*\b\u0012\u0004\u0012\u00028\u00010\u0014\"\u000e\b\u0002\u0010\r*\b\u0012\u0004\u0012\u00028\u00010\f2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00020\u00032\u0006\u0010\u0010\u001a\u00028\u0001H\u0087\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J,\u0010\u0013\u001a\u00020\u0005\"\u0004\b\u0001\u0010\u000b2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u00032\u0006\u0010\u0010\u001a\u00028\u0001H\u0097\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0017J,\u0010\u0013\u001a\u00020\u0005\"\u0004\b\u0001\u0010\u000b2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u00032\u0006\u0010\u0010\u001a\u00020\u0018H\u0096\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0019JF\u0010\u0013\u001a\u00020\u0005\"\u0004\b\u0001\u0010\u0001\"\b\b\u0002\u0010\u000b*\u00028\u0001\"\u000e\b\u0003\u0010\u000f*\b\u0012\u0004\u0012\u00028\u00020\u000e2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u00032\u0006\u0010\u0010\u001a\u00028\u0003H\u0096\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0012J@\u0010\u0013\u001a\u00020\u0005\"\u000e\b\u0001\u0010\u000b*\b\u0012\u0004\u0012\u00028\u00010\u00142\u0014\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\f0\u00032\b\u0010\u0010\u001a\u0004\u0018\u00018\u0001H\u0087\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0016J0\u0010\u0013\u001a\u00020\u0005\"\b\b\u0001\u0010\u000b*\u00020\u001b2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u001c2\u0006\u0010\u0010\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u0013\u0010\u001dJ=\u0010\u001e\u001a\u00020\u0005\"\u0004\b\u0001\u0010\u0001\"\n\b\u0002\u0010\u000b*\u0004\u0018\u00018\u00012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u00032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u0012JN\u0010\u001e\u001a\u00020\u0005\"\u0004\b\u0001\u0010\u0001\"\n\b\u0002\u0010\u000b*\u0004\u0018\u00018\u00012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u00032\u001d\u0010\u0010\u001a\u0019\u0012\u0004\u0012\u00020 \u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00020\u000e0\u001f\u00a2\u0006\u0002\b!H\u0016\u00a2\u0006\u0004\b\u001e\u0010\"R\"\u0010#\u001a\u00020\b8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R,\u0010*\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u001b0)8\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-\u00a8\u00065"}, d2={"Lorg/jetbrains/exposed/sql/statements/UpdateBuilder;", "T", "Lorg/jetbrains/exposed/sql/statements/Statement;", "Lorg/jetbrains/exposed/sql/Column;", "column", "", "checkThatExpressionWasNotSetInPreviousBatch", "(Lorg/jetbrains/exposed/sql/Column;)V", "", "contains", "(Lorg/jetbrains/exposed/sql/Column;)Z", "S", "Lorg/jetbrains/exposed/dao/id/EntityID;", "ID", "Lorg/jetbrains/exposed/sql/Expression;", "E", "value", "setWithEntityIdExpression", "(Lorg/jetbrains/exposed/sql/Column;Lorg/jetbrains/exposed/sql/Expression;)V", "set", "", "setWithEntityIdValue", "(Lorg/jetbrains/exposed/sql/Column;Ljava/lang/Comparable;)V", "(Lorg/jetbrains/exposed/sql/Column;Ljava/lang/Object;)V", "Lorg/jetbrains/exposed/sql/Query;", "(Lorg/jetbrains/exposed/sql/Column;Lorg/jetbrains/exposed/sql/Query;)V", "setWithNullableEntityIdValue", "", "Lorg/jetbrains/exposed/sql/CompositeColumn;", "(Lorg/jetbrains/exposed/sql/CompositeColumn;Ljava/lang/Object;)V", "update", "Lkotlin/Function1;", "Lorg/jetbrains/exposed/sql/SqlExpressionBuilder;", "Lkotlin/ExtensionFunctionType;", "(Lorg/jetbrains/exposed/sql/Column;Lkotlin/jvm/functions/Function1;)V", "hasBatchedValues", "Z", "getHasBatchedValues", "()Z", "setHasBatchedValues", "(Z)V", "", "values", "Ljava/util/Map;", "getValues", "()Ljava/util/Map;", "Lorg/jetbrains/exposed/sql/statements/StatementType;", "type", "", "Lorg/jetbrains/exposed/sql/Table;", "targets", "<init>", "(Lorg/jetbrains/exposed/sql/statements/StatementType;Ljava/util/List;)V", "exposed-core"})
public abstract class UpdateBuilder<T>
extends Statement<T> {
    @NotNull
    private final Map<Column<?>, Object> values;
    private boolean hasBatchedValues;

    public UpdateBuilder(@NotNull StatementType type, @NotNull List<? extends Table> targets) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        super(type, targets);
        this.values = new LinkedHashMap();
    }

    @NotNull
    protected final Map<Column<?>, Object> getValues() {
        return this.values;
    }

    public boolean contains(@NotNull Column<?> column) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        return this.values.containsKey(column);
    }

    protected final boolean getHasBatchedValues() {
        return this.hasBatchedValues;
    }

    protected final void setHasBatchedValues(boolean bl) {
        this.hasBatchedValues = bl;
    }

    private final void checkThatExpressionWasNotSetInPreviousBatch(Column<?> column) {
        if (!(!this.values.containsKey(column) || !this.hasBatchedValues)) {
            boolean bl = false;
            String string = column + " is already initialized in a batch";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @LowPriorityInOverloadResolution
    public <S> void set(@NotNull Column<S> column, S value2) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        if (!(column.getColumnType().getNullable() || value2 != null && !(value2 instanceof Op.NULL))) {
            boolean bl = false;
            String string = "Trying to set null to not nullable column " + column;
            throw new IllegalArgumentException(string.toString());
        }
        column.getColumnType().validateValueBeforeUpdate(value2);
        this.values.put(column, value2);
    }

    @JvmName(name="setWithEntityIdValue")
    public final <S extends Comparable<? super S>, ID extends EntityID<S>> void setWithEntityIdValue(@NotNull Column<ID> column, @NotNull S value2) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        column.getColumnType().validateValueBeforeUpdate(value2);
        this.values.put(column, value2);
    }

    @JvmName(name="setWithNullableEntityIdValue")
    public final <S extends Comparable<? super S>> void setWithNullableEntityIdValue(@NotNull Column<EntityID<S>> column, @Nullable S value2) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        if (!(column.getColumnType().getNullable() || value2 != null)) {
            boolean bl = false;
            String string = "Trying to set null to not nullable column " + column;
            throw new IllegalArgumentException(string.toString());
        }
        column.getColumnType().validateValueBeforeUpdate(value2);
        this.values.put(column, value2);
    }

    @JvmName(name="setWithEntityIdExpression")
    public final <S, ID extends EntityID<S>, E extends Expression<S>> void setWithEntityIdExpression(@NotNull Column<ID> column, @NotNull E value2) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        if (!(column.getColumnType().getNullable() || !(value2 instanceof Op.NULL))) {
            boolean bl = false;
            String string = "Trying to set null to not nullable column " + column;
            throw new IllegalArgumentException(string.toString());
        }
        this.checkThatExpressionWasNotSetInPreviousBatch(column);
        column.getColumnType().validateValueBeforeUpdate(value2);
        this.values.put(column, value2);
    }

    public <T, S extends T, E extends Expression<S>> void set(@NotNull Column<T> column, @NotNull E value2) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        this.update(column, value2);
    }

    public <S> void set(@NotNull Column<S> column, @NotNull Query value2) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.update(column, AliasKt.wrapAsExpression(value2));
    }

    public <S> void set(@NotNull CompositeColumn<S> column, @NotNull S value2) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        Map<Column<?>, Object> $this$forEach$iv = column.getRealColumnsWithValues(value2);
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Column<?>, Object>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Column<?>, Object> element$iv;
            Map.Entry<Column<?>, Object> entry = element$iv = iterator2.next();
            boolean bl = false;
            Column<?> realColumn = entry.getKey();
            Object itsValue = entry.getValue();
            this.set(realColumn, (Expression)itsValue);
        }
    }

    public <T, S extends T> void update(@NotNull Column<T> column, @NotNull Expression<S> value2) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        this.checkThatExpressionWasNotSetInPreviousBatch(column);
        column.getColumnType().validateValueBeforeUpdate(value2);
        this.values.put(column, value2);
    }

    public <T, S extends T> void update(@NotNull Column<T> column, @NotNull Function1<? super SqlExpressionBuilder, ? extends Expression<S>> value2) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        this.update(column, (Expression)value2.invoke((Object)SqlExpressionBuilder.INSTANCE));
    }
}

