/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnDiff;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ForeignKeyConstraint;
import org.jetbrains.exposed.sql.Index;
import org.jetbrains.exposed.sql.LiteralOp;
import org.jetbrains.exposed.sql.ReferenceOption;
import org.jetbrains.exposed.sql.Schema;
import org.jetbrains.exposed.sql.SchemaKt;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.vendors.ColumnMetadata;
import org.jetbrains.exposed.sql.vendors.DataTypeProvider;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.FunctionProvider;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001b\bf\u0018\u00002\u00020\u0001J\u0015\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H&\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\b\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJY\u0010\u0017\u001a8\u0012(\u0012&\u0012\u0004\u0012\u00020\n\u0012\u001c\u0012\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u0013j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0014`\u00150\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00020\u00112\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u000f\"\u00020\nH\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u001cH&\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010\"\u001a\u00020\u00032\u0006\u0010!\u001a\u00020 H\u0016\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010$\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b$\u0010\u001bJ\u001f\u0010'\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0003H&\u00a2\u0006\u0004\b'\u0010(J\u001f\u0010*\u001a\u00020\u00032\u0006\u0010!\u001a\u00020 2\u0006\u0010)\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b*\u0010+J5\u0010,\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u00020\u00112\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u000f\"\u00020\nH\u0016\u00a2\u0006\u0004\b,\u0010\u0018J\u000f\u0010-\u001a\u00020\u0003H&\u00a2\u0006\u0004\b-\u0010.J\u001b\u00101\u001a\u00020\f2\n\u00100\u001a\u0006\u0012\u0002\b\u00030/H\u0016\u00a2\u0006\u0004\b1\u00102J)\u00106\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\n\u00103\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u00105\u001a\u000204H&\u00a2\u0006\u0004\b6\u00107J\u000f\u00109\u001a\u000208H&\u00a2\u0006\u0004\b9\u0010:J\u000f\u0010;\u001a\u000208H&\u00a2\u0006\u0004\b;\u0010:J\u0017\u0010<\u001a\u00020\f2\u0006\u0010!\u001a\u00020 H&\u00a2\u0006\u0004\b<\u0010=J\u0017\u0010>\u001a\u00020\u00032\u0006\u0010!\u001a\u00020 H\u0016\u00a2\u0006\u0004\b>\u0010#J\u000f\u0010?\u001a\u00020\fH&\u00a2\u0006\u0004\b?\u0010@J5\u0010B\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020A0\u00020\u00112\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u000f\"\u00020\nH\u0016\u00a2\u0006\u0004\bB\u0010\u0018J\u0017\u0010C\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH&\u00a2\u0006\u0004\bC\u0010\u000eR\u0014\u0010G\u001a\u00020D8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bE\u0010FR\u0014\u0010K\u001a\u00020H8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bI\u0010JR\u0014\u0010O\u001a\u00020L8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bM\u0010NR\u0014\u0010\u0019\u001a\u00020\u00038&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bP\u0010.R\u0014\u0010R\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bQ\u0010@R\u0014\u0010T\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bS\u0010@R\u0014\u0010V\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bU\u0010@R\u0014\u0010X\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bW\u0010@R\u0014\u0010Z\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bY\u0010@R\u0014\u0010\\\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b[\u0010@R\u0014\u0010^\u001a\u00020\f8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b]\u0010@R\u0014\u0010`\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b_\u0010@R\u0014\u0010b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\ba\u0010@R\u0014\u0010d\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bc\u0010@R\u0014\u0010f\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\be\u0010@\u00a8\u0006g"}, d2={"Lorg/jetbrains/exposed/sql/vendors/DatabaseDialect;", "", "", "", "allTablesNames", "()Ljava/util/List;", "Lorg/jetbrains/exposed/sql/Transaction;", "transaction", "catalog", "(Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/String;", "Lorg/jetbrains/exposed/sql/Table;", "table", "", "checkTableMapping", "(Lorg/jetbrains/exposed/sql/Table;)Z", "", "tables", "", "Lkotlin/Pair;", "Ljava/util/LinkedHashSet;", "Lorg/jetbrains/exposed/sql/Column;", "Lkotlin/collections/LinkedHashSet;", "Lorg/jetbrains/exposed/sql/ForeignKeyConstraint;", "columnConstraints", "([Lorg/jetbrains/exposed/sql/Table;)Ljava/util/Map;", "name", "createDatabase", "(Ljava/lang/String;)Ljava/lang/String;", "Lorg/jetbrains/exposed/sql/Index;", "index", "createIndex", "(Lorg/jetbrains/exposed/sql/Index;)Ljava/lang/String;", "Lorg/jetbrains/exposed/sql/Schema;", "schema", "createSchema", "(Lorg/jetbrains/exposed/sql/Schema;)Ljava/lang/String;", "dropDatabase", "tableName", "indexName", "dropIndex", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "cascade", "dropSchema", "(Lorg/jetbrains/exposed/sql/Schema;Z)Ljava/lang/String;", "existingIndices", "getDatabase", "()Ljava/lang/String;", "Lorg/jetbrains/exposed/sql/Expression;", "e", "isAllowedAsColumnDefault", "(Lorg/jetbrains/exposed/sql/Expression;)Z", "column", "Lorg/jetbrains/exposed/sql/ColumnDiff;", "columnDiff", "modifyColumn", "(Lorg/jetbrains/exposed/sql/Column;Lorg/jetbrains/exposed/sql/ColumnDiff;)Ljava/util/List;", "", "resetCaches", "()V", "resetSchemaCaches", "schemaExists", "(Lorg/jetbrains/exposed/sql/Schema;)Z", "setSchema", "supportsSelectForUpdate", "()Z", "Lorg/jetbrains/exposed/sql/vendors/ColumnMetadata;", "tableColumns", "tableExists", "Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "getDataTypeProvider", "()Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "dataTypeProvider", "Lorg/jetbrains/exposed/sql/ReferenceOption;", "getDefaultReferenceOption", "()Lorg/jetbrains/exposed/sql/ReferenceOption;", "defaultReferenceOption", "Lorg/jetbrains/exposed/sql/vendors/FunctionProvider;", "getFunctionProvider", "()Lorg/jetbrains/exposed/sql/vendors/FunctionProvider;", "functionProvider", "getName", "getNeedsQuotesWhenSymbolsInNames", "needsQuotesWhenSymbolsInNames", "getNeedsSequenceToAutoInc", "needsSequenceToAutoInc", "getSupportsCreateSchema", "supportsCreateSchema", "getSupportsCreateSequence", "supportsCreateSequence", "getSupportsDualTableConcept", "supportsDualTableConcept", "getSupportsIfNotExists", "supportsIfNotExists", "getSupportsMultipleGeneratedKeys", "supportsMultipleGeneratedKeys", "getSupportsOnlyIdentifiersInGeneratedKeys", "supportsOnlyIdentifiersInGeneratedKeys", "getSupportsOrderByNullsFirstLast", "supportsOrderByNullsFirstLast", "getSupportsSequenceAsGeneratedKeys", "supportsSequenceAsGeneratedKeys", "getSupportsSubqueryUnions", "supportsSubqueryUnions", "exposed-core"})
public interface DatabaseDialect {
    @NotNull
    public String getName();

    @NotNull
    public DataTypeProvider getDataTypeProvider();

    @NotNull
    public FunctionProvider getFunctionProvider();

    public boolean getSupportsIfNotExists();

    public boolean getSupportsCreateSequence();

    public boolean getNeedsSequenceToAutoInc();

    @NotNull
    public ReferenceOption getDefaultReferenceOption();

    public boolean getNeedsQuotesWhenSymbolsInNames();

    public boolean getSupportsMultipleGeneratedKeys();

    public boolean getSupportsSequenceAsGeneratedKeys();

    public boolean getSupportsOnlyIdentifiersInGeneratedKeys();

    public boolean getSupportsCreateSchema();

    public boolean getSupportsSubqueryUnions();

    public boolean getSupportsDualTableConcept();

    public boolean getSupportsOrderByNullsFirstLast();

    @NotNull
    public String getDatabase();

    @NotNull
    public List<String> allTablesNames();

    public boolean tableExists(@NotNull Table var1);

    public boolean schemaExists(@NotNull Schema var1);

    public boolean checkTableMapping(@NotNull Table var1);

    @NotNull
    public Map<Table, List<ColumnMetadata>> tableColumns(Table ... var1);

    @NotNull
    public Map<Pair<Table, LinkedHashSet<Column<?>>>, List<ForeignKeyConstraint>> columnConstraints(Table ... var1);

    @NotNull
    public Map<Table, List<Index>> existingIndices(Table ... var1);

    public boolean supportsSelectForUpdate();

    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> var1);

    @NotNull
    public String catalog(@NotNull Transaction var1);

    public void resetCaches();

    public void resetSchemaCaches();

    @NotNull
    public String createIndex(@NotNull Index var1);

    @NotNull
    public String dropIndex(@NotNull String var1, @NotNull String var2);

    @NotNull
    public List<String> modifyColumn(@NotNull Column<?> var1, @NotNull ColumnDiff var2);

    @NotNull
    public String createDatabase(@NotNull String var1);

    @NotNull
    public String dropDatabase(@NotNull String var1);

    @NotNull
    public String setSchema(@NotNull Schema var1);

    @NotNull
    public String createSchema(@NotNull Schema var1);

    @NotNull
    public String dropSchema(@NotNull Schema var1, boolean var2);

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static boolean getSupportsIfNotExists(@NotNull DatabaseDialect this_) {
            return true;
        }

        public static boolean getSupportsCreateSequence(@NotNull DatabaseDialect this_) {
            return true;
        }

        public static boolean getNeedsSequenceToAutoInc(@NotNull DatabaseDialect this_) {
            return false;
        }

        @NotNull
        public static ReferenceOption getDefaultReferenceOption(@NotNull DatabaseDialect this_) {
            return ReferenceOption.RESTRICT;
        }

        public static boolean getNeedsQuotesWhenSymbolsInNames(@NotNull DatabaseDialect this_) {
            return true;
        }

        public static boolean getSupportsSequenceAsGeneratedKeys(@NotNull DatabaseDialect this_) {
            return this_.getSupportsCreateSequence();
        }

        public static boolean getSupportsOnlyIdentifiersInGeneratedKeys(@NotNull DatabaseDialect this_) {
            return false;
        }

        public static boolean getSupportsCreateSchema(@NotNull DatabaseDialect this_) {
            return true;
        }

        public static boolean getSupportsSubqueryUnions(@NotNull DatabaseDialect this_) {
            return false;
        }

        public static boolean getSupportsDualTableConcept(@NotNull DatabaseDialect this_) {
            return false;
        }

        public static boolean getSupportsOrderByNullsFirstLast(@NotNull DatabaseDialect this_) {
            return false;
        }

        public static boolean checkTableMapping(@NotNull DatabaseDialect this_, @NotNull Table table) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            return true;
        }

        @NotNull
        public static Map<Table, List<ColumnMetadata>> tableColumns(@NotNull DatabaseDialect this_, Table ... tables) {
            Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
            return MapsKt.emptyMap();
        }

        @NotNull
        public static Map<Pair<Table, LinkedHashSet<Column<?>>>, List<ForeignKeyConstraint>> columnConstraints(@NotNull DatabaseDialect this_, Table ... tables) {
            Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
            return MapsKt.emptyMap();
        }

        @NotNull
        public static Map<Table, List<Index>> existingIndices(@NotNull DatabaseDialect this_, Table ... tables) {
            Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
            return MapsKt.emptyMap();
        }

        public static boolean isAllowedAsColumnDefault(@NotNull DatabaseDialect this_, @NotNull Expression<?> e) {
            Intrinsics.checkNotNullParameter(e, (String)"e");
            return e instanceof LiteralOp;
        }

        @NotNull
        public static String catalog(@NotNull DatabaseDialect this_, @NotNull Transaction transaction2) {
            Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
            return transaction2.getConnection().getCatalog();
        }

        @NotNull
        public static String createDatabase(@NotNull DatabaseDialect this_, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return "CREATE DATABASE IF NOT EXISTS " + DefaultKt.inProperCase(name);
        }

        @NotNull
        public static String dropDatabase(@NotNull DatabaseDialect this_, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return "DROP DATABASE IF EXISTS " + DefaultKt.inProperCase(name);
        }

        @NotNull
        public static String setSchema(@NotNull DatabaseDialect this_, @NotNull Schema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            return "SET SCHEMA " + schema.getIdentifier();
        }

        @NotNull
        public static String createSchema(@NotNull DatabaseDialect this_, @NotNull Schema schema) {
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            StringBuilder $this$createSchema_u24lambda_u2d0 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$createSchema_u24lambda_u2d0.append("CREATE SCHEMA IF NOT EXISTS ");
            $this$createSchema_u24lambda_u2d0.append(schema.getIdentifier());
            SchemaKt.appendIfNotNull($this$createSchema_u24lambda_u2d0, " AUTHORIZATION ", schema.getAuthorization());
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            return string;
        }

        @NotNull
        public static String dropSchema(@NotNull DatabaseDialect this_, @NotNull Schema schema, boolean cascade) {
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            StringBuilder $this$dropSchema_u24lambda_u2d1 = stringBuilder = new StringBuilder();
            boolean bl = false;
            String[] stringArray = new String[]{"DROP SCHEMA IF EXISTS ", schema.getIdentifier()};
            StringsKt.append((StringBuilder)$this$dropSchema_u24lambda_u2d1, (String[])stringArray);
            if (cascade) {
                $this$dropSchema_u24lambda_u2d1.append(" CASCADE");
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            return string;
        }
    }
}

