/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.exceptions.ExceptionsKt;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionKt;
import org.jetbrains.exposed.sql.Index;
import org.jetbrains.exposed.sql.Join;
import org.jetbrains.exposed.sql.JoinType;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.Sequence;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.FunctionProvider;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.H2FunctionProvider;
import org.jetbrains.exposed.sql.vendors.H2Kt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b$\u0010%JA\u0010\r\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0010\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J?\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u001e\u0010\u0018\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00160\u00062\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJY\u0010\"\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001b2\u001e\u0010\u001d\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00160\u00062\b\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\u000e\u0010!\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010 2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\"\u0010#\u00a8\u0006&"}, d2={"Lorg/jetbrains/exposed/sql/vendors/H2FunctionProvider;", "Lorg/jetbrains/exposed/sql/vendors/FunctionProvider;", "", "ignore", "Lorg/jetbrains/exposed/sql/Table;", "table", "", "Lorg/jetbrains/exposed/sql/Column;", "columns", "", "expr", "Lorg/jetbrains/exposed/sql/Transaction;", "transaction", "insert", "(ZLorg/jetbrains/exposed/sql/Table;Ljava/util/List;Ljava/lang/String;Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/String;", "Lorg/jetbrains/exposed/sql/Sequence;", "seq", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "builder", "", "nextVal", "(Lorg/jetbrains/exposed/sql/Sequence;Lorg/jetbrains/exposed/sql/QueryBuilder;)V", "Lkotlin/Pair;", "", "data", "replace", "(Lorg/jetbrains/exposed/sql/Table;Ljava/util/List;Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/String;", "Lorg/jetbrains/exposed/sql/Join;", "targets", "columnsAndValues", "", "limit", "Lorg/jetbrains/exposed/sql/Op;", "where", "update", "(Lorg/jetbrains/exposed/sql/Join;Ljava/util/List;Ljava/lang/Integer;Lorg/jetbrains/exposed/sql/Op;Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/String;", "<init>", "()V", "exposed-core"})
public final class H2FunctionProvider
extends FunctionProvider {
    @NotNull
    public static final H2FunctionProvider INSTANCE = new H2FunctionProvider();

    private H2FunctionProvider() {
    }

    @Override
    public void nextVal(@NotNull Sequence seq, @NotNull QueryBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)seq, (String)"seq");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        switch (WhenMappings.$EnumSwitchMapping$0[((H2Dialect)TransactionManager.Companion.current().getDb().getDialect()).getMajorVersion$exposed_core().ordinal()]) {
            case 1: {
                super.nextVal(seq, builder);
                break;
            }
            case 2: {
                builder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)new Function1<QueryBuilder, Unit>(seq){
                    final /* synthetic */ Sequence $seq;
                    {
                        this.$seq = $seq;
                        super(1);
                    }

                    public final void invoke(@NotNull QueryBuilder $this$invoke) {
                        Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                        $this$invoke.append("NEXT VALUE FOR " + this.$seq.getIdentifier());
                    }
                }));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String insert(boolean ignore, @NotNull Table table, @NotNull List<? extends Column<?>> columns2, @NotNull String expr, @NotNull Transaction transaction2) {
        String string;
        void $this$flatMapTo$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter(columns2, (String)"columns");
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
        Set uniqueCols = new LinkedHashSet();
        Iterable $this$filter$iv = table.getIndices();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Index it = (Index)element$iv$iv;
            boolean bl = false;
            if (!it.getUnique()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            Index it = (Index)element$iv;
            boolean bl = false;
            Iterable list$iv = it.getColumns();
            CollectionsKt.addAll((Collection)uniqueCols, (Iterable)list$iv);
        }
        Object[] objectArray = table.getPrimaryKey();
        if (objectArray != null && (objectArray = objectArray.getColumns()) != null) {
            Object[] primaryKeys = objectArray;
            boolean bl = false;
            CollectionsKt.addAll((Collection)uniqueCols, (Object[])primaryKeys);
        }
        String version2 = ((H2Dialect)transaction2.getDb().getDialect()).getVersion$exposed_core();
        if (ignore && !((Collection)uniqueCols).isEmpty() && H2Kt.access$isMySQLMode(transaction2) && version2.compareTo("1.4.197") < 0) {
            String def = super.insert(false, table, columns2, expr, transaction2);
            string = def + " ON DUPLICATE KEY UPDATE " + CollectionsKt.joinToString$default((Iterable)uniqueCols, null, null, null, (int)0, null, (Function1)new Function1<Column<?>, CharSequence>(transaction2){
                final /* synthetic */ Transaction $transaction;
                {
                    this.$transaction = $transaction;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull Column<?> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    return this.$transaction.identity(it) + "=VALUES(" + this.$transaction.identity(it) + ')';
                }
            }, (int)31, null);
        } else if (ignore && !((Collection)uniqueCols).isEmpty() && H2Kt.access$isMySQLMode(transaction2)) {
            string = StringsKt.replace$default((String)super.insert(false, table, columns2, expr, transaction2), (String)"INSERT", (String)"INSERT IGNORE", (boolean)false, (int)4, null);
        } else {
            if (ignore) {
                ExceptionsKt.throwUnsupportedException(transaction2, "INSERT IGNORE supported only on H2 v1.4.197+ with MODE=MYSQL.");
                throw new KotlinNothingValueException();
            }
            string = super.insert(ignore, table, columns2, expr, transaction2);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String update(@NotNull Join targets, @NotNull List<? extends Pair<? extends Column<?>, ? extends Object>> columnsAndValues, @Nullable Integer limit, @Nullable Op<Boolean> where, @NotNull Transaction transaction2) {
        QueryBuilder $this$update_u24lambda_u2d7;
        block11: {
            Join.JoinPart it;
            boolean bl;
            Table tableToUpdate;
            block10: {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)targets, (String)"targets");
                Intrinsics.checkNotNullParameter(columnsAndValues, (String)"columnsAndValues");
                Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
                $this$update_u24lambda_u2d7 = new QueryBuilder(true);
                boolean bl2 = false;
                if (limit != null) {
                    ExceptionsKt.throwUnsupportedException(transaction2, "H2 doesn't support LIMIT in UPDATE with join clause.");
                    throw new KotlinNothingValueException();
                }
                Iterable $this$map$iv = columnsAndValues;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    Pair pair = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(((Column)it2.getFirst()).getTable());
                }
                Table table = (Table)CollectionsKt.singleOrNull((List)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
                if (table == null) {
                    ExceptionsKt.throwUnsupportedException(transaction2, "H2 supports a join updates with a single table columns to update.");
                    throw new KotlinNothingValueException();
                }
                tableToUpdate = table;
                Iterable $this$any$iv = targets.getJoinParts$exposed_core();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (Join.JoinPart)element$iv;
                        boolean bl4 = false;
                        if (!(it.getJoinType() != JoinType.INNER)) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
            }
            if (bl) {
                SQLLogKt.getExposedLogger().warn("All tables in UPDATE statement will be joined with inner join");
            }
            $this$update_u24lambda_u2d7.unaryPlus("MERGE INTO ");
            tableToUpdate.describe(transaction2, $this$update_u24lambda_u2d7);
            $this$update_u24lambda_u2d7.unaryPlus(" USING ");
            if (!Intrinsics.areEqual((Object)targets.getTable(), (Object)tableToUpdate)) {
                targets.getTable().describe(transaction2, $this$update_u24lambda_u2d7);
            }
            Iterable $this$forEach$iv = targets.getJoinParts$exposed_core();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Join.JoinPart)element$iv;
                boolean bl5 = false;
                if (!Intrinsics.areEqual((Object)it.getJoinPart(), (Object)tableToUpdate)) {
                    it.getJoinPart().describe(transaction2, $this$update_u24lambda_u2d7);
                }
                $this$update_u24lambda_u2d7.unaryPlus(" ON ");
                it.appendConditions($this$update_u24lambda_u2d7);
            }
            $this$update_u24lambda_u2d7.unaryPlus(" WHEN MATCHED THEN UPDATE SET ");
            ExpressionKt.appendTo$default(columnsAndValues, $this$update_u24lambda_u2d7, null, null, null, new Function2<QueryBuilder, Pair<? extends Column<?>, ? extends Object>, Unit>(transaction2){
                final /* synthetic */ Transaction $transaction;
                {
                    this.$transaction = $transaction;
                    super(2);
                }

                public final void invoke(@NotNull QueryBuilder $this$appendTo, @NotNull Pair<? extends Column<?>, ? extends Object> pair) {
                    Intrinsics.checkNotNullParameter((Object)$this$appendTo, (String)"$this$appendTo");
                    Intrinsics.checkNotNullParameter(pair, (String)"<name for destructuring parameter 0>");
                    Column col = (Column)pair.component1();
                    Object value2 = pair.component2();
                    $this$appendTo.append(this.$transaction.fullIdentity(col) + '=');
                    $this$appendTo.registerArgument(col, value2);
                }
            }, 14, null);
            Op<Boolean> op = where;
            if (op == null) break block11;
            Op<Boolean> it3 = op;
            boolean bl6 = false;
            $this$update_u24lambda_u2d7.unaryPlus(" WHERE ");
            $this$update_u24lambda_u2d7.unaryPlus((Expression)it3);
        }
        return $this$update_u24lambda_u2d7.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String replace(@NotNull Table table, @NotNull List<? extends Pair<? extends Column<?>, ? extends Object>> data, @NotNull Transaction transaction2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
        if (data.isEmpty()) {
            return "";
        }
        Iterable $this$map$iv = data;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Column)it.getFirst());
        }
        List columns2 = (List)destination$iv$iv;
        QueryBuilder builder = new QueryBuilder(true);
        String sql2 = ExpressionKt.appendTo$default(data, builder, null, "VALUES (", ")", replace.sql.1.INSTANCE, 2, null).toString();
        return StringsKt.replaceFirst$default((String)super.insert(false, table, columns2, sql2, transaction2), (String)"INSERT", (String)"MERGE", (boolean)false, (int)4, null);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[H2Dialect.H2MajorVersion.values().length];
            nArray[H2Dialect.H2MajorVersion.One.ordinal()] = 1;
            nArray[H2Dialect.H2MajorVersion.Two.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

