/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.IDateColumnType;
import org.jetbrains.exposed.sql.LiteralOp;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.vendors.DataTypeProvider;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\f\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b \u0010!J\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0007J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0004J\u000f\u0010\u0010\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0004J\u000f\u0010\u0011\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0004J\u000f\u0010\u0012\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0004J\u000f\u0010\u0013\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0004J\u000f\u0010\u0014\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0004J\u000f\u0010\u0015\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0004J\u001b\u0010\u0018\u001a\u00020\u00022\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001a\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u0004J\u000f\u0010\u001b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u0004J\u000f\u0010\u001c\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u0004J\u000f\u0010\u001d\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u0004J\u000f\u0010\u001e\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u0004J\u000f\u0010\u001f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001f\u0010\u0004\u00a8\u0006\""}, d2={"Lorg/jetbrains/exposed/sql/vendors/OracleDataTypeProvider;", "Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "", "binaryType", "()Ljava/lang/String;", "", "length", "(I)Ljava/lang/String;", "value", "", "booleanFromStringToBoolean", "(Ljava/lang/String;)Z", "bool", "booleanToStatementString", "(Z)Ljava/lang/String;", "booleanType", "byteType", "dateTimeType", "integerAutoincType", "integerType", "longAutoincType", "longType", "Lorg/jetbrains/exposed/sql/Expression;", "e", "processForDefaultValue", "(Lorg/jetbrains/exposed/sql/Expression;)Ljava/lang/String;", "textType", "timeType", "ubyteType", "uintegerType", "ulongType", "uuidType", "<init>", "()V", "exposed-core"})
public final class OracleDataTypeProvider
extends DataTypeProvider {
    @NotNull
    public static final OracleDataTypeProvider INSTANCE = new OracleDataTypeProvider();

    private OracleDataTypeProvider() {
    }

    @Override
    @NotNull
    public String byteType() {
        return "SMALLINT";
    }

    @Override
    @NotNull
    public String ubyteType() {
        return "SMALLINT";
    }

    @Override
    @NotNull
    public String integerType() {
        return "NUMBER(12)";
    }

    @Override
    @NotNull
    public String integerAutoincType() {
        return "NUMBER(12)";
    }

    @Override
    @NotNull
    public String uintegerType() {
        return "NUMBER(13)";
    }

    @Override
    @NotNull
    public String longType() {
        return "NUMBER(19)";
    }

    @Override
    @NotNull
    public String longAutoincType() {
        return "NUMBER(19)";
    }

    @Override
    @NotNull
    public String ulongType() {
        return "NUMBER(20)";
    }

    @Override
    @NotNull
    public String textType() {
        return "CLOB";
    }

    @Override
    @NotNull
    public String timeType() {
        return this.dateTimeType();
    }

    @Override
    @NotNull
    public String binaryType() {
        SQLLogKt.getExposedLogger().error("Binary type is unsupported for Oracle. Please use blob column type instead.");
        throw new IllegalStateException("Binary type is unsupported for Oracle. Please use blob column type instead.".toString());
    }

    @Override
    @NotNull
    public String binaryType(int length) {
        return length < 2000 ? "RAW (" + length + ')' : this.binaryType();
    }

    @Override
    @NotNull
    public String uuidType() {
        return "RAW(16)";
    }

    @Override
    @NotNull
    public String dateTimeType() {
        return "TIMESTAMP";
    }

    @Override
    @NotNull
    public String booleanType() {
        return "CHAR(1)";
    }

    @Override
    @NotNull
    public String booleanToStatementString(boolean bool) {
        return bool ? "1" : "0";
    }

    @Override
    public boolean booleanFromStringToBoolean(@NotNull String value2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        try {
            bl = Long.parseLong(value2) != 0L;
        }
        catch (NumberFormatException ex) {
            throw new IllegalStateException(("Unexpected value of type Boolean: " + value2).toString());
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String processForDefaultValue(@NotNull Expression<?> e) {
        String string;
        Intrinsics.checkNotNullParameter(e, (String)"e");
        if (e instanceof LiteralOp) {
            IColumnType iColumnType = ((LiteralOp)e).getColumnType();
            IDateColumnType iDateColumnType = iColumnType instanceof IDateColumnType ? (IDateColumnType)((Object)iColumnType) : null;
            boolean bl = iDateColumnType != null ? !iDateColumnType.getHasTimePart() : false;
            if (bl) {
                string = "DATE " + super.processForDefaultValue(e);
                return string;
            }
        }
        if (e instanceof LiteralOp && ((LiteralOp)e).getColumnType() instanceof IDateColumnType) {
            string = "TIMESTAMP " + super.processForDefaultValue(e);
            return string;
        }
        string = super.processForDefaultValue(e);
        return string;
    }
}

