/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnDiff;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ReferenceOption;
import org.jetbrains.exposed.sql.Schema;
import org.jetbrains.exposed.sql.SchemaKt;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.SQLServerDataTypeProvider;
import org.jetbrains.exposed.sql.vendors.SQLServerFunctionProvider;
import org.jetbrains.exposed.sql.vendors.VendorDialect;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\f\b\u0016\u0018\u0000 32\u00020\u0001:\u00013B\u0007\u00a2\u0006\u0004\b1\u00102J\u0017\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0005J/\u0010\t\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0005J\u001f\u0010\u0012\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001b\u0010\u0016\u001a\u00020\u00102\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J)\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00020\u001c2\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u001b\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010\u001f\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u001f\u0010\u000eR\u0014\u0010#\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u001a\u0010$\u001a\u00020\u00108\u0016X\u0096D\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'R\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00020(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020\u00108\u0016X\u0096D\u00a2\u0006\f\n\u0004\b+\u0010%\u001a\u0004\b,\u0010'R\u001a\u0010-\u001a\u00020\u00108\u0016X\u0096D\u00a2\u0006\f\n\u0004\b-\u0010%\u001a\u0004\b.\u0010'R\u001a\u0010/\u001a\u00020\u00108\u0016X\u0096D\u00a2\u0006\f\n\u0004\b/\u0010%\u001a\u0004\b0\u0010'\u00a8\u00064"}, d2={"Lorg/jetbrains/exposed/sql/vendors/SQLServerDialect;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect;", "", "name", "createDatabase", "(Ljava/lang/String;)Ljava/lang/String;", "table", "columns", "type", "createIndexWithType", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "Lorg/jetbrains/exposed/sql/Schema;", "schema", "createSchema", "(Lorg/jetbrains/exposed/sql/Schema;)Ljava/lang/String;", "dropDatabase", "", "cascade", "dropSchema", "(Lorg/jetbrains/exposed/sql/Schema;Z)Ljava/lang/String;", "Lorg/jetbrains/exposed/sql/Expression;", "e", "isAllowedAsColumnDefault", "(Lorg/jetbrains/exposed/sql/Expression;)Z", "Lorg/jetbrains/exposed/sql/Column;", "column", "Lorg/jetbrains/exposed/sql/ColumnDiff;", "columnDiff", "", "modifyColumn", "(Lorg/jetbrains/exposed/sql/Column;Lorg/jetbrains/exposed/sql/ColumnDiff;)Ljava/util/List;", "setSchema", "Lorg/jetbrains/exposed/sql/ReferenceOption;", "getDefaultReferenceOption", "()Lorg/jetbrains/exposed/sql/ReferenceOption;", "defaultReferenceOption", "needsQuotesWhenSymbolsInNames", "Z", "getNeedsQuotesWhenSymbolsInNames", "()Z", "", "nonAcceptableDefaults", "[Ljava/lang/String;", "supportsIfNotExists", "getSupportsIfNotExists", "supportsOnlyIdentifiersInGeneratedKeys", "getSupportsOnlyIdentifiersInGeneratedKeys", "supportsSequenceAsGeneratedKeys", "getSupportsSequenceAsGeneratedKeys", "<init>", "()V", "Companion", "exposed-core"})
public class SQLServerDialect
extends VendorDialect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean supportsIfNotExists;
    private final boolean needsQuotesWhenSymbolsInNames;
    private final boolean supportsSequenceAsGeneratedKeys;
    private final boolean supportsOnlyIdentifiersInGeneratedKeys;
    @NotNull
    private final String[] nonAcceptableDefaults;
    @NotNull
    public static final String dialectName = "sqlserver";

    public SQLServerDialect() {
        super(dialectName, SQLServerDataTypeProvider.INSTANCE, SQLServerFunctionProvider.INSTANCE);
        this.supportsOnlyIdentifiersInGeneratedKeys = true;
        String[] stringArray = new String[]{"DEFAULT"};
        this.nonAcceptableDefaults = stringArray;
    }

    @Override
    public boolean getSupportsIfNotExists() {
        return this.supportsIfNotExists;
    }

    @Override
    @NotNull
    public ReferenceOption getDefaultReferenceOption() {
        return ReferenceOption.NO_ACTION;
    }

    @Override
    public boolean getNeedsQuotesWhenSymbolsInNames() {
        return this.needsQuotesWhenSymbolsInNames;
    }

    @Override
    public boolean getSupportsSequenceAsGeneratedKeys() {
        return this.supportsSequenceAsGeneratedKeys;
    }

    @Override
    public boolean getSupportsOnlyIdentifiersInGeneratedKeys() {
        return this.supportsOnlyIdentifiersInGeneratedKeys;
    }

    @Override
    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> e) {
        Intrinsics.checkNotNullParameter(e, (String)"e");
        String string = e.toString().toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        String columnDefault = ((Object)StringsKt.trim((CharSequence)string)).toString();
        return !ArraysKt.contains((Object[])this.nonAcceptableDefaults, (Object)columnDefault);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> modifyColumn(@NotNull Column<?> column, @NotNull ColumnDiff columnDiff) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter((Object)columnDiff, (String)"columnDiff");
        Iterable $this$map$iv = super.modifyColumn(column, columnDiff);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.replace$default((String)it, (String)"MODIFY COLUMN", (String)"ALTER COLUMN", (boolean)false, (int)4, null));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public String createDatabase(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return "CREATE DATABASE " + DefaultKt.inProperCase(name);
    }

    @Override
    @NotNull
    public String dropDatabase(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return "DROP DATABASE " + DefaultKt.inProperCase(name);
    }

    @Override
    @NotNull
    public String setSchema(@NotNull Schema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        return "ALTER USER " + schema.getAuthorization() + " WITH DEFAULT_SCHEMA = " + schema.getIdentifier();
    }

    @Override
    @NotNull
    public String createSchema(@NotNull Schema schema) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        StringBuilder $this$createSchema_u24lambda_u2d1 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String[] stringArray = new String[]{"CREATE SCHEMA ", schema.getIdentifier()};
        StringsKt.append((StringBuilder)$this$createSchema_u24lambda_u2d1, (String[])stringArray);
        SchemaKt.appendIfNotNull($this$createSchema_u24lambda_u2d1, " AUTHORIZATION ", schema.getAuthorization());
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Override
    @NotNull
    public String dropSchema(@NotNull Schema schema, boolean cascade) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        StringBuilder $this$dropSchema_u24lambda_u2d2 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String[] stringArray = new String[]{"DROP SCHEMA ", schema.getIdentifier()};
        StringsKt.append((StringBuilder)$this$dropSchema_u24lambda_u2d2, (String[])stringArray);
        if (cascade) {
            $this$dropSchema_u24lambda_u2d2.append(" CASCADE");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Override
    @NotNull
    protected String createIndexWithType(@NotNull String name, @NotNull String table, @NotNull String columns2, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)columns2, (String)"columns");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return "CREATE " + type + " INDEX " + name + " ON " + table + ' ' + columns2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0003\u001a\u00020\u00028\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/exposed/sql/vendors/SQLServerDialect$Companion;", "", "", "dialectName", "Ljava/lang/String;", "<init>", "()V", "exposed-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

