/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.configurate.transformation;

import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import me.lucko.luckperms.lib.configurate.ConfigurationNode;
import me.lucko.luckperms.lib.configurate.transformation.ChainedConfigurationTransformation;
import me.lucko.luckperms.lib.configurate.transformation.MoveStrategy;
import me.lucko.luckperms.lib.configurate.transformation.NodePathComparator;
import me.lucko.luckperms.lib.configurate.transformation.SingleConfigurationTransformation;
import me.lucko.luckperms.lib.configurate.transformation.TransformAction;
import me.lucko.luckperms.lib.configurate.transformation.VersionedTransformation;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class ConfigurationTransformation {
    public static final Object WILDCARD_OBJECT = new Object();

    public static @NonNull Builder builder() {
        return new Builder();
    }

    public static @NonNull VersionedBuilder versionedBuilder() {
        return new VersionedBuilder();
    }

    public static @NonNull ConfigurationTransformation chain(ConfigurationTransformation ... transformations) {
        return new ChainedConfigurationTransformation(transformations);
    }

    public abstract void apply(@NonNull ConfigurationNode var1);

    public static final class NodePath
    implements me.lucko.luckperms.lib.configurate.transformation.NodePath {
        Object[] arr;

        NodePath() {
        }

        @Override
        public Object get(int i) {
            return this.arr[i];
        }

        @Override
        public int size() {
            return this.arr.length;
        }

        @Override
        public Object[] getArray() {
            return Arrays.copyOf(this.arr, this.arr.length);
        }

        @Override
        public @NonNull Iterator<Object> iterator() {
            return Iterators.forArray((Object[])this.arr);
        }
    }

    public static final class VersionedBuilder {
        private Object[] versionKey = new Object[]{"version"};
        private final SortedMap<Integer, ConfigurationTransformation> versions = new TreeMap<Integer, ConfigurationTransformation>();

        protected VersionedBuilder() {
        }

        public @NonNull VersionedBuilder setVersionKey(Object ... versionKey) {
            this.versionKey = Arrays.copyOf(versionKey, versionKey.length, Object[].class);
            return this;
        }

        public @NonNull VersionedBuilder addVersion(int version, @NonNull ConfigurationTransformation transformation) {
            this.versions.put(version, transformation);
            return this;
        }

        public @NonNull ConfigurationTransformation build() {
            return new VersionedTransformation(this.versionKey, this.versions);
        }
    }

    public static final class Builder {
        private MoveStrategy strategy = MoveStrategy.OVERWRITE;
        private final SortedMap<Object[], TransformAction> actions = new TreeMap<Object[], TransformAction>(new NodePathComparator());

        protected Builder() {
        }

        public @NonNull Builder addAction(Object[] path, TransformAction action) {
            this.actions.put(path, action);
            return this;
        }

        public @NonNull MoveStrategy getMoveStrategy() {
            return this.strategy;
        }

        public @NonNull Builder setMoveStrategy(@NonNull MoveStrategy strategy) {
            this.strategy = strategy;
            return this;
        }

        public @NonNull ConfigurationTransformation build() {
            return new SingleConfigurationTransformation(this.actions, this.strategy);
        }
    }
}

