/*
 * Decompiled with CFR 0.152.
 */
package com.sonicether.soundphysics;

import com.sonicether.soundphysics.SoundPhysics;
import com.sonicether.soundphysics.SoundPhysicsMod;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_243;

public class ReflectedAudio {
    private final List<Map.Entry<class_243, Double>> airspaceDirections;
    @Nullable
    private Map.Entry<class_243, Double> directDirection;
    private final double occlusion;
    private final String sound;
    private int sharedAirspaces;

    public ReflectedAudio(double occlusion, String sound) {
        this.occlusion = occlusion;
        this.sound = sound;
        this.airspaceDirections = new LinkedList<Map.Entry<class_243, Double>>();
    }

    public boolean shouldEvaluateDirection() {
        return SoundPhysicsMod.CONFIG.soundDirectionEvaluation.get() != false && (this.occlusion > 0.0 || SoundPhysicsMod.CONFIG.redirectNonOccludedSounds.get() == false) && !SoundPhysics.isVoicechatSound(this.sound);
    }

    public int getSharedAirspaces() {
        return this.sharedAirspaces;
    }

    public void addDirectAirspace(class_243 sharedAirspaceVector) {
        this.directDirection = Map.entry(sharedAirspaceVector, sharedAirspaceVector.method_1033());
    }

    public void addSharedAirspace(class_243 sharedAirspaceVector, double totalRayDistance) {
        double length = totalRayDistance + sharedAirspaceVector.method_1033();
        if (length <= 0.0 || length > 16.0 / SoundPhysicsMod.CONFIG.attenuationFactor.get()) {
            return;
        }
        ++this.sharedAirspaces;
        if (!this.shouldEvaluateDirection()) {
            return;
        }
        this.airspaceDirections.add(Map.entry(sharedAirspaceVector, length));
    }

    @Nullable
    public class_243 evaluateSoundPosition(class_243 soundPos, class_243 listenerPos) {
        if (!this.shouldEvaluateDirection()) {
            return null;
        }
        if (this.airspaceDirections.isEmpty()) {
            return null;
        }
        class_243 sum = this.directDirection != null ? this.directDirection.getKey().method_1029() : new class_243(0.0, 0.0, 0.0);
        for (Map.Entry<class_243, Double> direction : this.airspaceDirections) {
            double val = direction.getValue();
            if (val <= 0.0) {
                return null;
            }
            double w = 1.0 / (val * val);
            sum = sum.method_1019(direction.getKey().method_1029().method_1021(w));
        }
        return sum.method_1029().method_1021(soundPos.method_1022(listenerPos)).method_1019(listenerPos);
    }
}

