/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.registration.data;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.TagGenerator;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.rechiseled.blocks.RechiseledBlockBuilderImpl;
import com.supermartijn642.rechiseled.blocks.RechiseledBlockTypeImpl;
import com.supermartijn642.rechiseled.registration.RechiseledRegistrationImpl;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3268;
import net.minecraft.class_3286;
import net.minecraft.class_3481;
import net.minecraft.class_6862;

public class RegistrationTagsGenerator
extends TagGenerator {
    private static final Gson GSON = new GsonBuilder().create();
    private static final class_3268 VANILLA_RESOURCES = class_3286.method_45287();
    private final RechiseledRegistrationImpl registration;
    private final Map<class_2960, List<class_2248>> loadedTags = Maps.newHashMap();

    public RegistrationTagsGenerator(RechiseledRegistrationImpl registration, ResourceCache cache) {
        super(registration.getModid(), cache);
        this.registration = registration;
    }

    public void generate() {
        if (!this.registration.providersRegistered) {
            return;
        }
        this.registration.getBlockBuilders().forEach(pair -> {
            RechiseledBlockBuilderImpl builder = (RechiseledBlockBuilderImpl)pair.left();
            RechiseledBlockTypeImpl type = (RechiseledBlockTypeImpl)pair.right();
            if (type.hasRegularVariant()) {
                this.addTags(builder, type.getRegularBlock());
            }
            if (type.hasConnectingVariant()) {
                this.addTags(builder, type.getConnectingBlock());
            }
        });
    }

    private void addTags(RechiseledBlockBuilderImpl builder, class_2248 block) {
        builder.tags.stream().map(x$0 -> this.blockTag((class_2960)x$0)).forEach(tag -> tag.add((Object)block));
        if (builder.miningTagsFromBlock != null) {
            this.getTagsForBlock(builder.miningTagsFromBlock).stream().map(x$0 -> this.blockTag((class_2960)x$0)).forEach(tag -> tag.add((Object)block));
        }
    }

    private Set<class_2960> getTagsForBlock(Supplier<class_2248> block) {
        return Stream.of(class_3481.field_33713, class_3481.field_33714, class_3481.field_33715, class_3481.field_33716, class_3481.field_33719, class_3481.field_33718, class_3481.field_33717).map(class_6862::comp_327).filter(tag -> this.loadVanillaTag((class_2960)tag).contains(block.get())).collect(Collectors.toSet());
    }

    private List<class_2248> loadVanillaTag(class_2960 location) {
        if (this.loadedTags.containsKey(location)) {
            return this.loadedTags.get(location);
        }
        ArrayList<class_2248> blocks = new ArrayList<class_2248>();
        class_2960 tagLocation = new class_2960(location.method_12836(), "tags/blocks/" + location.method_12832() + ".json");
        try (InputStream stream = (InputStream)VANILLA_RESOURCES.method_14405(class_3264.field_14190, tagLocation).get();){
            JsonObject json = (JsonObject)GSON.fromJson((Reader)new InputStreamReader(stream), JsonObject.class);
            JsonArray array = json.getAsJsonArray("values");
            for (JsonElement element : array) {
                String name = element.getAsString();
                if (name.charAt(0) == '#') {
                    blocks.addAll(this.loadVanillaTag(new class_2960(name.substring(1))));
                    continue;
                }
                class_2960 registryName = new class_2960(name);
                class_2248 block = (class_2248)Registries.BLOCKS.getValue(registryName);
                if (block == null) {
                    throw new JsonParseException("Unknown block '" + registryName + "' in '" + location + "'");
                }
                blocks.add(block);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.loadedTags.put(location, blocks);
        return blocks;
    }

    public String getName() {
        return "Registration Tag Generator: " + this.modName;
    }
}

